/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.forge.dynresources;

import com.google.common.collect.ForwardingMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.MutableGraph;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.IModInfo;
import org.embeddedt.modernfix.ModernFix;
import org.embeddedt.modernfix.util.ForwardingInclDefaultsMap;
import org.jetbrains.annotations.Nullable;

public class ModelBakeEventHelper {
    private static final Map<String, UniverseVisibility> MOD_VISIBILITY_CONFIGURATION = ImmutableMap.builder().build();
    private final Map<ResourceLocation, BakedModel> modelRegistry;
    private final Set<ResourceLocation> topLevelModelLocations;
    private final MutableGraph<String> dependencyGraph;
    private static final Set<String> WARNED_MOD_IDS = new HashSet<String>();

    public ModelBakeEventHelper(Map<ResourceLocation, BakedModel> modelRegistry) {
        this.modelRegistry = modelRegistry;
        this.topLevelModelLocations = new ObjectLinkedOpenHashSet(Block.f_49791_.m_13562_() + BuiltInRegistries.f_257033_.m_13562_());
        BuiltInRegistries.f_256975_.m_6579_().forEach(entry -> {
            ResourceLocation location = ((ResourceKey)entry.getKey()).m_135782_();
            for (BlockState state : ((Block)entry.getValue()).m_49965_().m_61056_()) {
                this.topLevelModelLocations.add((ResourceLocation)BlockModelShaper.m_110889_((ResourceLocation)location, (BlockState)state));
            }
        });
        BuiltInRegistries.f_257033_.m_6566_().forEach(key -> this.topLevelModelLocations.add((ResourceLocation)new ModelResourceLocation(key, "inventory")));
        this.topLevelModelLocations.addAll(modelRegistry.keySet());
        this.dependencyGraph = ModelBakeEventHelper.buildDependencyGraph();
    }

    private static MutableGraph<String> buildDependencyGraph() {
        MutableGraph dependencyGraph = GraphBuilder.undirected().build();
        ModList.get().forEachModContainer((id, mc) -> {
            dependencyGraph.addNode(id);
            for (IModInfo.ModVersion version : mc.getModInfo().getDependencies()) {
                dependencyGraph.addNode((Object)version.getModId());
            }
        });
        for (String id2 : dependencyGraph.nodes()) {
            Optional mContainer = ModList.get().getModContainerById(id2);
            if (!mContainer.isPresent()) continue;
            for (IModInfo.ModVersion version : ((ModContainer)mContainer.get()).getModInfo().getDependencies()) {
                if (Objects.equals(id2, version.getModId())) continue;
                dependencyGraph.putEdge((Object)id2, (Object)version.getModId());
            }
        }
        return dependencyGraph;
    }

    private Map<ResourceLocation, BakedModel> createWarningRegistry(final String modId) {
        return new ForwardingInclDefaultsMap<ResourceLocation, BakedModel>(){

            protected Map<ResourceLocation, BakedModel> delegate() {
                return ModelBakeEventHelper.this.modelRegistry;
            }

            private void logWarning() {
                if (!WARNED_MOD_IDS.add(modId)) {
                    return;
                }
                ModernFix.LOGGER.warn("Mod '{}' is accessing Map#keySet/entrySet/values/replaceAll on the model registry map inside its event handler. This probably won't work as expected with dynamic resources on. Prefer using Map#get/put and constructing ModelResourceLocations another way.", (Object)modId);
            }

            public Set<ResourceLocation> keySet() {
                this.logWarning();
                return super.keySet();
            }

            public Set<Map.Entry<ResourceLocation, BakedModel>> entrySet() {
                this.logWarning();
                return super.entrySet();
            }

            public Collection<BakedModel> values() {
                this.logWarning();
                return super.values();
            }

            @Override
            public void replaceAll(BiFunction<? super ResourceLocation, ? super BakedModel, ? extends BakedModel> function) {
                this.logWarning();
                super.replaceAll(function);
            }
        };
    }

    public Map<ResourceLocation, BakedModel> wrapRegistry(String modId) {
        Set ourModelLocations;
        UniverseVisibility config = MOD_VISIBILITY_CONFIGURATION.getOrDefault(modId, UniverseVisibility.EVERYTHING);
        if (config == UniverseVisibility.NONE) {
            return this.createWarningRegistry(modId);
        }
        HashSet<String> modIdsToInclude = new HashSet<String>();
        modIdsToInclude.add(modId);
        try {
            modIdsToInclude.addAll(this.dependencyGraph.adjacentNodes((Object)modId));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        modIdsToInclude.remove("minecraft");
        if (config == UniverseVisibility.SELF_AND_DEPS) {
            ModernFix.LOGGER.debug("Mod {} is restricted to seeing models from mods: [{}]", (Object)modId, (Object)String.join((CharSequence)", ", modIdsToInclude));
            ourModelLocations = Sets.filter(this.topLevelModelLocations, loc -> modIdsToInclude.contains(loc.m_135827_()));
        } else {
            ourModelLocations = this.topLevelModelLocations;
        }
        BakedModel missingModel = this.modelRegistry.get(ModelBakery.f_119230_);
        return new EmulatedModelRegistry(modId, modIdsToInclude, missingModel, ourModelLocations);
    }

    private static enum UniverseVisibility {
        NONE,
        SELF_AND_DEPS,
        EVERYTHING;

    }

    public class EmulatedModelRegistry
    extends ForwardingMap<ResourceLocation, BakedModel> {
        private final Set<String> modIdsToInclude;
        private final BakedModel missingModel;
        private final Set<ResourceLocation> ourModelLocations;
        private final String modId;

        private EmulatedModelRegistry(String modId, Set<String> modIdsToInclude, BakedModel missingModel, Set<ResourceLocation> ourModelLocations) {
            this.modId = modId;
            this.modIdsToInclude = modIdsToInclude;
            this.missingModel = missingModel;
            this.ourModelLocations = ourModelLocations;
        }

        protected Map<ResourceLocation, BakedModel> delegate() {
            return ModelBakeEventHelper.this.modelRegistry;
        }

        public BakedModel get(@Nullable Object key) {
            BakedModel model = (BakedModel)super.get(key);
            if (model == null && key != null && this.modIdsToInclude.contains(((ResourceLocation)key).m_135827_())) {
                ModernFix.LOGGER.warn("Model {} is missing, but was requested in model bake event. Returning missing model", key);
                return this.missingModel;
            }
            return model;
        }

        public Set<ResourceLocation> keySet() {
            return Collections.unmodifiableSet(this.ourModelLocations);
        }

        public boolean containsKey(@Nullable Object key) {
            return this.ourModelLocations.contains(key) || super.containsKey(key);
        }

        public Set<Map.Entry<ResourceLocation, BakedModel>> entrySet() {
            return new DynamicModelEntrySet((Map<ResourceLocation, BakedModel>)((Object)this), this.ourModelLocations);
        }

        public void replaceAll(BiFunction<? super ResourceLocation, ? super BakedModel, ? extends BakedModel> function) {
            ModernFix.LOGGER.warn("Mod '{}' is calling replaceAll on the model registry. Some hacks will be used to keep this fast, but they may not be 100% compatible.", (Object)this.modId);
            ArrayList<ResourceLocation> locations = new ArrayList<ResourceLocation>(this.ourModelLocations);
            for (ResourceLocation location : locations) {
                BakedModel existing;
                BakedModel replacement;
                boolean needsReplacement;
                try {
                    needsReplacement = function.apply((ResourceLocation)location, null) != null;
                }
                catch (Throwable e) {
                    needsReplacement = true;
                }
                if (!needsReplacement || (replacement = function.apply((ResourceLocation)location, (BakedModel)(existing = this.get(location)))) == existing) continue;
                this.put(location, replacement);
            }
        }
    }

    private static class DynamicModelEntrySet
    extends AbstractSet<Map.Entry<ResourceLocation, BakedModel>> {
        private final Map<ResourceLocation, BakedModel> modelRegistry;
        private final Set<ResourceLocation> modelLocations;

        private DynamicModelEntrySet(Map<ResourceLocation, BakedModel> modelRegistry, Set<ResourceLocation> modelLocations) {
            this.modelRegistry = modelRegistry;
            this.modelLocations = modelLocations;
        }

        @Override
        public Iterator<Map.Entry<ResourceLocation, BakedModel>> iterator() {
            final Iterator<ResourceLocation> iter = this.modelLocations.iterator();
            return new Iterator<Map.Entry<ResourceLocation, BakedModel>>(){

                @Override
                public boolean hasNext() {
                    return iter.hasNext();
                }

                @Override
                public Map.Entry<ResourceLocation, BakedModel> next() {
                    return new DynamicModelEntry((ResourceLocation)iter.next());
                }
            };
        }

        @Override
        public boolean contains(Object o) {
            if (o instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)o;
                return this.modelRegistry.containsKey(entry.getKey());
            }
            return false;
        }

        @Override
        public int size() {
            return this.modelRegistry.size();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        private class DynamicModelEntry
        implements Map.Entry<ResourceLocation, BakedModel> {
            private final ResourceLocation location;

            private DynamicModelEntry(ResourceLocation location) {
                this.location = location;
            }

            @Override
            public ResourceLocation getKey() {
                return this.location;
            }

            @Override
            public BakedModel getValue() {
                return DynamicModelEntrySet.this.modelRegistry.get(this.location);
            }

            @Override
            public BakedModel setValue(BakedModel value) {
                return DynamicModelEntrySet.this.modelRegistry.put(this.location, value);
            }
        }
    }
}

