/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.resources;

import com.google.common.base.Joiner;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import org.embeddedt.modernfix.ModernFix;
import org.embeddedt.modernfix.util.PackTypeHelper;
import org.jetbrains.annotations.Nullable;

public class PackResourcesCacheEngine {
    private static final Joiner SLASH_JOINER = Joiner.on((char)'/');
    private static final Node EMPTY = new Node();
    private final Node root = new Node();
    private final Map<PackType, Path> rootPathsByType = new Object2ObjectOpenHashMap();
    private volatile boolean cacheGenerationFlag = false;
    private List<Runnable> cacheGenerationTasks = new ArrayList<Runnable>();
    private Path debugPath;

    public PackResourcesCacheEngine(Function<PackType, Path> basePathRetriever) {
        this.debugPath = basePathRetriever.apply(PackType.CLIENT_RESOURCES).toAbsolutePath();
        this.root.children = new Object2ObjectOpenHashMap();
        ObjectOpenHashSet pathKeys = new ObjectOpenHashSet();
        for (PackType type : PackType.values()) {
            Node typeRoot = new Node();
            this.root.children.put(type.m_10305_(), typeRoot);
            Path root = basePathRetriever.apply(type);
            this.rootPathsByType.put(type, root);
            this.cacheGenerationTasks.add(() -> {
                try (Stream<Path> stream = Files.find(root, Integer.MAX_VALUE, (p, a) -> a.isRegularFile(), new FileVisitOption[0]);){
                    stream.map(path -> root.relativize(path.toAbsolutePath())).filter(PackResourcesCacheEngine::isValidCachedResourcePath).forEach(path -> {
                        Node node = typeRoot;
                        for (Path component : path) {
                            String key = (String)pathKeys.addOrGet((Object)component.toString());
                            if (node.children == null) {
                                node.children = new Object2ObjectOpenHashMap();
                            }
                            node = node.children.computeIfAbsent(key, $ -> new Node());
                        }
                    });
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
        }
        this.cacheGenerationTasks.add(this.root::optimize);
    }

    private static boolean isValidCachedResourcePath(Path path) {
        if (path.getFileName() == null || path.getNameCount() == 0) {
            return false;
        }
        String str = SLASH_JOINER.join((Iterable)path);
        if (str.length() == 0) {
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            if (ResourceLocation.m_135828_((char)str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public Set<String> getNamespaces(PackType type) {
        this.awaitLoad();
        if (PackTypeHelper.isVanillaPackType(type)) {
            return this.root.getChild((String)type.m_10305_()).children.keySet();
        }
        return null;
    }

    private void doGenerateCache() {
        Stopwatch watch = Stopwatch.createStarted();
        for (Runnable r : this.cacheGenerationTasks) {
            r.run();
        }
        watch.stop();
        ModernFix.LOGGER.debug("Generated cache for {} in {}", (Object)this.debugPath, (Object)watch);
        this.debugPath = null;
        this.cacheGenerationTasks = ImmutableList.of();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void awaitLoad() {
        if (!this.cacheGenerationFlag) {
            PackResourcesCacheEngine packResourcesCacheEngine = this;
            synchronized (packResourcesCacheEngine) {
                if (!this.cacheGenerationFlag) {
                    this.doGenerateCache();
                    this.cacheGenerationFlag = true;
                }
            }
        }
    }

    public boolean hasResource(String[] paths) {
        this.awaitLoad();
        Node node = this.root;
        for (String path : paths) {
            if (path.isEmpty() || (node = node.children.get(path)) != null) continue;
            return false;
        }
        return true;
    }

    public void collectResources(PackType type, String resourceNamespace, String[] components, int maxDepth, PackResources.ResourceOutput output) {
        if (!PackTypeHelper.isVanillaPackType(type)) {
            throw new IllegalArgumentException("Only vanilla PackTypes are supported");
        }
        this.awaitLoad();
        Node node = this.root.getChild(type.m_10305_());
        if (node == null) {
            return;
        }
        if ((node = node.getChild(resourceNamespace)) == null) {
            return;
        }
        node.collectResources(resourceNamespace, this.rootPathsByType.get(type).resolve(resourceNamespace), components, 0, maxDepth, output);
    }

    static class Node {
        Map<String, Node> children;

        Node() {
        }

        void optimize() {
            if (this.children != null) {
                for (Map.Entry<String, Node> entry : this.children.entrySet()) {
                    Node oldNode = entry.getValue();
                    oldNode.optimize();
                    if (oldNode.children != null) continue;
                    entry.setValue(EMPTY);
                }
                this.children = Map.copyOf(this.children);
            } else {
                this.children = Map.of();
            }
        }

        void collectResources(String namespace, Path baseNioPath, String[] pathComponents, int curIndex, int maxDepth, PackResources.ResourceOutput output) {
            if (curIndex > maxDepth) {
                return;
            }
            if (curIndex < pathComponents.length) {
                String component;
                while ((component = pathComponents[curIndex]).isEmpty()) {
                    ++curIndex;
                    ++maxDepth;
                }
                Node n = this.getChild(component);
                if (n != null) {
                    n.collectResources(namespace, baseNioPath, pathComponents, curIndex + 1, maxDepth, output);
                }
            } else {
                this.outputResources(namespace, baseNioPath, String.join((CharSequence)"/", pathComponents), output);
            }
        }

        void outputResources(String namespace, Path baseNioPath, String path, PackResources.ResourceOutput output) {
            if (this.children.isEmpty()) {
                ResourceLocation location = new ResourceLocation(namespace, path);
                output.accept((Object)location, () -> Files.newInputStream(baseNioPath.resolve(path), new OpenOption[0]));
            } else {
                for (Map.Entry<String, Node> entry : this.children.entrySet()) {
                    entry.getValue().outputResources(namespace, baseNioPath, path + "/" + entry.getKey(), output);
                }
            }
        }

        @Nullable
        Node getChild(String name) {
            return this.children.get(name);
        }
    }
}

