/*
 * Decompiled with CFR 0.152.
 */
package naqaden.namepain;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.UUID;
import naqaden.namepain.NamePain;
import naqaden.namepain.Util;
import naqaden.namepain.config.Config;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.Team;
import net.minecraftforge.client.event.RenderNameTagEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.joml.Matrix4f;

public class NameplateRenderer {
    private static EntityRenderDispatcher renderManager;
    private static Font fontRenderer;
    private static float strHalfWidth;
    private static Matrix4f matrix;
    private static LivingEntity entityLE;
    private static PlayerTeam teamLE;
    private static UUID uuidLEOwner;
    private static Component nameLE;
    private static AbstractClientPlayer entityPE;
    private static LocalPlayer entityMe;
    private static UUID uuidMe;
    private static PlayerTeam teamMe;
    private static Scoreboard scoreboard;
    private static Objective scoreobjective;
    private static boolean isStanding;
    private static boolean isVisible;
    private static boolean canRenderName;
    private static double renderHeight;
    private static double distanceSq;
    private static float distanceStandingSq;
    private static float distanceSneakingSq;
    private static MutableComponent strHeart_;
    private static MutableComponent str_Heart;
    private static float health;
    private static float healthInv;
    private static float strR;
    private static float strG;
    private static float strB;
    private static float strA;
    private static float strScaleV;
    private static int strRGBA;
    private static int strRGBAFaded;
    private static float bgR;
    private static float bgG;
    private static float bgB;
    private static float bgScaleV;
    private static int bgRGBA;

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onRenderNameplate(RenderNameTagEvent event) {
        if (event.getResult() == Event.Result.DENY) {
            return;
        }
        if (event.getEntity() instanceof ItemFrame) {
            if (!Config.seeFrameNames.get()) {
                event.setResult(Event.Result.DENY);
            }
            return;
        }
        if (event.getEntity() instanceof ArmorStand) {
            return;
        }
        if (!(event.getEntity() instanceof LivingEntity)) {
            return;
        }
        if (renderManager == null) {
            renderManager = Minecraft.m_91087_().m_91290_();
        }
        entityLE = (LivingEntity)event.getEntity();
        if (Minecraft.m_91087_().f_91074_ == null) {
            return;
        }
        entityMe = Minecraft.m_91087_().f_91074_;
        if (uuidMe == null) {
            uuidMe = UUIDUtil.m_235875_((GameProfile)entityMe.m_36316_());
        }
        isStanding = !entityLE.m_20163_();
        distanceSq = entityMe.m_20280_((Entity)entityLE);
        if (NamePain.keyShowCulled.m_90857_() && distanceStandingSq != 4096.0f) {
            distanceStandingSq = 4096.0f;
            distanceSneakingSq = 1024.0f;
        } else if (!NamePain.keyShowCulled.m_90857_() && (float)Config.visibleRangeSq != distanceStandingSq) {
            distanceStandingSq = Config.visibleRangeSq;
            distanceSneakingSq = Config.visibleRangeSq < 1024 ? (float)Config.visibleRangeSq : 1024.0f;
        }
        float f = isStanding ? distanceStandingSq : distanceSneakingSq;
        if (distanceSq < (double)f) {
            isVisible = !entityLE.m_20177_((Player)entityMe);
            teamLE = Util.getTeam(entityLE);
            try {
                uuidLEOwner = entityLE instanceof TamableAnimal ? ((TamableAnimal)entityLE).m_21805_() : null;
            }
            catch (IllegalArgumentException iax) {
                uuidLEOwner = null;
            }
            if (uuidLEOwner != null && teamLE == null) {
                teamLE = Util.getTeam((LivingEntity)Util.UUIDToPlayer(entityLE.m_9236_(), uuidLEOwner));
            }
            if (teamLE != null && entityLE != entityMe) {
                teamMe = Util.getTeam((LivingEntity)entityMe);
                switch (teamLE.m_7470_()) {
                    case ALWAYS: {
                        canRenderName = isVisible;
                        break;
                    }
                    case NEVER: {
                        event.setResult(Event.Result.DENY);
                        return;
                    }
                    case HIDE_FOR_OTHER_TEAMS: {
                        canRenderName = teamMe == null ? isVisible : teamLE.m_83536_((Team)teamMe) && (teamLE.m_6259_() || isVisible);
                        break;
                    }
                    case HIDE_FOR_OWN_TEAM: {
                        canRenderName = teamMe == null ? isVisible : !teamLE.m_83536_((Team)teamMe) && isVisible;
                        break;
                    }
                    default: {
                        canRenderName = true;
                    }
                }
                canRenderName = canRenderName && (Minecraft.m_91404_() || Config.namesWithoutHUD.get());
            } else {
                boolean bl = canRenderName = (Minecraft.m_91404_() || Config.namesWithoutHUD.get()) && isVisible && !entityLE.m_20160_();
            }
            if (NameplateRenderer.shouldRenderNameplate(event.getPackedLight())) {
                nameLE = event.getContent();
                if (fontRenderer == null) {
                    fontRenderer = event.getEntityRenderer().m_114481_();
                }
                renderHeight = (double)entityLE.m_20206_() + 0.5;
                health = entityLE.m_21223_() / entityLE.m_21233_();
                healthInv = 1.0f - health;
                strR = (float)Config.nameMaxR.get() * health + (float)Config.nameMinR.get() * healthInv;
                strG = (float)Config.nameMaxG.get() * health + (float)Config.nameMinG.get() * healthInv;
                strB = (float)Config.nameMaxB.get() * health + (float)Config.nameMinB.get() * healthInv;
                strA = (float)Config.nameMaxA.get() * health + (float)Config.nameMinA.get() * healthInv;
                strScaleV = (Config.nameMaxV * health + Config.nameMinV * healthInv) / Util.getVibrancy(strR, strG, strB);
                strRGBA = ((int)(strR * strScaleV) & 0xFF) << 16 | ((int)(strG * strScaleV) & 0xFF) << 8 | (int)(strB * strScaleV) & 0xFF;
                strRGBAFaded = ((int)(strA < 32.1f ? 4.1f : strA * 0.1255f) & 0xFF) << 24 | strRGBA;
                strRGBA = ((int)(strA < 4.1f ? 4.1f : strA) & 0xFF) << 24 | strRGBA;
                bgR = (float)Config.plateMaxR.get() * health + (float)Config.plateMinR.get() * healthInv;
                bgG = (float)Config.plateMaxG.get() * health + (float)Config.plateMinG.get() * healthInv;
                bgB = (float)Config.plateMaxB.get() * health + (float)Config.plateMinB.get() * healthInv;
                bgScaleV = (Config.plateMaxV * health + Config.plateMinV * healthInv) / Util.getVibrancy(bgR, bgG, bgB);
                bgRGBA = ((int)((float)Config.plateMaxA.get() * health + (float)Config.plateMinA.get() * healthInv) & 0xFF) << 24 | ((int)(bgR * bgScaleV) & 0xFF) << 16 | ((int)(bgG * bgScaleV) & 0xFF) << 8 | (int)(bgB * bgScaleV) & 0xFF;
                if (entityLE instanceof AbstractClientPlayer) {
                    entityPE = (AbstractClientPlayer)entityLE;
                    if (distanceSq < 100.0 && (scoreobjective = (scoreboard = entityPE.m_9236_().m_6188_()).m_83416_(2)) != null) {
                        if (Config.applyToScores.get()) {
                            NameplateRenderer.drawNameplate(NameplateRenderer.formatScore(entityPE, scoreboard, scoreobjective, Config.stripFormat.get()), strRGBA, strRGBAFaded, bgRGBA, event.getPoseStack(), event.getMultiBufferSource(), event.getPackedLight());
                        } else {
                            NameplateRenderer.drawNameplate(NameplateRenderer.formatScore(entityPE, scoreboard, scoreobjective, false), isStanding ? -1 : 0x20FFFFFF, 0x20FFFFFF, 0x40000000, event.getPoseStack(), event.getMultiBufferSource(), event.getPackedLight());
                        }
                        renderHeight += 0.25875;
                    }
                    if (Config.applyToPlayers.get()) {
                        NameplateRenderer.drawNameplate(NameplateRenderer.formatName(nameLE, null), strRGBA, strRGBAFaded, bgRGBA, event.getPoseStack(), event.getMultiBufferSource(), event.getPackedLight());
                    } else {
                        NameplateRenderer.drawNameplate(NameplateRenderer.formatName(nameLE, null), isStanding ? -1 : 0x20FFFFFF, 0x20FFFFFF, 0x40000000, event.getPoseStack(), event.getMultiBufferSource(), event.getPackedLight());
                    }
                } else if (Config.applyToMobs.get()) {
                    if (nameLE != Component.f_130760_) {
                        NameplateRenderer.drawNameplate(NameplateRenderer.formatName(nameLE, null), strRGBA, strRGBAFaded, bgRGBA, event.getPoseStack(), event.getMultiBufferSource(), event.getPackedLight());
                    } else {
                        NameplateRenderer.drawNameplate(NameplateRenderer.formatName(entityLE.m_6095_().m_20676_(), teamLE), strRGBA, strRGBAFaded, bgRGBA, event.getPoseStack(), event.getMultiBufferSource(), event.getPackedLight());
                    }
                } else if (nameLE != Component.f_130760_) {
                    NameplateRenderer.drawNameplate(NameplateRenderer.formatName(nameLE, null), isStanding ? -1 : 0x20FFFFFF, 0x20FFFFFF, 0x40000000, event.getPoseStack(), event.getMultiBufferSource(), event.getPackedLight());
                }
            }
        }
        event.setResult(Event.Result.DENY);
    }

    private static boolean shouldRenderNameplate(int packedLight) {
        if (canRenderName) {
            if (Config.playerClass.isInstance(entityLE)) {
                return !(entityLE instanceof LocalPlayer ? packedLight == 0xF000F0 : !Config.playersAlwaysNamed.get() && entityLE != NameplateRenderer.renderManager.f_114359_);
            }
            if (Config.seeInjuredNames.get() && distanceSq <= 25.0 && entityLE.m_21223_() < entityLE.m_21233_() && !(entityLE instanceof AbstractClientPlayer) && (entityLE == NameplateRenderer.renderManager.f_114359_ || Config.injuredAlwaysNamed.get() && entityMe.m_142582_((Entity)entityLE))) {
                return true;
            }
            if (entityLE.m_8077_()) {
                if (entityLE.m_20151_() || entityLE == NameplateRenderer.renderManager.f_114359_) {
                    return true;
                }
                if (Config.tamesAlwaysNamed.get() && Util.equalUUIDs(uuidLEOwner, uuidMe)) {
                    return true;
                }
                if (Config.horsesAlwaysNamed.get() && entityLE instanceof AbstractHorse && ((AbstractHorse)entityLE).m_30614_()) {
                    return true;
                }
                if (Config.villagersAlwaysNamed.get() && entityLE instanceof AbstractVillager) {
                    return true;
                }
                if (Config.golemsAlwaysNamed.get() && entityLE instanceof IronGolem) {
                    return true;
                }
            }
        }
        return false;
    }

    private static FormattedCharSequence formatScore(AbstractClientPlayer player, Scoreboard board, Objective objective, boolean stripFormat) {
        if (stripFormat) {
            return Component.m_237113_((String)(board.m_83471_(player.m_36316_().getName(), objective).m_83400_() + " " + objective.m_83322_().getString())).m_7532_();
        }
        return Component.m_237113_((String)(board.m_83471_(player.m_36316_().getName(), objective).m_83400_() + " ")).m_7220_(objective.m_83322_()).m_7532_();
    }

    private static FormattedCharSequence formatName(Component name, PlayerTeam team) {
        if (!(team == null || nameLE != Component.f_130760_ && entityLE instanceof TamableAnimal)) {
            name = team.m_6870_(name);
        }
        if (Config.stripFormat.get()) {
            name = Component.m_237113_((String)name.getString());
        }
        if (Config.doValentines.get()) {
            name = strHeart_.m_6879_().m_7220_(name).m_7220_((Component)str_Heart);
        } else if (Config.doAprilFools.get()) {
            name = name.m_6881_().m_130940_(ChatFormatting.OBFUSCATED);
        }
        return name.m_7532_();
    }

    private static void drawNameplate(FormattedCharSequence txt, int strRGBA, int strRGBAFaded, int bgRGBA, PoseStack matrixStack, MultiBufferSource renderBuffer, int packedLight) {
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.0, renderHeight, 0.0);
        matrixStack.m_252781_(renderManager.m_253208_());
        matrixStack.m_85841_(-0.025f, -0.025f, 0.025f);
        matrix = matrixStack.m_85850_().m_252922_();
        strHalfWidth = -fontRenderer.m_92724_(txt) / 2;
        fontRenderer.m_272191_(txt, strHalfWidth, 0.0f, strRGBAFaded, false, matrix, renderBuffer, isStanding ? Font.DisplayMode.SEE_THROUGH : Font.DisplayMode.NORMAL, bgRGBA, packedLight);
        if (isStanding) {
            fontRenderer.m_272191_(txt, strHalfWidth, 0.0f, strRGBA, false, matrix, renderBuffer, Font.DisplayMode.NORMAL, 0, packedLight);
        }
        matrixStack.m_85849_();
    }

    static {
        isStanding = true;
        isVisible = true;
        canRenderName = false;
        renderHeight = 0.0;
        distanceSq = 0.0;
        distanceStandingSq = 4096.0f;
        distanceSneakingSq = 1024.0f;
        strHeart_ = Component.m_237113_((String)(ChatFormatting.RED.toString() + "\u2764 " + ChatFormatting.RESET.toString()));
        str_Heart = Component.m_237113_((String)(ChatFormatting.RESET.toString() + ChatFormatting.RED.toString() + " \u2764" + ChatFormatting.RESET.toString()));
        health = 1.0f;
        healthInv = 0.0f;
        strR = 255.0f;
        strG = 255.0f;
        strB = 255.0f;
        strA = 255.0f;
        strScaleV = 255.0f;
        strRGBA = -1;
        strRGBAFaded = 0x20FFFFFF;
        bgR = 0.0f;
        bgG = 0.0f;
        bgB = 0.0f;
        bgScaleV = 0.0f;
        bgRGBA = 0x40000000;
    }
}

