/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.brewery.core.registry;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.satisfy.brewery.client.model.BrewfestBootsModel;
import net.satisfy.brewery.client.model.BrewfestChestplateModel;
import net.satisfy.brewery.client.model.BrewfestHatModel;
import net.satisfy.brewery.client.model.BrewfestLeggingsModel;
import net.satisfy.brewery.core.item.BrewfestBootsItem;
import net.satisfy.brewery.core.item.BrewfestChestItem;
import net.satisfy.brewery.core.item.BrewfestHatItem;
import net.satisfy.brewery.core.item.BrewfestLegsItem;
import net.satisfy.brewery.core.registry.ObjectRegistry;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class ArmorRegistry {
    private static final Map<Item, BrewfestHatModel<?>> models = new HashMap();
    private static final Map<Item, BrewfestChestplateModel<?>> chestplateModels = new HashMap();
    private static final Map<Item, BrewfestLeggingsModel<?>> leggingsModels = new HashMap();
    private static final Map<Item, BrewfestBootsModel<?>> bootsModels = new HashMap();

    public static Model getHatModel(Item item, ModelPart baseHead) {
        EntityModelSet modelSet = Minecraft.m_91087_().m_167973_();
        BrewfestHatModel model = models.computeIfAbsent(item, key -> {
            if (key == ObjectRegistry.BREWFEST_HAT_RED.get() || key == ObjectRegistry.BREWFEST_HAT.get()) {
                return new BrewfestHatModel(modelSet.m_171103_(BrewfestHatModel.LAYER_LOCATION));
            }
            return null;
        });
        if (model != null) {
            model.copyHead(baseHead);
        }
        return model;
    }

    public static Model getChestplateModel(Item item, ModelPart body, ModelPart leftArm, ModelPart rightArm, ModelPart leftLeg, ModelPart rightLeg) {
        BrewfestChestplateModel model = chestplateModels.computeIfAbsent(item, key -> {
            if (key == ObjectRegistry.BREWFEST_BLOUSE.get() || key == ObjectRegistry.BREWFEST_REGALIA.get()) {
                return new BrewfestChestplateModel(Minecraft.m_91087_().m_167973_().m_171103_(BrewfestChestplateModel.LAYER_LOCATION));
            }
            return null;
        });
        if (model != null) {
            model.copyBody(body, leftArm, rightArm, leftLeg, rightLeg);
        }
        return model;
    }

    public static Model getLeggingsModel(Item item, ModelPart rightLeg, ModelPart leftLeg) {
        BrewfestLeggingsModel model = leggingsModels.computeIfAbsent(item, key -> {
            if (key == ObjectRegistry.BREWFEST_DRESS.get() || key == ObjectRegistry.BREWFEST_TROUSERS.get()) {
                return new BrewfestLeggingsModel(Minecraft.m_91087_().m_167973_().m_171103_(BrewfestLeggingsModel.LAYER_LOCATION));
            }
            return null;
        });
        if (model != null) {
            model.copyLegs(rightLeg, leftLeg);
        }
        return model;
    }

    public static Model getBootsModel(Item item, ModelPart rightLeg, ModelPart leftLeg) {
        BrewfestBootsModel model = bootsModels.computeIfAbsent(item, key -> {
            if (key == ObjectRegistry.BREWFEST_BOOTS.get() || key == ObjectRegistry.BREWFEST_SHOES.get()) {
                return new BrewfestBootsModel(Minecraft.m_91087_().m_167973_().m_171103_(BrewfestBootsModel.LAYER_LOCATION));
            }
            return null;
        });
        if (model != null) {
            model.copyLegs(rightLeg, leftLeg);
        }
        return model;
    }

    public static void appendToolTip(@NotNull List<Component> tooltip) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        ItemStack helmet = player.m_6844_(EquipmentSlot.HEAD);
        ItemStack chestplate = player.m_6844_(EquipmentSlot.CHEST);
        ItemStack leggings = player.m_6844_(EquipmentSlot.LEGS);
        ItemStack boots = player.m_6844_(EquipmentSlot.FEET);
        boolean hasFullSet = helmet.m_41720_() instanceof BrewfestHatItem && chestplate.m_41720_() instanceof BrewfestChestItem && leggings.m_41720_() instanceof BrewfestLegsItem && boots.m_41720_() instanceof BrewfestBootsItem;
        tooltip.add((Component)Component.m_237119_());
        tooltip.add((Component)Component.m_237115_((String)"tooltip.brewery.armor.brewfest_set").m_130940_(ChatFormatting.YELLOW));
        tooltip.add(ArmorRegistry.createArmorTooltipEntry(helmet, BrewfestHatItem.class, "tooltip.brewery.armor.brewfesthelmet"));
        tooltip.add(ArmorRegistry.createArmorTooltipEntry(chestplate, BrewfestChestItem.class, "tooltip.brewery.armor.brewfestbreastplate"));
        tooltip.add(ArmorRegistry.createArmorTooltipEntry(leggings, BrewfestLegsItem.class, "tooltip.brewery.armor.brewfestleggings"));
        tooltip.add(ArmorRegistry.createArmorTooltipEntry(boots, BrewfestBootsItem.class, "tooltip.brewery.armor.brewfestboots"));
        tooltip.add((Component)Component.m_237113_((String)""));
        ChatFormatting color = hasFullSet ? ChatFormatting.GREEN : ChatFormatting.GRAY;
    }

    private static Component createArmorTooltipEntry(ItemStack itemStack, Class<?> itemClass, String translationKey) {
        boolean isWorn = itemClass.isInstance(itemStack.m_41720_());
        ChatFormatting color = isWorn ? ChatFormatting.GREEN : ChatFormatting.GRAY;
        return Component.m_237113_((String)"- ").m_7220_((Component)Component.m_237115_((String)translationKey).m_130940_(color));
    }
}

