/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.common.challenge;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mrcrayfish.backpacked.common.challenge.ChallengeManager;
import com.mrcrayfish.backpacked.common.challenge.ChallengeSerializer;
import com.mrcrayfish.backpacked.common.tracker.IProgressTracker;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import org.jetbrains.annotations.Nullable;

public abstract class Challenge {
    public static final Challenge DUMMY = new Dummy();
    private final ResourceLocation id;

    protected Challenge(ResourceLocation id) {
        this.id = id;
    }

    public static Optional<Challenge> deserialize(@Nullable JsonElement element) {
        if (element != null && element.isJsonObject()) {
            JsonObject object = element.getAsJsonObject();
            ResourceLocation type = new ResourceLocation(GsonHelper.m_13906_((JsonObject)object, (String)"type"));
            ChallengeSerializer<? extends Challenge> serializer = ChallengeManager.instance().getSerializer(type);
            if (serializer == null) {
                throw new JsonParseException("Invalid challenge: " + type);
            }
            return Optional.ofNullable(serializer.deserialize(object));
        }
        return Optional.empty();
    }

    public abstract ChallengeSerializer<?> getSerializer();

    public abstract IProgressTracker createProgressTracker(ResourceLocation var1);

    private static class Dummy
    extends Challenge {
        protected Dummy() {
            super(new ResourceLocation("backpacked", "empty"));
        }

        @Override
        public ChallengeSerializer<?> getSerializer() {
            return new ChallengeSerializer<Challenge>(){

                @Override
                public Challenge deserialize(JsonObject object) {
                    return DUMMY;
                }
            };
        }

        @Override
        public IProgressTracker createProgressTracker(ResourceLocation backpackId) {
            return null;
        }
    }
}

