/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercapaint.common.packets;

import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;
import xerca.xercapaint.client.ClientStuff;
import xerca.xercapaint.common.XercaPaint;
import xerca.xercapaint.common.entity.EntityEasel;
import xerca.xercapaint.common.item.ItemPalette;
import xerca.xercapaint.common.packets.OpenGuiPacket;

public class OpenGuiPacketHandler {
    public static void handle(OpenGuiPacket message, Supplier<NetworkEvent.Context> ctx) {
        if (!message.isMessageValid()) {
            System.err.println("Packet was invalid");
            return;
        }
        ctx.get().enqueueWork(() -> OpenGuiPacketHandler.processMessage(message));
        ctx.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void processMessage(OpenGuiPacket msg) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            if (msg.isAllowed()) {
                Entity entity = player.m_9236_().m_6815_(msg.getEaselId());
                if (entity instanceof EntityEasel) {
                    EntityEasel easel = (EntityEasel)entity;
                    ItemStack itemInHand = player.m_21120_(msg.getHand());
                    boolean handHoldsPalette = itemInHand.m_41720_() instanceof ItemPalette;
                    if (msg.isEdit()) {
                        if (handHoldsPalette) {
                            ClientStuff.showCanvasGui(easel, itemInHand);
                        } else {
                            XercaPaint.LOGGER.error("Could not find palette in hand for editing painting");
                        }
                    } else {
                        ClientStuff.showCanvasGui(easel, ItemStack.f_41583_);
                    }
                } else {
                    XercaPaint.LOGGER.error("Could not find easel");
                }
            } else {
                player.m_213846_((Component)Component.m_237115_((String)"easel.deny").m_130940_(ChatFormatting.RED));
            }
        }
    }
}

