/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercapaint.common.packets;

import java.util.Arrays;
import net.minecraft.network.FriendlyByteBuf;

public class PictureSendPacket {
    private String name;
    private int version;
    private int[] pixels;
    private boolean messageIsValid;

    public PictureSendPacket(String name, int version, int[] pixels) {
        this.name = name;
        this.version = version;
        this.pixels = Arrays.copyOfRange(pixels, 0, pixels.length);
    }

    public PictureSendPacket() {
        this.messageIsValid = false;
    }

    public static void encode(PictureSendPacket pkt, FriendlyByteBuf buf) {
        buf.m_130070_(pkt.name);
        buf.writeInt(pkt.version);
        buf.m_130089_(pkt.pixels);
    }

    public static PictureSendPacket decode(FriendlyByteBuf buf) {
        PictureSendPacket result = new PictureSendPacket();
        try {
            result.name = buf.m_130136_(64);
            result.version = buf.readInt();
            result.pixels = buf.m_130116_(1024);
        }
        catch (IndexOutOfBoundsException ioe) {
            System.err.println("Exception while reading PictureSendPacket: " + ioe);
            return null;
        }
        result.messageIsValid = true;
        return result;
    }

    public String getName() {
        return this.name;
    }

    public int getVersion() {
        return this.version;
    }

    public int[] getPixels() {
        return this.pixels;
    }

    public boolean isMessageValid() {
        return this.messageIsValid;
    }
}

