/*
 * Decompiled with CFR 0.152.
 */
package me.khajiitos.chestedcompanions.common.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import me.khajiitos.chestedcompanions.common.config.CCConfig;
import me.khajiitos.chestedcompanions.common.util.IChestEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.Wolf;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class ChestIconRenderer {
    private static final ResourceLocation CHEST_ICON_LOCATION = new ResourceLocation("chestedcompanions", "textures/chest_icon.png");
    private static final float SCALE = 0.015625f;

    public static <T extends LivingEntity> boolean shouldRender(T entity) {
        IChestEntity chestEntity;
        if (entity != Minecraft.m_91087_().m_91290_().f_114359_) {
            return false;
        }
        if (!(entity instanceof IChestEntity) || !(chestEntity = (IChestEntity)entity).chestedCompanions$hasChest()) {
            return false;
        }
        if (!Minecraft.m_91404_()) {
            return false;
        }
        if (entity instanceof Cat) {
            return (Boolean)CCConfig.showChestIconOnCats.get();
        }
        if (entity instanceof Wolf) {
            return (Boolean)CCConfig.showChestIconOnWolves.get();
        }
        return false;
    }

    public static void render(@NotNull PoseStack poseStack, @NotNull MultiBufferSource multiBufferSource, int pPackedLight, @NotNull LivingEntity pEntity, double yOffset) {
        VertexConsumer vertexConsumer = multiBufferSource.m_6299_(RenderType.m_110452_((ResourceLocation)CHEST_ICON_LOCATION));
        int overlayCoords = LivingEntityRenderer.m_115338_((LivingEntity)pEntity, (float)0.0f);
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, yOffset, 0.0);
        poseStack.m_252781_(Minecraft.m_91087_().m_91290_().m_253208_());
        poseStack.m_85841_(-0.015625f, -0.015625f, 0.015625f);
        Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
        vertexConsumer.m_252986_(matrix4f, 0.0f, 0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 0.0f).m_86008_(overlayCoords).m_85969_(pPackedLight).m_5601_(1.0f, 1.0f, 1.0f).m_5752_();
        vertexConsumer.m_252986_(matrix4f, 0.0f, 16.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 1.0f).m_86008_(overlayCoords).m_85969_(pPackedLight).m_5601_(1.0f, 1.0f, 1.0f).m_5752_();
        vertexConsumer.m_252986_(matrix4f, 16.0f, 16.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 1.0f).m_86008_(overlayCoords).m_85969_(pPackedLight).m_5601_(1.0f, 1.0f, 1.0f).m_5752_();
        vertexConsumer.m_252986_(matrix4f, 16.0f, 0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 0.0f).m_86008_(overlayCoords).m_85969_(pPackedLight).m_5601_(1.0f, 1.0f, 1.0f).m_5752_();
        poseStack.m_85849_();
    }
}

