/*
 * Decompiled with CFR 0.152.
 */
package me.khajiitos.chestedcompanions.common.client.renderer.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import me.khajiitos.chestedcompanions.common.util.IChestEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ChestLayer<T extends LivingEntity, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    protected static final float HALF_PI = 1.5707964f;
    private static final ResourceLocation BASE_CHEST_LOCATION = new ResourceLocation("chestedcompanions", "textures/chest/chest.png");
    private static final HashMap<Item, ResourceLocation> CHEST_TEXTURES = new HashMap();
    private final ModelPart modelPart;

    private static ResourceLocation getResourceLocation(@Nullable ItemStack chestItem) {
        if (chestItem == null) {
            return BASE_CHEST_LOCATION;
        }
        if (!CHEST_TEXTURES.containsKey(chestItem.m_41720_())) {
            ResourceLocation itemLocation = BuiltInRegistries.f_257033_.m_7981_((Object)chestItem.m_41720_());
            ResourceLocation textureLocation = new ResourceLocation("chestedcompanions", "textures/chest/" + (String)(itemLocation.m_135827_().equals("minecraft") ? "" : itemLocation.m_135827_() + "/") + itemLocation.m_135815_() + ".png");
            if (!Minecraft.m_91087_().m_91098_().m_213713_(textureLocation).isPresent()) {
                CHEST_TEXTURES.put(chestItem.m_41720_(), BASE_CHEST_LOCATION);
                return BASE_CHEST_LOCATION;
            }
            CHEST_TEXTURES.put(chestItem.m_41720_(), textureLocation);
            return textureLocation;
        }
        return CHEST_TEXTURES.get(chestItem.m_41720_());
    }

    public ChestLayer(RenderLayerParent<T, M> renderLayerParent) {
        super(renderLayerParent);
        Vec3i positionLeftChestCube = this.positionLeftChestCube();
        Vec3i positionRightChestCube = this.positionRightChestCube();
        ModelPart.Cube left = new ModelPart.Cube(0, 0, (float)positionLeftChestCube.m_123341_(), (float)positionLeftChestCube.m_123342_(), (float)positionLeftChestCube.m_123343_(), 8.0f, 8.0f, 3.0f, 1.0f, 1.0f, 1.0f, false, 22.0f, 11.0f, Set.of(Direction.values()));
        ModelPart.Cube right = new ModelPart.Cube(0, 0, (float)positionRightChestCube.m_123341_(), (float)positionRightChestCube.m_123342_(), (float)positionRightChestCube.m_123343_(), 8.0f, 8.0f, 3.0f, 1.0f, 1.0f, 1.0f, true, 22.0f, 11.0f, Set.of(Direction.values()));
        this.modelPart = new ModelPart(List.of(left, right), new HashMap());
    }

    protected abstract ModelPart getParentModelBody();

    protected abstract void setupPosition(T var1, ModelPart var2);

    protected abstract Vec3i positionLeftChestCube();

    protected abstract Vec3i positionRightChestCube();

    public void render(@NotNull PoseStack poseStack, @NotNull MultiBufferSource multiBufferSource, int pPackedLight, @NotNull T pEntity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch, float pPartialTicks) {
        IChestEntity chestEntity;
        if (!(pEntity instanceof IChestEntity) || !(chestEntity = (IChestEntity)pEntity).chestedCompanions$hasChest()) {
            return;
        }
        this.setupPosition(pEntity, this.modelPart);
        this.modelPart.m_104306_(poseStack, multiBufferSource.m_6299_(RenderType.m_110458_((ResourceLocation)ChestLayer.getResourceLocation(chestEntity.chestedCompanions$getChestItemStack()))), pPackedLight, LivingEntityRenderer.m_115338_(pEntity, (float)0.0f), 1.0f, 1.0f, 1.0f, 1.0f);
    }
}

