/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.exoticbirds.blockentity.misc;

import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.pavocado.exoticbirds.entity.AbstractBirdEntity;

public class StoredBirdLogic {
    @Nullable
    private CompoundTag birdData;
    private int movementDelay = 20;
    private int soundDelay = 20;
    private double spin;
    private double oSpin;
    @Nullable
    private Entity displayEntity;

    public void setCageData(CompoundTag tag) {
        this.birdData = tag;
        this.displayEntity = null;
    }

    @Nullable
    public CompoundTag getCageData() {
        return this.birdData;
    }

    private boolean isNearPlayer(Level level, BlockPos pos) {
        return level.m_45914_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 16.0);
    }

    public void clientTick(Level level, BlockPos pos) {
        if (this.birdData != null) {
            if (!this.isNearPlayer(level, pos)) {
                this.oSpin = this.spin;
            } else {
                this.oSpin = this.spin;
                if (--this.movementDelay < 0) {
                    this.movementDelay = level.f_46441_.m_188503_(50) + 30;
                    double targetPos = (level.f_46441_.m_188503_(10) - level.f_46441_.m_188503_(5)) * 20;
                    this.spin = Math.max(this.spin - 50.0, Math.min(this.spin + 50.0, targetPos));
                }
            }
        }
    }

    public void serverTick(ServerLevel level, BlockPos pos, Block block) {
        if (this.birdData != null && this.isNearPlayer((Level)level, pos) && --this.soundDelay < 0) {
            SoundEvent birdSound;
            this.soundDelay = level.f_46441_.m_188503_(160) + 80;
            Entity cachedEntity = this.getOrCreateDisplayEntity((Level)level);
            if (cachedEntity instanceof AbstractBirdEntity && (birdSound = ((AbstractBirdEntity)cachedEntity).getBirdcageSound()) != null) {
                level.m_5594_(null, pos, birdSound, SoundSource.AMBIENT, 0.8f, ((AbstractBirdEntity)cachedEntity).m_6100_());
                level.m_7696_(pos, block, 1, 0);
            }
        }
    }

    @Nullable
    public Entity getOrCreateDisplayEntity(Level level) {
        if (this.displayEntity == null && this.birdData != null) {
            this.displayEntity = EntityType.m_20645_((CompoundTag)this.birdData, (Level)level, Function.identity());
        }
        return this.displayEntity;
    }

    public double getSpin() {
        return this.spin;
    }

    public double getoSpin() {
        return this.oSpin;
    }

    public void load(CompoundTag tag) {
        this.birdData = null;
        this.movementDelay = tag.m_128448_("Delay");
        this.soundDelay = tag.m_128448_("SoundDelay");
        if (tag.m_128441_("EntityData")) {
            this.birdData = tag.m_128469_("EntityData");
        }
        this.displayEntity = null;
    }

    public void save(CompoundTag tag) {
        tag.m_128376_("Delay", (short)this.movementDelay);
        tag.m_128376_("SoundDelay", (short)this.soundDelay);
        if (this.birdData != null) {
            tag.m_128365_("EntityData", (Tag)this.birdData.m_6426_());
        }
    }

    public Entity spawnEntity(@Nullable ServerLevel level, BlockPos pos) {
        double d2;
        double d1;
        double d0;
        Entity entity;
        if (level != null && this.birdData != null && (entity = EntityType.m_20645_((CompoundTag)this.birdData, (Level)level, arg_0 -> StoredBirdLogic.lambda$spawnEntity$0(d0 = (double)pos.m_123341_() + 0.5, d1 = (double)pos.m_123342_() + 0.2, d2 = (double)pos.m_123343_() + 0.5, arg_0))) != null) {
            if (entity instanceof Mob) {
                ((Mob)entity).m_21530_();
            }
            entity.m_7678_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), 90.0f, 90.0f);
            if (!level.m_8860_(entity)) {
                return null;
            }
            return entity;
        }
        return null;
    }

    public void spawnEntityViaExplosion(@Nullable ServerLevel level, BlockPos pos, Explosion explosion) {
        Entity entity = this.spawnEntity(level, pos);
        if (entity != null) {
            float explosionRange = 10.0f;
            double distance = Math.sqrt(entity.m_20238_(explosion.getPosition())) / (double)explosionRange;
            double d10 = 1.0 - distance;
            entity.m_6469_(explosion.m_46077_(), (float)((int)((d10 * d10 + d10) / 2.0 * 7.0 * (double)explosionRange + 1.0)));
        }
    }

    private static /* synthetic */ Entity lambda$spawnEntity$0(double d0, double d1, double d2, Entity e) {
        e.m_7678_(d0, d1, d2, e.m_146908_(), e.m_146909_());
        return e;
    }
}

