/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.exoticbirds.client.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.pavocado.exoticbirds.entity.CassowaryEntity;

@OnlyIn(value=Dist.CLIENT)
public class CassowaryModel<T extends CassowaryEntity>
extends AgeableListModel<T> {
    public static final ModelLayerLocation CASSOWARY_LAYER = new ModelLayerLocation(new ResourceLocation("exoticbirds", "cassowary"), "main");
    private final ModelPart tail;
    private final ModelPart torso;
    private final ModelPart belly;
    private final ModelPart neck;
    private final ModelPart shoulders;
    private final ModelPart tonsils;
    private final ModelPart head;
    private final ModelPart rightLegBody;
    private final ModelPart leftLegBody;
    private final ModelPart rightThigh;
    private final ModelPart neckLower;
    private final ModelPart leftThigh;

    public CassowaryModel(ModelPart part) {
        this.tail = part.m_171324_("tail");
        this.torso = part.m_171324_("torso");
        this.belly = part.m_171324_("belly");
        this.neckLower = part.m_171324_("neckLower");
        this.neck = this.neckLower.m_171324_("neck");
        this.head = this.neck.m_171324_("head");
        this.shoulders = part.m_171324_("shoulders");
        this.tonsils = this.neckLower.m_171324_("tonsils");
        this.rightLegBody = part.m_171324_("rightLegBody");
        this.leftLegBody = part.m_171324_("leftLegBody");
        this.rightThigh = part.m_171324_("rightThigh");
        this.leftThigh = part.m_171324_("leftThigh");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171481_(-3.5f, -3.5f, 0.0f, 7.0f, 6.0f, 9.0f), PartPose.m_171423_((float)0.0f, (float)8.5f, (float)3.0f, (float)-0.6457718f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("torso", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-4.0f, -3.5f, 0.0f, 8.0f, 8.0f, 8.0f), PartPose.m_171423_((float)0.0f, (float)10.0f, (float)-2.0f, (float)0.1115358f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("belly", CubeListBuilder.m_171558_().m_171514_(0, 31).m_171481_(-3.0f, -1.0f, 0.0f, 6.0f, 2.0f, 9.0f), PartPose.m_171423_((float)0.0f, (float)13.4f, (float)-1.0f, (float)-0.0743572f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("shoulders", CubeListBuilder.m_171558_().m_171514_(0, 42).m_171481_(-2.5f, -4.0f, -1.7f, 5.0f, 5.0f, 4.0f), PartPose.m_171423_((float)0.0f, (float)12.0f, (float)-1.3f, (float)0.4461433f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("rightLegBody", CubeListBuilder.m_171558_().m_171514_(32, 6).m_171481_(-1.5f, 0.0f, -2.0f, 3.0f, 3.0f, 3.0f), PartPose.m_171423_((float)-1.8f, (float)13.0f, (float)2.0f, (float)0.6632251f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("leftLegBody", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171481_(-1.5f, 0.0f, -2.0f, 3.0f, 3.0f, 3.0f), PartPose.m_171423_((float)1.8f, (float)13.0f, (float)2.0f, (float)0.6632251f, (float)0.0f, (float)0.0f));
        PartDefinition neckLowerDefinition = partdefinition.m_171599_("neckLower", CubeListBuilder.m_171558_().m_171514_(44, 5).m_171481_(-1.0f, -5.0f, -1.0f, 2.0f, 4.0f, 2.0f), PartPose.m_171423_((float)0.0f, (float)11.0f, (float)-2.5f, (float)0.3665191f, (float)0.0f, (float)0.0f));
        neckLowerDefinition.m_171599_("tonsils", CubeListBuilder.m_171558_().m_171514_(46, 11).m_171481_(-1.0f, 0.0f, -1.0f, 2.0f, 6.0f, 1.0f), PartPose.m_171423_((float)0.0f, (float)-4.9999f, (float)-1.7f, (float)-0.4014257f, (float)0.0f, (float)0.0f));
        PartDefinition neckDefinition = neckLowerDefinition.m_171599_("neck", CubeListBuilder.m_171558_().m_171514_(44, 0).m_171481_(-1.0f, -3.2f, -1.0f, 2.0f, 3.0f, 2.0f), PartPose.m_171423_((float)0.0f, (float)-4.5f, (float)0.0f, (float)-0.3665191f, (float)0.0f, (float)0.0f));
        PartDefinition headDefinition = neckDefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(32, 12).m_171481_(-1.5f, -3.0f, -2.5f, 3.0f, 3.0f, 4.0f), PartPose.m_171423_((float)0.0f, (float)-3.0f, (float)-0.2f, (float)0.0f, (float)0.0f, (float)0.0f));
        headDefinition.m_171599_("headpiece", CubeListBuilder.m_171558_().m_171514_(52, 8).m_171481_(-0.5f, -6.0f, -3.2f, 1.0f, 5.0f, 4.0f), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.0204482f, (float)0.0f, (float)0.0f));
        headDefinition.m_171599_("beak", CubeListBuilder.m_171558_().m_171514_(33, 34).m_171481_(-1.0f, -2.0f, -5.0f, 2.0f, 1.0f, 4.0f), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.2762577f, (float)0.0f, (float)0.0f));
        PartDefinition rightThighDefinition = partdefinition.m_171599_("rightThigh", CubeListBuilder.m_171558_().m_171514_(40, 19).m_171481_(-1.0f, 0.0f, -1.0f, 2.0f, 4.0f, 2.0f), PartPose.m_171423_((float)-1.8f, (float)14.8f, (float)3.4f, (float)0.2443461f, (float)0.0f, (float)0.0f));
        PartDefinition rightAnkleDefinition = rightThighDefinition.m_171599_("rightAnkle", CubeListBuilder.m_171558_().m_171514_(40, 25).m_171481_(-1.0f, 0.0f, -1.0f, 2.0f, 5.0f, 2.0f), PartPose.m_171423_((float)0.0f, (float)3.6f, (float)0.0f, (float)-0.5205006f, (float)0.0f, (float)0.0f));
        rightAnkleDefinition.m_171599_("rightLittleToe", CubeListBuilder.m_171558_().m_171514_(42, 44).m_171481_(-1.0f, 0.0f, -3.0f, 1.0f, 1.0f, 3.0f), PartPose.m_171423_((float)0.3f, (float)4.4f, (float)0.8f, (float)0.383972f, (float)0.6632251f, (float)0.0f));
        rightAnkleDefinition.m_171599_("rightBigToe", CubeListBuilder.m_171558_().m_171514_(44, 39).m_171481_(-0.5f, 0.0f, -4.0f, 1.0f, 1.0f, 4.0f), PartPose.m_171423_((float)0.3f, (float)4.4f, (float)0.8f, (float)0.2761545f, (float)-0.0872665f, (float)0.0f));
        rightAnkleDefinition.m_171599_("rightMidToe", CubeListBuilder.m_171558_().m_171514_(44, 48).m_171481_(-1.0f, 0.0f, -4.0f, 1.0f, 1.0f, 4.0f), PartPose.m_171423_((float)0.3f, (float)4.4f, (float)0.8f, (float)0.2761545f, (float)0.2268928f, (float)0.0f));
        rightThighDefinition.m_171599_("rightKnee", CubeListBuilder.m_171558_().m_171514_(52, 4).m_171481_(-1.5f, 3.3f, -1.0f, 3.0f, 1.0f, 3.0f), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.139626f, (float)0.0f, (float)0.0f));
        PartDefinition leftThighDefinition = partdefinition.m_171599_("leftThigh", CubeListBuilder.m_171558_().m_171514_(32, 19).m_171481_(-1.0f, 0.0f, -1.0f, 2.0f, 4.0f, 2.0f), PartPose.m_171423_((float)1.8f, (float)14.8f, (float)3.4f, (float)0.2443461f, (float)0.0f, (float)0.0f));
        PartDefinition leftAnkleDefinition = leftThighDefinition.m_171599_("leftAnkle", CubeListBuilder.m_171558_().m_171514_(32, 25).m_171481_(-1.0f, 0.0f, -1.0f, 2.0f, 5.0f, 2.0f), PartPose.m_171423_((float)0.0f, (float)3.6f, (float)0.0f, (float)-0.5205006f, (float)0.0f, (float)0.0f));
        leftAnkleDefinition.m_171599_("leftBigToe", CubeListBuilder.m_171558_().m_171514_(34, 39).m_171481_(-0.5f, 0.0f, -4.0f, 1.0f, 1.0f, 4.0f), PartPose.m_171423_((float)-0.3f, (float)4.4f, (float)0.8f, (float)0.2761545f, (float)0.0872665f, (float)0.0f));
        leftAnkleDefinition.m_171599_("leftMidToe", CubeListBuilder.m_171558_().m_171514_(34, 48).m_171481_(0.0f, 0.0f, -4.0f, 1.0f, 1.0f, 4.0f), PartPose.m_171423_((float)-0.3f, (float)4.4f, (float)0.8f, (float)0.2761545f, (float)-0.2268928f, (float)0.0f));
        leftAnkleDefinition.m_171599_("leftLittleToe", CubeListBuilder.m_171558_().m_171514_(34, 44).m_171481_(0.0f, 0.0f, -3.0f, 1.0f, 1.0f, 3.0f), PartPose.m_171423_((float)-0.3f, (float)4.4f, (float)0.8f, (float)0.383972f, (float)-0.6632251f, (float)0.0f));
        leftThighDefinition.m_171599_("leftKnee", CubeListBuilder.m_171558_().m_171514_(52, 0).m_171481_(-1.5f, 3.3f, -1.0f, 3.0f, 1.0f, 3.0f), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.139626f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    protected Iterable<ModelPart> m_5607_() {
        return ImmutableList.of((Object)this.neckLower);
    }

    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.tail, (Object)this.torso, (Object)this.belly, (Object)this.shoulders, (Object)this.rightLegBody, (Object)this.leftLegBody, (Object)this.rightThigh, (Object)this.leftThigh);
    }

    public void setupAnim(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.neck.f_104204_ = netHeadYaw / 57.295776f / 3.0f;
        this.neckLower.f_104204_ = netHeadYaw / 57.295776f / 3.0f;
        this.head.f_104203_ = -(headPitch / 57.295776f);
        this.rightThigh.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 0.8f * limbSwingAmount + 0.2443461f;
        this.leftThigh.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 0.8f * limbSwingAmount + 0.2443461f;
        this.tonsils.f_104205_ = Mth.m_14089_((float)(limbSwing * 0.4f)) * 0.5f * limbSwingAmount;
        this.tonsils.m_104227_(0.0f, -5.0f, 0.0f);
    }

    public void m_7695_(PoseStack stack, VertexConsumer builder, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        stack.m_85836_();
        if (this.f_102610_) {
            stack.m_85841_(0.8f, 0.8f, 0.8f);
            stack.m_85837_(0.0, 0.4, 0.0);
            this.m_5607_().forEach(p_102061_ -> p_102061_.m_104306_(stack, builder, packedLight, packedOverlay, red, green, blue, alpha));
            this.m_5608_().forEach(p_102051_ -> p_102051_.m_104306_(stack, builder, packedLight, packedOverlay, red, green, blue, alpha));
        } else {
            stack.m_85841_(1.2f, 1.2f, 1.2f);
            stack.m_85837_(0.0, -0.25, 0.0);
            this.m_5607_().forEach(p_102061_ -> p_102061_.m_104306_(stack, builder, packedLight, packedOverlay, red, green, blue, alpha));
            this.m_5608_().forEach(p_102051_ -> p_102051_.m_104306_(stack, builder, packedLight, packedOverlay, red, green, blue, alpha));
        }
        stack.m_85849_();
    }
}

