/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.exoticbirds.client.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.pavocado.exoticbirds.entity.OstrichEntity;

@OnlyIn(value=Dist.CLIENT)
public class OstrichModel<T extends OstrichEntity>
extends AgeableListModel<T> {
    public static final ModelLayerLocation OSTRICH_LAYER = new ModelLayerLocation(new ResourceLocation("exoticbirds", "ostrich"), "main");
    private final ModelPart body;
    private final ModelPart ruffle;
    private final ModelPart breast;
    private final ModelPart shoulders;
    private final ModelPart leftSocket;
    private final ModelPart leftThigh;
    private final ModelPart rightSocket;
    private final ModelPart leftKnee;
    private final ModelPart rightThigh;
    private final ModelPart rightKnee;
    private final ModelPart back;
    private final ModelPart leftWing;
    private final ModelPart rightWing;
    private final ModelPart tail;
    private final ModelPart neck;
    private final ModelPart head;
    private final ModelPart saddleTop;
    private final ModelPart saddle;

    public OstrichModel(ModelPart part) {
        this.body = part.m_171324_("body");
        this.ruffle = part.m_171324_("ruffle");
        this.breast = part.m_171324_("breast");
        this.shoulders = part.m_171324_("shoulders");
        this.leftSocket = part.m_171324_("leftSocket");
        this.leftThigh = part.m_171324_("leftThigh");
        this.rightSocket = part.m_171324_("rightSocket");
        this.leftKnee = part.m_171324_("leftKnee");
        this.rightThigh = part.m_171324_("rightThigh");
        this.rightKnee = part.m_171324_("rightKnee");
        this.back = part.m_171324_("back");
        this.leftWing = part.m_171324_("leftWing");
        this.rightWing = part.m_171324_("rightWing");
        this.tail = part.m_171324_("tail");
        this.neck = this.shoulders.m_171324_("neck");
        this.head = this.neck.m_171324_("head");
        this.saddleTop = part.m_171324_("saddleTop");
        this.saddle = part.m_171324_("saddle");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-4.5f, 0.0f, 0.0f, 9.0f, 8.0f, 8.0f), PartPose.m_171423_((float)0.0f, (float)6.9f, (float)-4.0f, (float)0.0523599f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("ruffle", CubeListBuilder.m_171558_().m_171514_(24, 49).m_171481_(-3.5f, -1.0f, 1.0f, 7.0f, 6.0f, 2.0f), PartPose.m_171423_((float)0.0f, (float)12.1f, (float)6.0f, (float)1.122174f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("breast", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171481_(0.0f, 0.0f, 0.0f, 8.0f, 5.0f, 4.0f), PartPose.m_171423_((float)-4.0f, (float)7.8f, (float)-5.0f, (float)-0.1487144f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("leftSocket", CubeListBuilder.m_171558_().m_171514_(24, 39).m_171481_(-1.5f, 0.0f, -1.5f, 3.0f, 1.0f, 4.0f), PartPose.m_171423_((float)2.0f, (float)14.5f, (float)-1.0f, (float)0.2094395f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("leftThigh", CubeListBuilder.m_171558_().m_171514_(32, 16).m_171481_(-1.0f, 0.0f, -1.0f, 2.0f, 4.0f, 2.0f), PartPose.m_171423_((float)2.0f, (float)14.5f, (float)-1.0f, (float)0.4363323f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("rightSocket", CubeListBuilder.m_171558_().m_171514_(24, 44).m_171481_(-1.5f, 0.0f, -1.5f, 3.0f, 1.0f, 4.0f), PartPose.m_171423_((float)-2.0f, (float)14.5f, (float)-1.0f, (float)0.2094395f, (float)0.0f, (float)0.0f));
        PartDefinition shouldersDefinition = partdefinition.m_171599_("shoulders", CubeListBuilder.m_171558_().m_171514_(0, 42).m_171481_(-1.5f, -5.0f, -1.5f, 3.0f, 5.0f, 3.0f), PartPose.m_171423_((float)0.0f, (float)9.9f, (float)-3.8f, (float)0.6206763f, (float)0.0f, (float)0.0f));
        PartDefinition neckDefinition = shouldersDefinition.m_171599_("neck", CubeListBuilder.m_171558_().m_171514_(16, 42).m_171481_(-1.0f, -3.466667f, -1.0f, 2.0f, 8.0f, 2.0f), PartPose.m_171423_((float)0.0f, (float)-8.0f, (float)2.0f, (float)-0.5205006f, (float)0.0f, (float)0.0f));
        PartDefinition headDefinition = neckDefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 50).m_171481_(-2.0f, -3.0f, -2.1f, 4.0f, 3.0f, 4.0f), PartPose.m_171423_((float)0.0f, (float)-2.1f, (float)-0.3f, (float)0.1598989f, (float)0.0f, (float)0.0f));
        headDefinition.m_171599_("lowerBeak", CubeListBuilder.m_171558_().m_171514_(12, 57).m_171481_(-1.0f, -1.0f, -3.933333f, 2.0f, 1.0f, 3.0f), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0202726f, (float)0.0f, (float)0.0f));
        headDefinition.m_171599_("upperBeak", CubeListBuilder.m_171558_().m_171514_(0, 57).m_171481_(-1.5f, -2.2f, -4.4f, 3.0f, 1.0f, 3.0f), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.3017973f, (float)0.0f, (float)0.0f));
        PartDefinition leftKneeDefinition = partdefinition.m_171599_("leftKnee", CubeListBuilder.m_171558_().m_171514_(24, 27).m_171481_(-1.5f, 3.0f, -0.1f, 3.0f, 2.0f, 3.0f), PartPose.m_171423_((float)2.0f, (float)14.5f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftLegDefinition = leftKneeDefinition.m_171599_("leftLeg", CubeListBuilder.m_171558_().m_171514_(32, 32).m_171481_(-1.0f, 0.0f, -1.0f, 2.0f, 5.0f, 2.0f), PartPose.m_171423_((float)0.0f, (float)4.0f, (float)1.5f, (float)-0.0523599f, (float)0.0f, (float)0.0f));
        leftLegDefinition.m_171599_("leftToe2", CubeListBuilder.m_171558_().m_171514_(44, 33).m_171481_(-0.8f, 0.0f, -3.5f, 1.0f, 1.0f, 3.0f), PartPose.m_171423_((float)0.0f, (float)4.5f, (float)0.5f, (float)0.0523599f, (float)0.1745329f, (float)0.0f));
        leftLegDefinition.m_171599_("leftToe1", CubeListBuilder.m_171558_().m_171514_(44, 30).m_171481_(-0.5f, 0.0f, -2.5f, 1.0f, 1.0f, 2.0f), PartPose.m_171423_((float)0.0f, (float)4.5f, (float)0.5f, (float)0.0523599f, (float)-0.6108652f, (float)0.0f));
        PartDefinition rightKneeDefinition = partdefinition.m_171599_("rightKnee", CubeListBuilder.m_171558_().m_171514_(24, 22).m_171481_(-1.5f, 3.0f, -0.1f, 3.0f, 2.0f, 3.0f), PartPose.m_171423_((float)-2.0f, (float)14.5f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightLegDefinition = rightKneeDefinition.m_171599_("rightLeg", CubeListBuilder.m_171558_().m_171514_(24, 32).m_171481_(-1.0f, 0.0f, -1.0f, 2.0f, 5.0f, 2.0f), PartPose.m_171423_((float)0.0f, (float)4.0f, (float)1.5f, (float)-0.0523599f, (float)0.0f, (float)0.0f));
        rightLegDefinition.m_171599_("rightToe2", CubeListBuilder.m_171558_().m_171514_(52, 33).m_171481_(-0.2f, 0.0f, -3.5f, 1.0f, 1.0f, 3.0f), PartPose.m_171423_((float)0.0f, (float)4.5f, (float)0.5f, (float)0.0523599f, (float)-0.1745329f, (float)0.0f));
        rightLegDefinition.m_171599_("rightToe1", CubeListBuilder.m_171558_().m_171514_(50, 30).m_171481_(-0.5f, 0.0f, -2.5f, 1.0f, 1.0f, 2.0f), PartPose.m_171423_((float)0.0f, (float)4.5f, (float)0.5f, (float)0.0523599f, (float)0.6108652f, (float)0.0f));
        partdefinition.m_171599_("rightThigh", CubeListBuilder.m_171558_().m_171514_(24, 16).m_171481_(-1.0f, 0.0f, -1.0f, 2.0f, 4.0f, 2.0f), PartPose.m_171423_((float)-2.0f, (float)14.5f, (float)-1.0f, (float)0.4363323f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("back", CubeListBuilder.m_171558_().m_171514_(0, 25).m_171481_(-4.0f, 0.0f, 0.0f, 8.0f, 6.0f, 4.0f), PartPose.m_171423_((float)0.0f, (float)7.1f, (float)3.0f, (float)-0.1047198f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("leftWing", CubeListBuilder.m_171558_().m_171514_(44, 0).m_171481_(0.0f, -1.0f, -1.0f, 1.0f, 6.0f, 9.0f), PartPose.m_171423_((float)4.5f, (float)8.9f, (float)-3.0f, (float)0.2094395f, (float)-0.0349066f, (float)-0.0349066f));
        partdefinition.m_171599_("rightWing", CubeListBuilder.m_171558_().m_171514_(44, 15).m_171481_(-1.0f, -1.0f, -1.0f, 1.0f, 6.0f, 9.0f), PartPose.m_171423_((float)-4.5f, (float)8.9f, (float)-3.0f, (float)0.2094395f, (float)0.0349066f, (float)0.0349066f));
        partdefinition.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(0, 35).m_171481_(-3.0f, -1.0f, -2.0f, 6.0f, 4.0f, 3.0f), PartPose.m_171423_((float)0.0f, (float)11.1f, (float)6.0f, (float)0.6760311f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("saddleTop", CubeListBuilder.m_171558_().m_171514_(32, 57).m_171481_(-1.5f, -2.0f, -2.5f, 3.0f, 3.0f, 2.0f), PartPose.m_171423_((float)0.0f, (float)6.3f, (float)-0.2f, (float)0.1115358f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("saddle", CubeListBuilder.m_171558_().m_171514_(36, 56).m_171481_(-4.0f, -1.0f, -2.0f, 8.0f, 2.0f, 6.0f), PartPose.m_171423_((float)0.0f, (float)6.3f, (float)-0.2f, (float)-0.0371786f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    protected Iterable<ModelPart> m_5607_() {
        return ImmutableList.of((Object)this.shoulders);
    }

    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.body, (Object)this.ruffle, (Object)this.breast, (Object)this.leftSocket, (Object)this.leftThigh, (Object)this.rightSocket, (Object)this.leftKnee, (Object)this.rightThigh, (Object)this.rightKnee, (Object)this.back, (Object)this.leftWing, (Object)this.rightWing, (Object[])new ModelPart[]{this.tail, this.saddleTop, this.saddle});
    }

    public void setupAnim(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        boolean showSaddle;
        this.neck.f_104204_ = netHeadYaw / 57.295776f / 3.0f;
        this.head.f_104203_ = -(headPitch / 57.295776f) + 0.1598989f;
        this.leftThigh.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount + 0.4363323f;
        this.rightThigh.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount + 0.4363323f;
        this.leftKnee.f_104203_ = this.leftThigh.f_104203_ - 0.4363323f;
        this.rightKnee.f_104203_ = this.rightThigh.f_104203_ - 0.4363323f;
        this.rightWing.f_104205_ = ageInTicks;
        this.leftWing.f_104205_ = -ageInTicks;
        this.saddleTop.f_104207_ = showSaddle = ((OstrichEntity)((Object)entityIn)).m_6254_() && !entityIn.m_6162_();
        this.saddle.f_104207_ = showSaddle;
    }

    public void m_7695_(PoseStack stack, VertexConsumer builder, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        if (this.f_102610_) {
            stack.m_85836_();
            stack.m_85841_(0.7f, 0.7f, 0.7f);
            stack.m_252880_(0.0f, 0.6f, 0.0f);
            this.m_5607_().forEach(p_102061_ -> p_102061_.m_104306_(stack, builder, packedLight, packedOverlay, red, green, blue, alpha));
            this.m_5608_().forEach(p_102051_ -> p_102051_.m_104306_(stack, builder, packedLight, packedOverlay, red, green, blue, alpha));
            stack.m_85849_();
        } else {
            stack.m_85836_();
            stack.m_85841_(1.3f, 1.3f, 1.3f);
            stack.m_252880_(0.0f, -0.35f, 0.0f);
            this.m_5607_().forEach(p_102061_ -> p_102061_.m_104306_(stack, builder, packedLight, packedOverlay, red, green, blue, alpha));
            this.m_5608_().forEach(p_102051_ -> p_102051_.m_104306_(stack, builder, packedLight, packedOverlay, red, green, blue, alpha));
            stack.m_85849_();
        }
    }
}

