/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.exoticbirds.client.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.pavocado.exoticbirds.entity.RoadrunnerEntity;

@OnlyIn(value=Dist.CLIENT)
public class RoadrunnerModel<T extends RoadrunnerEntity>
extends AgeableListModel<T> {
    public static final ModelLayerLocation ROADRUNNER_LAYER = new ModelLayerLocation(new ResourceLocation("exoticbirds", "roadrunner"), "main");
    private final ModelPart body;
    private final ModelPart tail;
    private final ModelPart leftWing;
    private final ModelPart rightWing;
    private final ModelPart neck;
    private final ModelPart head;
    private final ModelPart quiff;
    private final ModelPart beak;
    private final ModelPart rightLegLower;
    private final ModelPart leftFoot;
    private final ModelPart rightFoot;
    private final ModelPart legPivot;
    private final ModelPart leftLegUpper;
    private final ModelPart rightLegUpper;
    private final ModelPart leftLegLower;

    public RoadrunnerModel(ModelPart part) {
        this.body = part.m_171324_("body");
        this.tail = part.m_171324_("tail");
        this.leftWing = part.m_171324_("leftWing");
        this.rightWing = part.m_171324_("rightWing");
        this.neck = part.m_171324_("neck");
        this.head = part.m_171324_("head");
        this.quiff = part.m_171324_("quiff");
        this.beak = part.m_171324_("beak");
        this.rightLegLower = part.m_171324_("rightLegLower");
        this.leftFoot = part.m_171324_("leftFoot");
        this.rightFoot = part.m_171324_("rightFoot");
        this.legPivot = part.m_171324_("legPivot");
        this.leftLegUpper = part.m_171324_("leftLegUpper");
        this.rightLegUpper = part.m_171324_("rightLegUpper");
        this.leftLegLower = part.m_171324_("leftLegLower");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-4.0f, -4.0f, -6.0f, 8.0f, 7.0f, 12.0f), PartPose.m_171423_((float)0.0f, (float)14.0f, (float)0.0f, (float)-0.122173f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(40, 0).m_171481_(-2.5f, -1.0f, 0.0f, 5.0f, 2.0f, 10.0f), PartPose.m_171423_((float)0.0f, (float)15.0f, (float)5.0f, (float)0.4712389f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("leftWing", CubeListBuilder.m_171558_().m_171514_(72, 0).m_171481_(0.0f, -2.0f, -3.0f, 1.0f, 6.0f, 12.0f), PartPose.m_171423_((float)4.0f, (float)11.0f, (float)-2.0f, (float)-0.3141593f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("rightWing", CubeListBuilder.m_171558_().m_171514_(72, 18).m_171481_(-1.0f, -2.0f, -3.0f, 1.0f, 6.0f, 12.0f), PartPose.m_171423_((float)-4.0f, (float)11.0f, (float)-2.0f, (float)-0.3141593f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("neck", CubeListBuilder.m_171558_().m_171514_(57, 14).m_171481_(-1.5f, -8.0f, -0.5f, 3.0f, 8.0f, 3.0f), PartPose.m_171423_((float)0.0f, (float)13.0f, (float)-6.0f, (float)0.13692634f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(28, 0).m_171481_(-1.5f, -10.6f, -3.5f, 3.0f, 3.0f, 5.0f), PartPose.m_171423_((float)0.0f, (float)13.0f, (float)-6.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("quiff", CubeListBuilder.m_171558_().m_171514_(44, 14).m_171481_(0.0f, -15.0f, -4.0f, 0.0f, 5.0f, 6.0f), PartPose.m_171423_((float)0.0f, (float)13.0f, (float)-6.0f, (float)0.0743572f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("beak", CubeListBuilder.m_171558_().m_171514_(30, 20).m_171481_(-1.0f, -9.1f, -7.0f, 2.0f, 1.0f, 4.0f), PartPose.m_171423_((float)0.0f, (float)13.0f, (float)-6.0f, (float)0.0174533f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("rightLegLower", CubeListBuilder.m_171558_().m_171514_(24, 25).m_171481_(-0.5f, 1.5f, 1.6f, 1.0f, 5.0f, 1.0f), PartPose.m_171423_((float)-2.0f, (float)17.0f, (float)-1.0f, (float)-0.296706f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("leftFoot", CubeListBuilder.m_171558_().m_171514_(0, 19).m_171481_(-2.5f, 7.0f, -3.5f, 5.0f, 0.0f, 6.0f), PartPose.m_171423_((float)2.0f, (float)17.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("rightFoot", CubeListBuilder.m_171558_().m_171514_(0, 25).m_171481_(-2.5f, 7.0f, -3.5f, 5.0f, 0.0f, 6.0f), PartPose.m_171423_((float)-2.0f, (float)17.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("legPivot", CubeListBuilder.m_171558_().m_171514_(0, 31).m_171481_(-4.0f, -1.5f, -1.5f, 8.0f, 3.0f, 2.0f), PartPose.m_171423_((float)0.0f, (float)17.0f, (float)-1.3f, (float)-1.130643f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("leftLegUpper", CubeListBuilder.m_171558_().m_171514_(16, 19).m_171481_(-1.0f, 0.0f, -1.0f, 2.0f, 3.0f, 2.0f), PartPose.m_171423_((float)2.0f, (float)17.0f, (float)-1.0f, (float)0.8726646f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("rightLegUpper", CubeListBuilder.m_171558_().m_171514_(16, 24).m_171481_(-1.0f, 0.0f, -1.0f, 2.0f, 3.0f, 2.0f), PartPose.m_171423_((float)-2.0f, (float)17.0f, (float)-1.0f, (float)0.8726646f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("leftLegLower", CubeListBuilder.m_171558_().m_171514_(24, 19).m_171481_(-0.5f, 1.5f, 1.6f, 1.0f, 5.0f, 1.0f), PartPose.m_171423_((float)2.0f, (float)17.0f, (float)-1.0f, (float)-0.296706f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    protected Iterable<ModelPart> m_5607_() {
        return ImmutableList.of((Object)this.neck, (Object)this.head, (Object)this.quiff, (Object)this.beak);
    }

    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.body, (Object)this.tail, (Object)this.leftWing, (Object)this.rightWing, (Object)this.rightLegLower, (Object)this.leftFoot, (Object)this.rightFoot, (Object)this.legPivot, (Object)this.leftLegUpper, (Object)this.rightLegUpper, (Object)this.leftLegLower);
    }

    public void setupAnim(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.rightLegUpper.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount + 0.8726646f;
        this.rightLegLower.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount - 0.296706f;
        this.rightFoot.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.leftLegUpper.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount + 0.8726646f;
        this.leftLegLower.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount - 0.296706f;
        this.leftFoot.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.rightWing.f_104205_ = limbSwingAmount;
        this.leftWing.f_104205_ = -limbSwingAmount;
    }

    public void prepareMobModel(T entityIn, float limbSwing, float limbSwingAmount, float partialTick) {
        if (entityIn.m_20142_()) {
            this.neck.f_104203_ = 0.75049f;
            this.head.f_104203_ = 0.610865f;
            this.quiff.f_104203_ = 0.610865f;
            this.beak.f_104203_ = 0.6283185f;
            this.tail.f_104203_ = 0.698f;
        } else {
            this.neck.f_104203_ = 0.13692634f;
            this.head.f_104203_ = 0.0f;
            this.quiff.f_104203_ = 0.0743572f;
            this.beak.f_104203_ = 0.0174533f;
            this.tail.f_104203_ = 0.4712389f;
        }
    }

    public void m_7695_(PoseStack stack, VertexConsumer builder, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        if (this.f_102610_) {
            stack.m_85836_();
            stack.m_85841_(0.45f, 0.45f, 0.45f);
            stack.m_252880_(0.0f, 1.8f, 0.0f);
            this.m_5607_().forEach(p_102061_ -> p_102061_.m_104306_(stack, builder, packedLight, packedOverlay, red, green, blue, alpha));
            this.m_5608_().forEach(p_102051_ -> p_102051_.m_104306_(stack, builder, packedLight, packedOverlay, red, green, blue, alpha));
            stack.m_85849_();
        } else {
            stack.m_85836_();
            stack.m_85841_(0.75f, 0.75f, 0.75f);
            stack.m_252880_(0.0f, 0.45f, 0.0f);
            this.m_5607_().forEach(p_102061_ -> p_102061_.m_104306_(stack, builder, packedLight, packedOverlay, red, green, blue, alpha));
            this.m_5608_().forEach(p_102051_ -> p_102051_.m_104306_(stack, builder, packedLight, packedOverlay, red, green, blue, alpha));
            stack.m_85849_();
        }
    }
}

