/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.exoticbirds.container;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.pavocado.exoticbirds.blockentity.IncubatorBlockEntity;
import net.pavocado.exoticbirds.init.ExoticBirdsMenus;

public class IncubatorMenu
extends AbstractContainerMenu {
    public final IncubatorBlockEntity incubator;
    private final ContainerData incubatorData;

    public IncubatorMenu(int windowId, Inventory inventory, FriendlyByteBuf extraData) {
        this(windowId, inventory, IncubatorMenu.getIncubator(inventory, extraData), (ContainerData)new SimpleContainerData(2));
    }

    public IncubatorMenu(int windowId, Inventory inventory, IncubatorBlockEntity incubatorEntity, ContainerData dataIn) {
        super((MenuType)ExoticBirdsMenus.EGG_INCUBATOR.get(), windowId);
        int column;
        IncubatorMenu.m_38869_((Container)incubatorEntity, (int)15);
        IncubatorMenu.m_38886_((ContainerData)dataIn, (int)2);
        this.incubator = incubatorEntity;
        this.incubatorData = dataIn;
        this.m_38884_(dataIn);
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)incubatorEntity.inventory, 0, 80, 59));
        for (int row = 0; row < 2; ++row) {
            for (int column2 = 0; column2 < 7; ++column2) {
                this.m_38897_((Slot)new SlotItemHandler((IItemHandler)incubatorEntity.inventory, 1 + row * 7 + column2, 26 + column2 * 18, 17 + row * 18));
            }
        }
        int playerInventoryStartX = 8;
        int playerInventoryStartY = 88;
        int slotBuffer = 18;
        for (int row = 0; row < 3; ++row) {
            for (column = 0; column < 9; ++column) {
                this.m_38897_(new Slot((Container)inventory, 9 + row * 9 + column, playerInventoryStartX + column * slotBuffer, playerInventoryStartY + row * slotBuffer));
            }
        }
        int playerHotbarY = playerInventoryStartY + slotBuffer * 3 + 4;
        for (column = 0; column < 9; ++column) {
            this.m_38897_(new Slot((Container)inventory, column, playerInventoryStartX + column * slotBuffer, playerHotbarY));
        }
    }

    private static IncubatorBlockEntity getIncubator(Inventory inventory, FriendlyByteBuf extraData) {
        BlockEntity entity = inventory.f_35978_.m_9236_().m_7702_(extraData.m_130135_());
        if (entity instanceof IncubatorBlockEntity) {
            return (IncubatorBlockEntity)entity;
        }
        throw new IllegalStateException("Tile entity is not correct! " + entity);
    }

    public boolean m_6875_(Player player) {
        return this.incubator.m_6542_(player);
    }

    public int getBurnProgress() {
        int i = this.incubatorData.m_6413_(1);
        int j = 500;
        return i != 0 ? i * 59 / j : 0;
    }

    public int getLitProgress() {
        return this.incubatorData.m_6413_(0) * 12 / 500;
    }

    public boolean isLit() {
        return this.incubatorData.m_6413_(0) > 0;
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (index < this.incubator.m_6643_() ? !this.m_38903_(itemstack1, this.incubator.m_6643_(), this.f_38839_.size(), true) : !this.m_38903_(itemstack1, 0, this.incubator.m_6643_(), false)) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return itemstack;
    }
}

