/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.exoticbirds.entity;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.pavocado.exoticbirds.entity.AbstractBirdEntity;
import net.pavocado.exoticbirds.entity.ai.BirdBreedGoal;
import net.pavocado.exoticbirds.entity.ai.LayEggInNestGoal;
import net.pavocado.exoticbirds.init.ExoticBirdsEntities;
import net.pavocado.exoticbirds.init.ExoticBirdsItems;
import net.pavocado.exoticbirds.init.ExoticBirdsSoundEvents;

public class CassowaryEntity
extends AbstractBirdEntity
implements NeutralMob {
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.m_145020_((int)20, (int)39);
    private static final Ingredient FOOD_ITEMS = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42410_, Items.f_42732_, Items.f_42780_, Items.f_41952_, Items.f_41953_});
    private static final Map<Integer, ResourceLocation> BIRD_TEXTURES = (Map)Util.m_137469_((Object)Maps.newHashMap(), hashMap -> hashMap.put(0, new ResourceLocation("exoticbirds:textures/entity/cassowary/cassowary_southern.png")));
    private int remainingPersistentAngerTime;
    @Nullable
    private UUID persistentAngerTarget;

    public CassowaryEntity(EntityType<? extends CassowaryEntity> type, Level level) {
        super(type, level, new ItemStack((ItemLike)ExoticBirdsItems.CASSOWARY_EGG.get()), BIRD_TEXTURES.size(), false, false);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.hasChildTextures = true;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new BirdBreedGoal(this, 1.0));
        this.f_21345_.m_25352_(1, (Goal)new CassowaryMeleeAttackGoal());
        this.f_21345_.m_25352_(1, (Goal)new CassowaryPanicGoal());
        this.f_21345_.m_25352_(3, (Goal)new LayEggInNestGoal(this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new CassowaryHurtByTargetGoal());
        this.f_21346_.m_25352_(2, (Goal)new CassowaryAttackPlayersGoal());
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((CassowaryEntity)this).m_21674_(arg_0)));
        this.f_21346_.m_25352_(4, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, false));
    }

    protected float m_6431_(Pose poseIn, EntityDimensions size) {
        return size.f_20378_ * 0.85f;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22277_, 20.0).m_22268_(Attributes.f_22281_, 4.0);
    }

    @Override
    protected Map<Integer, ResourceLocation> getEntityTextures() {
        return BIRD_TEXTURES;
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_(SoundEvents.f_11754_, 0.15f, 0.6f);
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ExoticBirdsSoundEvents.ENTITY_CASSOWARY_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)ExoticBirdsSoundEvents.ENTITY_CASSOWARY_HURT.get();
    }

    public CassowaryEntity getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        CassowaryEntity cassowary = (CassowaryEntity)((EntityType)ExoticBirdsEntities.CASSOWARY.get()).m_20615_((Level)serverLevel);
        if (cassowary != null) {
            cassowary.setVariant(this.getChildVariant());
        }
        return cassowary;
    }

    public boolean m_6898_(ItemStack stack) {
        return false;
    }

    @Override
    public void m_7378_(CompoundTag p_29541_) {
        super.m_7378_(p_29541_);
        this.m_147285_(this.m_9236_(), p_29541_);
    }

    @Override
    public void m_7380_(CompoundTag p_29548_) {
        super.m_7380_(p_29548_);
        this.m_21678_(p_29548_);
    }

    public void m_6825_() {
        this.m_7870_(PERSISTENT_ANGER_TIME.m_214085_(this.f_19796_));
    }

    public void m_7870_(int p_29543_) {
        this.remainingPersistentAngerTime = p_29543_;
    }

    public int m_6784_() {
        return this.remainingPersistentAngerTime;
    }

    public void m_6925_(@Nullable UUID p_29539_) {
        this.persistentAngerTarget = p_29539_;
    }

    @Nullable
    public UUID m_6120_() {
        return this.persistentAngerTarget;
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            this.m_21666_((ServerLevel)this.m_9236_(), true);
        }
    }

    public boolean m_7327_(Entity entity) {
        boolean flag = entity.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), (float)((int)this.m_21133_(Attributes.f_22281_)));
        if (flag) {
            this.m_19970_((LivingEntity)this, entity);
        }
        return flag;
    }

    @Override
    public List<ItemStack> getTemptingItems() {
        return Arrays.asList(FOOD_ITEMS.m_43908_());
    }

    @Override
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag tag) {
        if (!(spawnData instanceof AbstractBirdEntity.BirdGroupData)) {
            spawnData = new AbstractBirdEntity.BirdGroupData((AbstractBirdEntity)this, 0.8f);
        }
        return super.m_6518_(level, difficulty, reason, (SpawnGroupData)spawnData, tag);
    }

    class CassowaryMeleeAttackGoal
    extends MeleeAttackGoal {
        public CassowaryMeleeAttackGoal() {
            super((PathfinderMob)CassowaryEntity.this, 1.25, true);
        }

        protected void m_6739_(LivingEntity p_29589_, double p_29590_) {
            double d0 = this.m_6639_(p_29589_);
            if (p_29590_ <= d0 && this.m_25564_()) {
                this.m_25563_();
                this.f_25540_.m_7327_((Entity)p_29589_);
            } else if (p_29590_ <= d0 * 2.0) {
                if (this.m_25564_()) {
                    this.m_25563_();
                }
            } else {
                this.m_25563_();
            }
        }

        protected double m_6639_(LivingEntity p_29587_) {
            return 4.0f + p_29587_.m_20205_();
        }
    }

    class CassowaryPanicGoal
    extends PanicGoal {
        public CassowaryPanicGoal() {
            super((PathfinderMob)CassowaryEntity.this, 2.0);
        }

        public boolean m_8036_() {
            return (CassowaryEntity.this.m_6162_() || CassowaryEntity.this.m_6060_()) && super.m_8036_();
        }
    }

    class CassowaryHurtByTargetGoal
    extends HurtByTargetGoal {
        public CassowaryHurtByTargetGoal() {
            super((PathfinderMob)CassowaryEntity.this, new Class[0]);
        }

        public void m_8056_() {
            super.m_8056_();
            if (CassowaryEntity.this.m_6162_()) {
                this.m_26047_();
                this.m_8041_();
            }
        }

        protected void m_5766_(Mob p_29580_, LivingEntity p_29581_) {
            if (p_29580_ instanceof CassowaryEntity && !p_29580_.m_6162_()) {
                super.m_5766_(p_29580_, p_29581_);
            }
        }
    }

    class CassowaryAttackPlayersGoal
    extends NearestAttackableTargetGoal<Player> {
        public CassowaryAttackPlayersGoal() {
            super((Mob)CassowaryEntity.this, Player.class, 20, true, true, null);
        }

        public boolean m_8036_() {
            if (!CassowaryEntity.this.m_6162_() && super.m_8036_()) {
                for (CassowaryEntity cassowary : CassowaryEntity.this.m_9236_().m_45976_(CassowaryEntity.class, CassowaryEntity.this.m_20191_().m_82377_(8.0, 4.0, 8.0))) {
                    if (!cassowary.m_6162_()) continue;
                    return true;
                }
            }
            return false;
        }

        protected double m_7623_() {
            return super.m_7623_() * 0.5;
        }
    }
}

