/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.exoticbirds.entity;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.pavocado.exoticbirds.config.ExoticBirdsCommonConfig;
import net.pavocado.exoticbirds.entity.AbstractFlyingBirdEntity;
import net.pavocado.exoticbirds.entity.ai.BirdBreedGoal;
import net.pavocado.exoticbirds.entity.ai.LayEggInNestGoal;
import net.pavocado.exoticbirds.entity.ai.ScavengeGoal;
import net.pavocado.exoticbirds.init.ExoticBirdsEntities;
import net.pavocado.exoticbirds.init.ExoticBirdsItems;
import net.pavocado.exoticbirds.init.ExoticBirdsSoundEvents;

public class MagpieEntity
extends AbstractFlyingBirdEntity {
    private static final Ingredient FOOD_ITEMS = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42404_, Items.f_42578_, Items.f_42577_, Items.f_42733_});
    private static final Ingredient SCAVENGE_ITEMS = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42516_, Items.f_42401_, Items.f_42398_, Items.f_42484_, Items.f_42749_, Items.f_42416_, Items.f_42587_, Items.f_42417_, Items.f_42402_});
    private static final Map<Integer, ResourceLocation> BIRD_TEXTURES = (Map)Util.m_137469_((Object)Maps.newHashMap(), hashMap -> hashMap.put(0, new ResourceLocation("exoticbirds:textures/entity/magpie/magpie_eurasian.png")));
    private int ticksSinceEaten;

    public MagpieEntity(EntityType<? extends MagpieEntity> type, Level level) {
        super(type, level, new ItemStack((ItemLike)ExoticBirdsItems.MAGPIE_EGG.get()), BIRD_TEXTURES.size(), false);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.m_21553_(true);
        this.hasChildTextures = true;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new BirdBreedGoal(this, 1.0));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.4));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.0, FOOD_ITEMS, false));
        this.f_21345_.m_25352_(3, (Goal)new LayEggInNestGoal(this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomFlyingGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new ScavengeGoal(this, (Boolean)ExoticBirdsCommonConfig.allowMagpieScavenge.get(), SCAVENGE_ITEMS, new ResourceLocation("exoticbirds", "gameplay/magpie_scavenging")));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    protected float m_6431_(Pose poseIn, EntityDimensions size) {
        return size.f_20378_ * 0.85f;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 8.0).m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22280_, 2.0);
    }

    @Override
    public void m_8107_() {
        if (!this.m_9236_().f_46443_ && this.m_6084_() && this.m_21515_()) {
            ++this.ticksSinceEaten;
            ItemStack itemstack = this.m_6844_(EquipmentSlot.MAINHAND);
            if (this.canEat(itemstack)) {
                if (this.ticksSinceEaten > 600) {
                    itemstack.m_41774_(1);
                    if (!itemstack.m_41619_()) {
                        this.m_8061_(EquipmentSlot.MAINHAND, itemstack);
                    }
                    this.ticksSinceEaten = 0;
                } else if (this.ticksSinceEaten > 560 && this.f_19796_.m_188501_() < 0.1f) {
                    this.m_5496_(this.m_7866_(itemstack), 1.0f, 1.0f);
                    this.m_9236_().m_7605_((Entity)this, (byte)45);
                }
            }
        }
        super.m_8107_();
    }

    @Override
    protected Map<Integer, ResourceLocation> getEntityTextures() {
        return BIRD_TEXTURES;
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_(SoundEvents.f_11754_, 0.15f, 1.0f);
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ExoticBirdsSoundEvents.ENTITY_MAGPIE_AMBIENT.get();
    }

    public MagpieEntity getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        MagpieEntity magpie = (MagpieEntity)((EntityType)ExoticBirdsEntities.MAGPIE.get()).m_20615_((Level)serverLevel);
        if (magpie != null) {
            magpie.setVariant(this.getChildVariant());
        }
        return magpie;
    }

    public boolean m_6898_(ItemStack stack) {
        return FOOD_ITEMS.test(stack);
    }

    private boolean canEat(ItemStack stack) {
        return FOOD_ITEMS.test(stack) && this.m_5448_() == null && this.m_20096_();
    }

    @Override
    public void m_7822_(byte id) {
        if (id == 45) {
            ItemStack itemstack = this.m_6844_(EquipmentSlot.MAINHAND);
            if (!itemstack.m_41619_()) {
                for (int i = 0; i < 8; ++i) {
                    Vec3 vec3 = new Vec3(((double)this.f_19796_.m_188501_() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0).m_82496_(-this.m_146909_() * ((float)Math.PI / 180)).m_82524_(-this.m_146908_() * ((float)Math.PI / 180));
                    this.m_9236_().m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, itemstack), this.m_20185_() + this.m_20154_().f_82479_ / 2.0, this.m_20186_(), this.m_20189_() + this.m_20154_().f_82481_ / 2.0, vec3.f_82479_, vec3.f_82480_ + 0.05, vec3.f_82481_);
                }
            }
        } else {
            super.m_7822_(id);
        }
    }

    protected void m_142075_(Player player, InteractionHand hand, ItemStack stack) {
        if (this.m_6898_(stack)) {
            this.m_5496_(this.m_7866_(stack), 1.0f, 1.0f);
        }
        super.m_142075_(player, hand, stack);
    }

    public boolean m_7066_(ItemStack stack) {
        EquipmentSlot equipmentslot = Mob.m_147233_((ItemStack)stack);
        if (!this.m_6844_(equipmentslot).m_41619_()) {
            return false;
        }
        return equipmentslot == EquipmentSlot.MAINHAND && super.m_7066_(stack);
    }

    public boolean m_7252_(ItemStack stack) {
        ItemStack itemstack = this.m_6844_(EquipmentSlot.MAINHAND);
        return itemstack.m_41619_() || this.ticksSinceEaten > 0 && FOOD_ITEMS.test(stack) && !FOOD_ITEMS.test(itemstack);
    }

    private void spitOutItem(ItemStack stack) {
        if (!stack.m_41619_() && !this.m_9236_().f_46443_) {
            ItemEntity itementity = new ItemEntity(this.m_9236_(), this.m_20185_() + this.m_20154_().f_82479_, this.m_20186_() + 1.0, this.m_20189_() + this.m_20154_().f_82481_, stack);
            itementity.m_32010_(40);
            itementity.m_32052_(this.m_20148_());
            this.m_5496_(SoundEvents.f_11952_, 1.0f, 1.0f);
            this.m_9236_().m_7967_((Entity)itementity);
        }
    }

    private void dropItemStack(ItemStack stack) {
        ItemEntity itementity = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), stack);
        this.m_9236_().m_7967_((Entity)itementity);
    }

    protected void m_7581_(ItemEntity itemEntity) {
        ItemStack itemstack = itemEntity.m_32055_();
        if (this.m_7252_(itemstack)) {
            int i = itemstack.m_41613_();
            if (i > 1) {
                this.dropItemStack(itemstack.m_41620_(i - 1));
            }
            this.spitOutItem(this.m_6844_(EquipmentSlot.MAINHAND));
            this.m_21053_(itemEntity);
            this.m_8061_(EquipmentSlot.MAINHAND, itemstack.m_41620_(1));
            this.f_21347_[EquipmentSlot.MAINHAND.m_20749_()] = 2.0f;
            this.m_7938_((Entity)itemEntity, itemstack.m_41613_());
            itemEntity.m_146870_();
            this.ticksSinceEaten = FOOD_ITEMS.test(itemstack) ? 400 : 0;
        }
    }

    protected void m_6668_(DamageSource source) {
        ItemStack itemstack = this.m_6844_(EquipmentSlot.MAINHAND);
        if (!itemstack.m_41619_()) {
            this.m_19983_(itemstack);
            this.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
        }
        super.m_6668_(source);
    }

    @Override
    public List<ItemStack> getTemptingItems() {
        return Arrays.asList(FOOD_ITEMS.m_43908_());
    }
}

