/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.exoticbirds.entity;

import com.google.common.collect.Maps;
import com.mojang.serialization.DynamicOps;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.network.NetworkHooks;
import net.pavocado.exoticbirds.ExoticBirdsMod;
import net.pavocado.exoticbirds.block.RoostBoxBlock;
import net.pavocado.exoticbirds.blockentity.RoostBoxBlockEntity;
import net.pavocado.exoticbirds.config.ExoticBirdsCommonConfig;
import net.pavocado.exoticbirds.container.PigeonMenu;
import net.pavocado.exoticbirds.entity.AbstractFlyingBirdEntity;
import net.pavocado.exoticbirds.entity.ai.BirdAvoidEntityGoal;
import net.pavocado.exoticbirds.entity.ai.BirdBreedGoal;
import net.pavocado.exoticbirds.entity.ai.BirdTemptGoal;
import net.pavocado.exoticbirds.entity.ai.LayEggInNestGoal;
import net.pavocado.exoticbirds.init.ExoticBirdsEntities;
import net.pavocado.exoticbirds.init.ExoticBirdsItems;
import net.pavocado.exoticbirds.init.ExoticBirdsSoundEvents;
import org.apache.logging.log4j.Logger;

public class PigeonEntity
extends AbstractFlyingBirdEntity
implements ContainerListener,
MenuProvider {
    private static final UUID ARMOR_MODIFIER_UUID = UUID.fromString("3e14378e-6cd3-4114-9843-91c68435666f");
    private static final EntityDataAccessor<Boolean> DATA_HAS_BACKPACK = SynchedEntityData.m_135353_(PigeonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> DATA_RING_COLOR = SynchedEntityData.m_135353_(PigeonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final Ingredient FOOD_ITEMS = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42404_, Items.f_42578_, Items.f_42577_, Items.f_42733_});
    private static final Ingredient TAMING_ITEMS = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42406_});
    private static final Ingredient TEMPTING_ITEMS = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42404_, Items.f_42578_, Items.f_42577_, Items.f_42733_, Items.f_42406_});
    private static final Map<Integer, ResourceLocation> BIRD_TEXTURES = (Map)Util.m_137469_((Object)Maps.newHashMap(), hashMap -> {
        hashMap.put(0, new ResourceLocation("exoticbirds:textures/entity/pigeon/pigeon_common.png"));
        hashMap.put(1, new ResourceLocation("exoticbirds:textures/entity/pigeon/pigeon_common_white.png"));
    });
    @Nullable
    private BirdAvoidEntityGoal<Player> avoidPlayerGoal;
    private ResourceKey<Level> roostDimension = Level.f_46428_;
    @Nullable
    private BlockPos roostPosition;
    public SimpleContainer inventory;
    private LazyOptional<?> itemHandler = null;

    public PigeonEntity(EntityType<? extends PigeonEntity> type, Level level) {
        super(type, level, new ItemStack((ItemLike)ExoticBirdsItems.PIGEON_EGG.get()), BIRD_TEXTURES.size(), false);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.m_5849_();
        this.initInventory();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.4));
        this.f_21345_.m_25352_(2, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(3, (Goal)new BirdTemptGoal(this, 0.8, TEMPTING_ITEMS, true));
        this.f_21345_.m_25352_(5, (Goal)new LayEggInNestGoal(this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 10.0f, 2.0f, false));
        this.f_21345_.m_25352_(7, (Goal)new BirdBreedGoal(this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new WaterAvoidingRandomFlyingGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(10, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    protected float m_6431_(Pose poseIn, EntityDimensions size) {
        return size.f_20378_ * 0.85f;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 5.0).m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22280_, 2.0);
    }

    @Override
    protected Map<Integer, ResourceLocation> getEntityTextures() {
        return BIRD_TEXTURES;
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_(SoundEvents.f_11754_, 0.15f, 1.0f);
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ExoticBirdsSoundEvents.ENTITY_PIGEON_AMBIENT.get();
    }

    protected void m_5849_() {
        if (this.avoidPlayerGoal == null) {
            this.avoidPlayerGoal = new BirdAvoidEntityGoal<Player>(this, Player.class, 16.0f, 0.8f, 1.33);
        }
        this.f_21345_.m_25363_(this.avoidPlayerGoal);
        if (!this.m_21824_()) {
            this.f_21345_.m_25352_(4, this.avoidPlayerGoal);
        }
    }

    public PigeonEntity getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        PigeonEntity pigeon = (PigeonEntity)((EntityType)ExoticBirdsEntities.PIGEON.get()).m_20615_((Level)serverLevel);
        if (pigeon != null) {
            pigeon.setVariant(this.getChildVariant());
            UUID uuid = this.m_21805_();
            if (uuid != null) {
                pigeon.m_21816_(uuid);
                pigeon.m_7105_(true);
            }
        }
        return pigeon;
    }

    @Override
    public boolean m_7848_(Animal animal) {
        if (super.m_7848_(animal)) {
            return this.m_21824_() && ((PigeonEntity)animal).m_21824_() && !((PigeonEntity)animal).m_21825_();
        }
        return false;
    }

    public void m_7105_(boolean tame) {
        super.m_7105_(tame);
        if (tame) {
            this.m_21153_(5.0f);
            this.setRingColor(DyeColor.RED);
        }
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_RING_COLOR, (Object)DyeColor.RED.m_41060_());
        this.f_19804_.m_135372_(DATA_HAS_BACKPACK, (Object)false);
    }

    protected void initInventory() {
        SimpleContainer simplecontainer = this.inventory;
        this.inventory = new SimpleContainer(1);
        if (simplecontainer != null) {
            simplecontainer.m_19181_((ContainerListener)this);
            int i = Math.min(simplecontainer.m_6643_(), this.inventory.m_6643_());
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = simplecontainer.m_8020_(j);
                if (itemstack.m_41619_()) continue;
                this.inventory.m_6836_(j, itemstack.m_41777_());
            }
        }
        this.inventory.m_19164_((ContainerListener)this);
        this.updateContainerEquipment();
        this.itemHandler = LazyOptional.of(() -> new InvWrapper((Container)this.inventory));
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction facing) {
        if (this.m_6084_() && cap == ForgeCapabilities.ITEM_HANDLER && this.itemHandler != null) {
            return this.itemHandler.cast();
        }
        return super.getCapability(cap, facing);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        if (this.itemHandler != null) {
            this.itemHandler.invalidate();
            this.itemHandler = null;
        }
    }

    public DyeColor getRingColor() {
        return DyeColor.m_41053_((int)((Integer)this.f_19804_.m_135370_(DATA_RING_COLOR)));
    }

    public void setRingColor(DyeColor colour) {
        this.f_19804_.m_135381_(DATA_RING_COLOR, (Object)colour.m_41060_());
    }

    public boolean m_6898_(ItemStack stack) {
        return FOOD_ITEMS.test(stack);
    }

    @Override
    public List<ItemStack> getTemptingItems() {
        return Arrays.asList(TEMPTING_ITEMS.m_43908_());
    }

    @Override
    public List<ItemStack> getTamingItems() {
        return Arrays.asList(TAMING_ITEMS.m_43908_());
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128344_("RingColor", (byte)this.getRingColor().m_41060_());
        if (this.roostPosition != null) {
            tag.m_128405_("RoostX", this.roostPosition.m_123341_());
            tag.m_128405_("RoostY", this.roostPosition.m_123342_());
            tag.m_128405_("RoostZ", this.roostPosition.m_123343_());
            ResourceLocation.f_135803_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this.roostDimension.m_135782_()).resultOrPartial(arg_0 -> ((Logger)ExoticBirdsMod.LOGGER).error(arg_0)).ifPresent(p_9134_ -> tag.m_128365_("RoostDimension", p_9134_));
        }
        tag.m_128379_("HasBackpack", this.hasBackpack());
        if (!this.inventory.m_8020_(0).m_41619_()) {
            tag.m_128365_("ArmorItem", (Tag)this.inventory.m_8020_(0).m_41739_(new CompoundTag()));
        }
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        ItemStack itemstack;
        super.m_7378_(tag);
        if (tag.m_128425_("RingColor", 99)) {
            this.setRingColor(DyeColor.m_41053_((int)tag.m_128451_("RingColor")));
        }
        if (tag.m_128425_("RoostX", 99) && tag.m_128425_("RoostY", 99) && tag.m_128425_("RoostZ", 99)) {
            this.roostPosition = new BlockPos(tag.m_128451_("RoostX"), tag.m_128451_("RoostY"), tag.m_128451_("RoostZ"));
            if (tag.m_128441_("RoostDimension")) {
                this.roostDimension = Level.f_46427_.parse((DynamicOps)NbtOps.f_128958_, (Object)tag.m_128423_("RoostDimension")).resultOrPartial(arg_0 -> ((Logger)ExoticBirdsMod.LOGGER).error(arg_0)).orElse(Level.f_46428_);
            }
        }
        this.setHasBackpack(tag.m_128471_("HasBackpack"));
        if (tag.m_128425_("ArmorItem", 10) && !(itemstack = ItemStack.m_41712_((CompoundTag)tag.m_128469_("ArmorItem"))).m_41619_() && this.isArmor(itemstack)) {
            this.inventory.m_6836_(0, itemstack);
        }
        this.updateContainerEquipment();
    }

    public void m_5757_(Container p_30696_) {
        ItemStack itemstack = this.getArmor();
        this.updateContainerEquipment();
        ItemStack itemstack1 = this.getArmor();
        if (this.f_19797_ > 20 && this.isArmor(itemstack1) && itemstack != itemstack1) {
            this.m_5496_(SoundEvents.f_11678_, 0.5f, 1.0f);
        }
    }

    public ItemStack getArmor() {
        return this.m_6844_(EquipmentSlot.HEAD);
    }

    private void setArmor(ItemStack stack) {
        this.m_8061_(EquipmentSlot.HEAD, stack);
        this.m_21409_(EquipmentSlot.HEAD, 0.0f);
    }

    public boolean isArmor(ItemStack stack) {
        return stack.m_150930_(Items.f_42407_);
    }

    public boolean m_6469_(DamageSource source, float damage) {
        if (this.m_6673_(source)) {
            return false;
        }
        Entity entity = source.m_7639_();
        this.m_21839_(false);
        if (entity != null && !(entity instanceof Player) && !(entity instanceof AbstractArrow)) {
            damage = (damage + 1.0f) / 2.0f;
        }
        return super.m_6469_(source, damage);
    }

    protected void updateContainerEquipment() {
        if (!this.m_9236_().f_46443_) {
            this.setArmorEquipment(this.inventory.m_8020_(0));
            this.m_21409_(EquipmentSlot.HEAD, 0.0f);
        }
    }

    private void setArmorEquipment(ItemStack stack) {
        AttributeInstance armorAttribute;
        this.setArmor(stack);
        if (!this.m_9236_().f_46443_ && (armorAttribute = this.m_21051_(Attributes.f_22284_)) != null) {
            armorAttribute.m_22120_(ARMOR_MODIFIER_UUID);
            if (this.isArmor(stack)) {
                armorAttribute.m_22118_(new AttributeModifier(ARMOR_MODIFIER_UUID, "Pigeon armor bonus", 3.0, AttributeModifier.Operation.ADDITION));
            }
        }
    }

    protected void m_5907_() {
        super.m_5907_();
        if (this.inventory != null) {
            for (int i = 0; i < this.inventory.m_6643_(); ++i) {
                ItemStack itemstack = this.inventory.m_8020_(i);
                if (itemstack.m_41619_() || EnchantmentHelper.m_44924_((ItemStack)itemstack)) continue;
                this.m_19983_(itemstack);
            }
        }
        if (this.hasBackpack()) {
            if (!this.m_9236_().f_46443_) {
                this.m_19998_((ItemLike)ExoticBirdsItems.PIGEON_BACKPACK.get());
            }
            this.setHasBackpack(false);
        }
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (!this.m_6162_() && this.m_21824_() && this.m_21830_((LivingEntity)player) && player.m_36341_() && !this.m_9236_().f_46443_) {
            RoostStatus roostStatus = this.getRoostBoxStatus(player.m_20194_());
            if (roostStatus == RoostStatus.NOT_SET) {
                NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)this, buf -> {
                    buf.writeInt(this.m_19879_());
                    buf.m_130068_((Enum)roostStatus);
                });
            } else {
                NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)this, buf -> {
                    buf.writeInt(this.m_19879_());
                    buf.m_130068_((Enum)roostStatus);
                    buf.m_236814_(GlobalPos.m_122643_(this.roostDimension, (BlockPos)Objects.requireNonNull(this.roostPosition)));
                });
            }
            return InteractionResult.SUCCESS;
        }
        if (!itemstack.m_41619_()) {
            if (this.m_6898_(itemstack)) {
                if (this.m_21223_() < this.m_21233_()) {
                    if (!player.m_150110_().f_35937_) {
                        itemstack.m_41774_(1);
                    }
                    this.m_5634_(4.0f);
                    this.m_146852_(GameEvent.f_157806_, (Entity)this);
                    return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
                }
                return super.m_6071_(player, hand);
            }
            InteractionResult interactionresult = itemstack.m_41647_(player, (LivingEntity)this, hand);
            if (interactionresult.m_19077_()) {
                return interactionresult;
            }
            if (!this.m_21824_() && TAMING_ITEMS.test(itemstack)) {
                if (!player.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                if (!this.m_9236_().f_46443_) {
                    if (this.f_19796_.m_188503_(3) == 0 && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)player)) {
                        this.m_21828_(player);
                        this.f_21344_.m_26573_();
                        this.m_21839_(true);
                        this.m_9236_().m_7605_((Entity)this, (byte)7);
                    } else {
                        this.m_9236_().m_7605_((Entity)this, (byte)6);
                    }
                }
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            Item item = itemstack.m_41720_();
            if (item instanceof DyeItem) {
                DyeItem dye = (DyeItem)item;
                DyeColor dyecolor = dye.m_41089_();
                if (dyecolor != this.getRingColor()) {
                    this.setRingColor(dyecolor);
                    if (!player.m_150110_().f_35937_) {
                        itemstack.m_41774_(1);
                    }
                    return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
                }
                return InteractionResult.PASS;
            }
        }
        if (!this.m_29443_() && this.m_21824_() && this.m_21830_((LivingEntity)player)) {
            if (!this.m_9236_().f_46443_) {
                this.m_21839_(!this.m_21827_());
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return super.m_6071_(player, hand);
    }

    public boolean canHaveBackpack() {
        return this.m_6084_() && !this.m_6162_() && this.m_21824_();
    }

    public void setRoostBlock(BlockState state, Level level, BlockPos blockPos, Player player) {
        Block block = state.m_60734_();
        if (block instanceof RoostBoxBlock) {
            this.roostPosition = blockPos;
            this.roostDimension = level.m_46472_();
            player.m_213846_((Component)Component.m_237115_((String)"block.exoticbirds.roost_box.set_success"));
        }
    }

    public RoostStatus getRoostBoxStatus(MinecraftServer server) {
        if (server != null) {
            ServerLevel serverlevel = server.m_129880_(this.roostDimension);
            BlockPos blockpos = this.roostPosition;
            if (serverlevel != null && blockpos != null) {
                BlockEntity blockEntity = serverlevel.m_7702_(blockpos);
                if (blockEntity instanceof RoostBoxBlockEntity) {
                    RoostBoxBlockEntity boxEntity = (RoostBoxBlockEntity)blockEntity;
                    if (boxEntity.getPigeon() != null) {
                        return RoostStatus.FULL_PIGEON;
                    }
                    if (!boxEntity.couldInsertItem()) {
                        return RoostStatus.FULL_ITEMS;
                    }
                    return RoostStatus.READY;
                }
                return RoostStatus.MISSING;
            }
        }
        return RoostStatus.NOT_SET;
    }

    public boolean takeItemToRoostBox(ServerPlayer player, ItemStack stack) {
        if (!((Boolean)ExoticBirdsCommonConfig.allowPigeonMail.get()).booleanValue()) {
            player.m_213846_((Component)Component.m_237115_((String)"block.exoticbirds.roost_box.mail_disabled"));
            return false;
        }
        MinecraftServer server = player.m_20194_();
        if (server != null) {
            BlockPos blockpos = this.roostPosition;
            ServerLevel serverlevel = server.m_129880_(this.roostDimension);
            if (serverlevel != null && blockpos != null) {
                BlockEntity blockEntity = serverlevel.m_7702_(blockpos);
                if (blockEntity instanceof RoostBoxBlockEntity) {
                    RoostBoxBlockEntity boxEntity = (RoostBoxBlockEntity)blockEntity;
                    if (boxEntity.getPigeon() != null) {
                        player.m_213846_((Component)Component.m_237115_((String)"block.exoticbirds.roost_box.already_has_pigeon"));
                    } else if (!boxEntity.insertItem(stack)) {
                        player.m_213846_((Component)Component.m_237115_((String)"block.exoticbirds.roost_box.full"));
                    } else {
                        this.m_21837_(false);
                        this.m_6853_(true);
                        boxEntity.setPigeon(this);
                        player.m_213846_((Component)Component.m_237115_((String)"block.exoticbirds.roost_box.send_success"));
                        return true;
                    }
                    return false;
                }
                player.m_213846_((Component)Component.m_237115_((String)"block.exoticbirds.roost_box.missing"));
                return false;
            }
        }
        player.m_213846_((Component)Component.m_237115_((String)"block.exoticbirds.roost_box.not_set"));
        return false;
    }

    public void setHasBackpack(boolean hasBackpack) {
        this.f_19804_.m_135381_(DATA_HAS_BACKPACK, (Object)hasBackpack);
    }

    public boolean hasBackpack() {
        return (Boolean)this.f_19804_.m_135370_(DATA_HAS_BACKPACK);
    }

    public void equipBackpack(@Nullable SoundSource soundSource) {
        this.setHasBackpack(true);
        if (soundSource != null) {
            this.m_9236_().m_6269_(null, (Entity)this, SoundEvents.f_12236_, soundSource, 0.5f, 1.0f);
        }
    }

    @org.jetbrains.annotations.Nullable
    public AbstractContainerMenu m_7208_(int windowId, Inventory inventory, Player player) {
        return new PigeonMenu(windowId, inventory, this);
    }

    public boolean hasInventoryChanged(Container container) {
        return this.inventory != container;
    }

    private SlotAccess createEquipmentSlotAccess(final int slot, final Predicate<ItemStack> predicate) {
        return new SlotAccess(){

            public ItemStack m_142196_() {
                return PigeonEntity.this.inventory.m_8020_(slot);
            }

            public boolean m_142104_(ItemStack stack) {
                if (!predicate.test(stack)) {
                    return false;
                }
                PigeonEntity.this.inventory.m_6836_(slot, stack);
                return true;
            }
        };
    }

    public SlotAccess m_141942_(int slot) {
        if (slot == 499) {
            return new SlotAccess(){

                public ItemStack m_142196_() {
                    return PigeonEntity.this.hasBackpack() ? new ItemStack((ItemLike)ExoticBirdsItems.PIGEON_BACKPACK.get()) : ItemStack.f_41583_;
                }

                public boolean m_142104_(ItemStack stack) {
                    if (stack.m_41619_()) {
                        if (PigeonEntity.this.hasBackpack()) {
                            PigeonEntity.this.setHasBackpack(false);
                        }
                        return true;
                    }
                    if (stack.m_150930_((Item)ExoticBirdsItems.PIGEON_BACKPACK.get())) {
                        if (!PigeonEntity.this.hasBackpack()) {
                            PigeonEntity.this.setHasBackpack(true);
                        }
                        return true;
                    }
                    return false;
                }
            };
        }
        int i = slot - 400;
        if (i == 0 && i < this.inventory.m_6643_()) {
            return this.createEquipmentSlotAccess(i, stack -> stack.m_41619_() || stack.m_150930_(Items.f_42407_));
        }
        int j = slot - 500 + 1;
        return j >= 1 && j < this.inventory.m_6643_() ? SlotAccess.m_147292_((Container)this.inventory, (int)j) : super.m_141942_(slot);
    }

    @Override
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag tag) {
        SpawnGroupData data = super.m_6518_(level, difficulty, reason, spawnData, tag);
        this.setVariant(this.getRandomVariant());
        return data;
    }

    public static enum RoostStatus {
        NOT_SET,
        MISSING,
        FULL_ITEMS,
        FULL_PIGEON,
        READY;

    }
}

