/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.exoticbirds.init;

import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import net.pavocado.exoticbirds.block.BirdcageBlock;
import net.pavocado.exoticbirds.block.BirdhouseBlock;
import net.pavocado.exoticbirds.block.HummingbirdFeederBlock;
import net.pavocado.exoticbirds.block.IdentifierBlock;
import net.pavocado.exoticbirds.block.IncubatorBlock;
import net.pavocado.exoticbirds.block.NestBlock;
import net.pavocado.exoticbirds.block.PhoenixEggBlock;
import net.pavocado.exoticbirds.block.RoostBoxBlock;
import net.pavocado.exoticbirds.init.ExoticBirdsItems;

public final class ExoticBirdsBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"exoticbirds");
    public static final RegistryObject<NestBlock> NEST = ExoticBirdsBlocks.registerBlock("nest", () -> new NestBlock(BlockBehaviour.Properties.m_284310_().m_284268_(DyeColor.BROWN).m_60978_(0.5f).m_60918_(SoundType.f_56740_)));
    public static final RegistryObject<IdentifierBlock> EGG_IDENTIFIER = ExoticBirdsBlocks.registerBlock("egg_identifier", () -> new IdentifierBlock(BlockBehaviour.Properties.m_284310_().m_284268_(DyeColor.GREEN).m_280658_(NoteBlockInstrument.IRON_XYLOPHONE).m_60918_(SoundType.f_56743_).m_60999_().m_60978_(3.5f).m_60918_(SoundType.f_56743_).m_60953_(ExoticBirdsBlocks.litBlockEmission(13))));
    public static final RegistryObject<IncubatorBlock> EGG_INCUBATOR = ExoticBirdsBlocks.registerBlock("egg_incubator", () -> new IncubatorBlock(BlockBehaviour.Properties.m_284310_().m_284268_(DyeColor.ORANGE).m_280658_(NoteBlockInstrument.IRON_XYLOPHONE).m_60918_(SoundType.f_56743_).m_60999_().m_60978_(3.5f).m_60918_(SoundType.f_56743_).m_60953_(ExoticBirdsBlocks.litBlockEmission(13))));
    public static final RegistryObject<BirdcageBlock> BIRDCAGE_IRON = ExoticBirdsBlocks.registerBlockWithoutBlockItem("iron_birdcage", () -> new BirdcageBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_280658_(NoteBlockInstrument.IRON_XYLOPHONE).m_60918_(SoundType.f_56743_).m_60978_(0.7f).m_60918_(SoundType.f_56743_)));
    public static final RegistryObject<BirdcageBlock> BIRDCAGE_GOLD = ExoticBirdsBlocks.registerBlockWithoutBlockItem("gold_birdcage", () -> new BirdcageBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283757_).m_280658_(NoteBlockInstrument.BELL).m_60918_(SoundType.f_56743_).m_60978_(0.7f).m_60918_(SoundType.f_56743_)));
    public static final RegistryObject<BirdcageBlock> BIRDCAGE_OAK = ExoticBirdsBlocks.registerBlockWithoutBlockItem("oak_birdcage", () -> new BirdcageBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_280658_(NoteBlockInstrument.BASS).m_60918_(SoundType.f_56736_).m_60978_(0.7f).m_60918_(SoundType.f_56736_)));
    public static final RegistryObject<BirdcageBlock> BIRDCAGE_SPRUCE = ExoticBirdsBlocks.registerBlockWithoutBlockItem("spruce_birdcage", () -> new BirdcageBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283819_).m_280658_(NoteBlockInstrument.BASS).m_60918_(SoundType.f_56736_).m_60978_(0.7f).m_60918_(SoundType.f_56736_)));
    public static final RegistryObject<BirdcageBlock> BIRDCAGE_BIRCH = ExoticBirdsBlocks.registerBlockWithoutBlockItem("birch_birdcage", () -> new BirdcageBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283761_).m_280658_(NoteBlockInstrument.BASS).m_60918_(SoundType.f_56736_).m_60978_(0.7f).m_60918_(SoundType.f_56736_)));
    public static final RegistryObject<BirdcageBlock> BIRDCAGE_JUNGLE = ExoticBirdsBlocks.registerBlockWithoutBlockItem("jungle_birdcage", () -> new BirdcageBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283762_).m_280658_(NoteBlockInstrument.BASS).m_60918_(SoundType.f_56736_).m_60978_(0.7f).m_60918_(SoundType.f_56736_)));
    public static final RegistryObject<BirdcageBlock> BIRDCAGE_ACACIA = ExoticBirdsBlocks.registerBlockWithoutBlockItem("acacia_birdcage", () -> new BirdcageBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283750_).m_280658_(NoteBlockInstrument.BASS).m_60918_(SoundType.f_56736_).m_60978_(0.7f).m_60918_(SoundType.f_56736_)));
    public static final RegistryObject<BirdcageBlock> BIRDCAGE_DARK_OAK = ExoticBirdsBlocks.registerBlockWithoutBlockItem("dark_oak_birdcage", () -> new BirdcageBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283748_).m_280658_(NoteBlockInstrument.BASS).m_60918_(SoundType.f_56736_).m_60978_(0.7f).m_60918_(SoundType.f_56736_)));
    public static final RegistryObject<BirdcageBlock> BIRDCAGE_MANGROVE = ExoticBirdsBlocks.registerBlockWithoutBlockItem("mangrove_birdcage", () -> new BirdcageBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283913_).m_280658_(NoteBlockInstrument.BASS).m_60918_(SoundType.f_56736_).m_60978_(0.7f).m_60918_(SoundType.f_56736_)));
    public static final RegistryObject<BirdcageBlock> BIRDCAGE_WARPED = ExoticBirdsBlocks.registerBlockWithoutBlockItem("warped_birdcage", () -> new BirdcageBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283749_).m_280658_(NoteBlockInstrument.BASS).m_60918_(SoundType.f_56736_).m_60978_(0.7f).m_60918_(SoundType.f_56736_)));
    public static final RegistryObject<BirdcageBlock> BIRDCAGE_CRIMSON = ExoticBirdsBlocks.registerBlockWithoutBlockItem("crimson_birdcage", () -> new BirdcageBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283804_).m_280658_(NoteBlockInstrument.BASS).m_60918_(SoundType.f_56736_).m_60978_(0.7f).m_60918_(SoundType.f_56736_)));
    public static final RegistryObject<BirdcageBlock> BIRDCAGE_BAMBOO = ExoticBirdsBlocks.registerBlockWithoutBlockItem("bamboo_birdcage", () -> new BirdcageBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283832_).m_280658_(NoteBlockInstrument.BASS).m_60918_(SoundType.f_56736_).m_60978_(0.7f).m_60918_(SoundType.f_56736_)));
    public static final RegistryObject<BirdcageBlock> BIRDCAGE_CHERRY = ExoticBirdsBlocks.registerBlockWithoutBlockItem("cherry_birdcage", () -> new BirdcageBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283832_).m_280658_(NoteBlockInstrument.BASS).m_60918_(SoundType.f_56736_).m_60978_(0.7f).m_60918_(SoundType.f_56736_)));
    public static final RegistryObject<PhoenixEggBlock> PHOENIX_EGG = ExoticBirdsBlocks.registerBlockWithoutBlockItem("phoenix_egg", () -> new PhoenixEggBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283761_).m_280658_(NoteBlockInstrument.BASEDRUM).m_60978_(1.5f).m_60953_(x -> 5).m_60918_(SoundType.f_56736_).m_60955_()));
    public static final RegistryObject<PhoenixEggBlock> CLOUD_PHOENIX_EGG = ExoticBirdsBlocks.registerBlockWithRarity("cloud_phoenix_egg", () -> new PhoenixEggBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)PHOENIX_EGG.get()))));
    public static final RegistryObject<PhoenixEggBlock> DESERT_PHOENIX_EGG = ExoticBirdsBlocks.registerBlockWithRarity("desert_phoenix_egg", () -> new PhoenixEggBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)PHOENIX_EGG.get()))));
    public static final RegistryObject<PhoenixEggBlock> ENDER_PHOENIX_EGG = ExoticBirdsBlocks.registerBlockWithRarity("ender_phoenix_egg", () -> new PhoenixEggBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)PHOENIX_EGG.get()))));
    public static final RegistryObject<PhoenixEggBlock> FIRE_PHOENIX_EGG = ExoticBirdsBlocks.registerBlockWithRarity("fire_phoenix_egg", () -> new PhoenixEggBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)PHOENIX_EGG.get()))));
    public static final RegistryObject<PhoenixEggBlock> NETHER_PHOENIX_EGG = ExoticBirdsBlocks.registerBlockWithRarity("nether_phoenix_egg", () -> new PhoenixEggBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)PHOENIX_EGG.get()))));
    public static final RegistryObject<PhoenixEggBlock> SKELETON_PHOENIX_EGG = ExoticBirdsBlocks.registerBlockWithRarity("skeleton_phoenix_egg", () -> new PhoenixEggBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)PHOENIX_EGG.get()))));
    public static final RegistryObject<PhoenixEggBlock> SNOWY_PHOENIX_EGG = ExoticBirdsBlocks.registerBlockWithRarity("snowy_phoenix_egg", () -> new PhoenixEggBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)PHOENIX_EGG.get()))));
    public static final RegistryObject<PhoenixEggBlock> TWILIGHT_PHOENIX_EGG = ExoticBirdsBlocks.registerBlockWithRarity("twilight_phoenix_egg", () -> new PhoenixEggBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)PHOENIX_EGG.get()))));
    public static final RegistryObject<PhoenixEggBlock> WATER_PHOENIX_EGG = ExoticBirdsBlocks.registerBlockWithRarity("water_phoenix_egg", () -> new PhoenixEggBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)PHOENIX_EGG.get()))));
    public static final RegistryObject<Block> HUMMINGBIRD_FEEDER = ExoticBirdsBlocks.registerBlock("hummingbird_feeder", () -> new HummingbirdFeederBlock(BlockBehaviour.Properties.m_284310_().m_284268_(DyeColor.RED).m_280658_(NoteBlockInstrument.HAT).m_60918_(SoundType.f_56744_).m_60978_(1.0f).m_60918_(SoundType.f_56736_).m_60955_()));
    public static final RegistryObject<BirdhouseBlock> WHITE_BIRDHOUSE = ExoticBirdsBlocks.registerBlock("white_birdhouse", () -> new BirdhouseBlock(BlockBehaviour.Properties.m_284310_().m_284268_(DyeColor.WHITE).m_280658_(NoteBlockInstrument.BASS).m_60918_(SoundType.f_56736_).m_60913_(2.0f, 3.0f)));
    public static final RegistryObject<BirdhouseBlock> ORANGE_BIRDHOUSE = ExoticBirdsBlocks.registerBlock("orange_birdhouse", () -> new BirdhouseBlock(BlockBehaviour.Properties.m_284310_().m_284268_(DyeColor.ORANGE).m_280658_(NoteBlockInstrument.BASS).m_60918_(SoundType.f_56736_).m_60913_(2.0f, 3.0f)));
    public static final RegistryObject<BirdhouseBlock> MAGENTA_BIRDHOUSE = ExoticBirdsBlocks.registerBlock("magenta_birdhouse", () -> new BirdhouseBlock(BlockBehaviour.Properties.m_284310_().m_284268_(DyeColor.MAGENTA).m_280658_(NoteBlockInstrument.BASS).m_60918_(SoundType.f_56736_).m_60913_(2.0f, 3.0f)));
    public static final RegistryObject<BirdhouseBlock> LIGHT_BLUE_BIRDHOUSE = ExoticBirdsBlocks.registerBlock("light_blue_birdhouse", () -> new BirdhouseBlock(BlockBehaviour.Properties.m_284310_().m_284268_(DyeColor.LIGHT_BLUE).m_280658_(NoteBlockInstrument.BASS).m_60918_(SoundType.f_56736_).m_60913_(2.0f, 3.0f)));
    public static final RegistryObject<BirdhouseBlock> YELLOW_BIRDHOUSE = ExoticBirdsBlocks.registerBlock("yellow_birdhouse", () -> new BirdhouseBlock(BlockBehaviour.Properties.m_284310_().m_284268_(DyeColor.YELLOW).m_280658_(NoteBlockInstrument.BASS).m_60918_(SoundType.f_56736_).m_60913_(2.0f, 3.0f)));
    public static final RegistryObject<BirdhouseBlock> LIME_BIRDHOUSE = ExoticBirdsBlocks.registerBlock("lime_birdhouse", () -> new BirdhouseBlock(BlockBehaviour.Properties.m_284310_().m_284268_(DyeColor.LIME).m_280658_(NoteBlockInstrument.BASS).m_60918_(SoundType.f_56736_).m_60913_(2.0f, 3.0f)));
    public static final RegistryObject<BirdhouseBlock> PINK_BIRDHOUSE = ExoticBirdsBlocks.registerBlock("pink_birdhouse", () -> new BirdhouseBlock(BlockBehaviour.Properties.m_284310_().m_284268_(DyeColor.PINK).m_280658_(NoteBlockInstrument.BASS).m_60918_(SoundType.f_56736_).m_60913_(2.0f, 3.0f)));
    public static final RegistryObject<BirdhouseBlock> GRAY_BIRDHOUSE = ExoticBirdsBlocks.registerBlock("gray_birdhouse", () -> new BirdhouseBlock(BlockBehaviour.Properties.m_284310_().m_284268_(DyeColor.GRAY).m_280658_(NoteBlockInstrument.BASS).m_60918_(SoundType.f_56736_).m_60913_(2.0f, 3.0f)));
    public static final RegistryObject<BirdhouseBlock> LIGHT_GRAY_BIRDHOUSE = ExoticBirdsBlocks.registerBlock("light_gray_birdhouse", () -> new BirdhouseBlock(BlockBehaviour.Properties.m_284310_().m_284268_(DyeColor.LIGHT_GRAY).m_280658_(NoteBlockInstrument.BASS).m_60918_(SoundType.f_56736_).m_60913_(2.0f, 3.0f)));
    public static final RegistryObject<BirdhouseBlock> CYAN_BIRDHOUSE = ExoticBirdsBlocks.registerBlock("cyan_birdhouse", () -> new BirdhouseBlock(BlockBehaviour.Properties.m_284310_().m_284268_(DyeColor.CYAN).m_280658_(NoteBlockInstrument.BASS).m_60918_(SoundType.f_56736_).m_60913_(2.0f, 3.0f)));
    public static final RegistryObject<BirdhouseBlock> PURPLE_BIRDHOUSE = ExoticBirdsBlocks.registerBlock("purple_birdhouse", () -> new BirdhouseBlock(BlockBehaviour.Properties.m_284310_().m_284268_(DyeColor.PURPLE).m_280658_(NoteBlockInstrument.BASS).m_60918_(SoundType.f_56736_).m_60913_(2.0f, 3.0f)));
    public static final RegistryObject<BirdhouseBlock> BLUE_BIRDHOUSE = ExoticBirdsBlocks.registerBlock("blue_birdhouse", () -> new BirdhouseBlock(BlockBehaviour.Properties.m_284310_().m_284268_(DyeColor.BLUE).m_280658_(NoteBlockInstrument.BASS).m_60918_(SoundType.f_56736_).m_60913_(2.0f, 3.0f)));
    public static final RegistryObject<BirdhouseBlock> BROWN_BIRDHOUSE = ExoticBirdsBlocks.registerBlock("brown_birdhouse", () -> new BirdhouseBlock(BlockBehaviour.Properties.m_284310_().m_284268_(DyeColor.BROWN).m_280658_(NoteBlockInstrument.BASS).m_60918_(SoundType.f_56736_).m_60913_(2.0f, 3.0f)));
    public static final RegistryObject<BirdhouseBlock> GREEN_BIRDHOUSE = ExoticBirdsBlocks.registerBlock("green_birdhouse", () -> new BirdhouseBlock(BlockBehaviour.Properties.m_284310_().m_284268_(DyeColor.GREEN).m_280658_(NoteBlockInstrument.BASS).m_60918_(SoundType.f_56736_).m_60913_(2.0f, 3.0f)));
    public static final RegistryObject<BirdhouseBlock> RED_BIRDHOUSE = ExoticBirdsBlocks.registerBlock("red_birdhouse", () -> new BirdhouseBlock(BlockBehaviour.Properties.m_284310_().m_284268_(DyeColor.RED).m_280658_(NoteBlockInstrument.BASS).m_60918_(SoundType.f_56736_).m_60913_(2.0f, 3.0f)));
    public static final RegistryObject<BirdhouseBlock> BLACK_BIRDHOUSE = ExoticBirdsBlocks.registerBlock("black_birdhouse", () -> new BirdhouseBlock(BlockBehaviour.Properties.m_284310_().m_284268_(DyeColor.BLACK).m_280658_(NoteBlockInstrument.BASS).m_60918_(SoundType.f_56736_).m_60913_(2.0f, 3.0f)));
    public static final RegistryObject<RoostBoxBlock> ROOST_BOX = ExoticBirdsBlocks.registerBlock("roost_box", () -> new RoostBoxBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_280658_(NoteBlockInstrument.BASS).m_60918_(SoundType.f_56736_).m_60913_(2.0f, 3.0f)));

    private static <T extends Block> RegistryObject<T> registerBlock(String name, Supplier<T> block) {
        RegistryObject toReturn = BLOCKS.register(name, block);
        ExoticBirdsBlocks.registerBlockItem(name, toReturn, Rarity.COMMON);
        return toReturn;
    }

    private static <T extends Block> RegistryObject<T> registerBlockWithRarity(String name, Supplier<T> block) {
        RegistryObject toReturn = BLOCKS.register(name, block);
        ExoticBirdsBlocks.registerBlockItem(name, toReturn, Rarity.UNCOMMON);
        return toReturn;
    }

    private static <T extends Block> RegistryObject<T> registerBlockWithoutBlockItem(String name, Supplier<T> block) {
        return BLOCKS.register(name, block);
    }

    private static <T extends Block> void registerBlockItem(String name, RegistryObject<T> block, Rarity rarity) {
        ExoticBirdsItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties().m_41497_(rarity)));
    }

    private static ToIntFunction<BlockState> litBlockEmission(int lightLevel) {
        return state -> (Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_) != false ? lightLevel : 0;
    }
}

