/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.exoticbirds.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public class PacketLogPhoenixEgg {
    private final BlockPos eggPos;
    private final int hatchRate;

    public PacketLogPhoenixEgg(BlockPos eggPos, int hatchRate) {
        this.eggPos = eggPos;
        this.hatchRate = hatchRate;
    }

    public static void encode(PacketLogPhoenixEgg message, FriendlyByteBuf buffer) {
        buffer.m_130064_(message.eggPos);
        buffer.writeInt(message.hatchRate);
    }

    public static PacketLogPhoenixEgg decode(FriendlyByteBuf buffer) {
        return new PacketLogPhoenixEgg(buffer.m_130135_(), buffer.readInt());
    }

    public static void handle(PacketLogPhoenixEgg packet, Supplier<NetworkEvent.Context> contextSupplier) {
        contextSupplier.get().enqueueWork(() -> PacketLogPhoenixEgg.handleOnClient(packet));
        contextSupplier.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handleOnClient(PacketLogPhoenixEgg packet) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            float hatchPercentage = 100.0f * ((float)(48000 - packet.hatchRate) / 48000.0f);
            player.m_213846_((Component)Component.m_237110_((String)"egg.exoticbirds.status", (Object[])new Object[]{String.format("%.2f", Float.valueOf(hatchPercentage))}));
        }
    }
}

