/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.builder;

import com.google.common.collect.Sets;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.MouseHandler;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.tooltip.BelowOrAboveWidgetTooltipPositioner;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2f;
import org.joml.Vector2i;
import org.lwjgl.glfw.GLFW;
import snownee.kiwi.customization.builder.ItemButton;
import snownee.kiwi.customization.builder.PanelLayout;
import snownee.kiwi.customization.network.CConvertItemPacket;
import snownee.kiwi.loader.Platform;
import snownee.kiwi.util.KHolder;
import snownee.kiwi.util.LerpedFloat;
import snownee.kiwi.util.MultilineTooltip;
import snownee.kiwi.util.NotNullByDefault;

@NotNullByDefault
public class ConvertScreen
extends Screen {
    private static ConvertScreen lingeringScreen;
    private final boolean inContainer;
    private final boolean inCreativeContainer;
    @Nullable
    private final Slot slot;
    private final int slotIndex;
    private final Collection<CConvertItemPacket.Group> groups;
    private final LerpedFloat openProgress = LerpedFloat.linear();
    private PanelLayout layout;
    private final Vector2i originalMousePos;
    private final ItemStack sourceItem;

    private static Vector2i getMousePos() {
        Minecraft mc = Minecraft.m_91087_();
        MouseHandler mouseHandler = mc.f_91067_;
        return new Vector2i((int)mouseHandler.m_91589_(), (int)mouseHandler.m_91594_());
    }

    public ConvertScreen(@Nullable Screen parent, @Nullable Slot slot, int slotIndex, List<CConvertItemPacket.Group> groups) {
        super((Component)Component.m_237115_((String)"gui.kiwi.builder.convert"));
        this.slot = slot;
        this.slotIndex = slotIndex;
        this.groups = groups;
        this.inContainer = parent instanceof AbstractContainerScreen;
        this.inCreativeContainer = parent instanceof CreativeModeInventoryScreen;
        this.originalMousePos = ConvertScreen.getMousePos();
        this.openProgress.setValue(0.2f);
        this.openProgress.chase(1.0, 0.8, LerpedFloat.Chaser.EXP);
        this.sourceItem = this.getSourceItem();
    }

    private ItemStack getSourceItem() {
        if (this.slot != null) {
            return this.slot.m_7993_();
        }
        Inventory inventory = Objects.requireNonNull(Minecraft.m_91087_().f_91074_).m_150109_();
        return inventory.m_8020_(this.slotIndex);
    }

    protected void m_7856_() {
        Vector2f anchor;
        int y;
        int x;
        this.layout = new PanelLayout(2);
        int step = this.inContainer ? 19 : 21;
        int xStart = 0;
        int yStart = 0;
        int curX = xStart;
        int curY = yStart;
        HashSet accepted = Sets.newHashSet();
        LocalPlayer player = Objects.requireNonNull(this.getMinecraft().f_91074_);
        for (CConvertItemPacket.Group group : this.groups) {
            accepted.addAll(group.entries());
        }
        int itemsPerLine = accepted.size() > 30 ? 11 : 4;
        Button cursorOn = null;
        for (CConvertItemPacket.Group group : this.groups) {
            for (CConvertItemPacket.Entry entry : group.entries()) {
                List<Component> tooltip;
                if (!accepted.contains(entry)) continue;
                ItemStack itemStack = new ItemStack((ItemLike)entry.item());
                Button button = ItemButton.builder(itemStack, this.inContainer, btn -> {
                    Item to;
                    Item from = this.sourceItem.m_41720_();
                    if (from == (to = ((ItemButton)btn).getItem().m_41720_())) {
                        this.m_7379_();
                        return;
                    }
                    boolean convertOne = ConvertScreen.m_96637_();
                    LocalPlayer player0 = Objects.requireNonNull(this.getMinecraft().f_91074_);
                    if (this.inCreativeContainer && convertOne) {
                        CConvertItemPacket.send(false, -500, entry, from, true);
                    } else if (this.inCreativeContainer) {
                        Objects.requireNonNull(this.slot);
                        ItemStack newItem = to.m_7968_();
                        newItem.m_41764_(this.slot.m_7993_().m_41613_());
                        newItem.m_41754_(5);
                        this.slot.m_269060_(newItem);
                        NonNullList slots = player0.f_36095_.f_38839_;
                        for (int i = 0; i < slots.size(); ++i) {
                            if (((Slot)slots.get(i)).m_7993_() != newItem) continue;
                            Objects.requireNonNull(this.getMinecraft().f_91072_).m_105241_(newItem, i);
                            CConvertItemPacket.playPickupSound((Player)player0);
                            break;
                        }
                    } else {
                        CConvertItemPacket.send(this.inContainer, this.slotIndex, entry, from, convertOne);
                    }
                    if (convertOne && (player0.m_7500_() || this.sourceItem.m_41613_() > 1)) {
                        return;
                    }
                    if (this.inContainer) {
                        GLFW.glfwSetCursorPos((long)this.getMinecraft().m_91268_().m_85439_(), (double)this.originalMousePos.x, (double)this.originalMousePos.y);
                    }
                    this.m_7379_();
                }).m_252987_(curX, curY, 21, 21).m_253136_();
                button.m_93650_(this.inContainer ? 0.2f : 0.8f);
                if (Platform.isProduction()) {
                    tooltip = List.of(itemStack.m_41786_());
                } else {
                    String steps = String.join((CharSequence)" -> ", entry.steps().stream().map(Pair::getFirst).map(KHolder::key).map(Objects::toString).toList());
                    tooltip = List.of(itemStack.m_41786_(), Component.m_237113_((String)steps).m_130940_(ChatFormatting.GRAY));
                }
                button.m_257544_(MultilineTooltip.create(tooltip));
                if (cursorOn == null && itemStack.m_150930_(this.sourceItem.m_41720_())) {
                    cursorOn = button;
                }
                this.layout.addWidget((AbstractWidget)button);
                if ((curX += step) < xStart + itemsPerLine * step) continue;
                curX = xStart;
                curY += step;
            }
        }
        if (this.inContainer) {
            x = this.f_96543_ / 2;
            y = this.f_96544_ / 2;
            anchor = new Vector2f(0.5f, 0.5f);
        } else {
            HumanoidArm humanoidarm;
            x = this.slotIndex == 40 ? ((humanoidarm = player.m_5737_().m_20828_()) == HumanoidArm.LEFT ? this.f_96543_ / 2 - 91 - 29 + 11 : this.f_96543_ / 2 + 91 + 17) : this.f_96543_ / 2 - 91 + 11 + player.m_150109_().f_35977_ * 20;
            y = this.f_96544_ - 24;
            anchor = new Vector2f(0.5f, 1.0f);
        }
        this.layout.bind(this, new Vector2i(x, y), anchor);
        if (cursorOn != null) {
            Window window = this.getMinecraft().m_91268_();
            double scale = window.m_85449_();
            GLFW.glfwSetCursorPos((long)window.m_85439_(), (double)((double)(cursorOn.m_252754_() + 15) * scale), (double)((double)(cursorOn.m_252907_() + 15) * scale));
        }
        Rect2i bounds = this.layout.bounds();
        StringWidget dummySpacer = new StringWidget(bounds.m_110085_() - 2, bounds.m_110086_() - 2, 10000, 10000, (Component)Component.m_237119_(), this.getMinecraft().f_91062_);
        BelowOrAboveWidgetTooltipPositioner tooltipPositioner = new BelowOrAboveWidgetTooltipPositioner((AbstractWidget)dummySpacer);
        for (AbstractWidget widget : this.layout.widgets()) {
            if (!(widget instanceof ItemButton)) continue;
            ItemButton button = (ItemButton)widget;
            button.setTooltipPositioner((ClientTooltipPositioner)tooltipPositioner);
        }
    }

    public void m_86600_() {
        this.openProgress.tickChaser();
        if (!this.isClosing() && !ItemStack.m_150942_((ItemStack)this.sourceItem, (ItemStack)this.getSourceItem())) {
            this.m_7379_();
        }
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        Rect2i bounds;
        Rect2i tolerance;
        if (super.m_6375_(pMouseX, pMouseY, pButton)) {
            return true;
        }
        if (pButton == 0 && !(tolerance = new Rect2i((bounds = this.layout.bounds()).m_110085_() - 10, bounds.m_110086_() - 10, bounds.m_110090_() + 20, bounds.m_110091_() + 20)).m_110087_((int)pMouseX, (int)pMouseY)) {
            this.m_7379_();
            return true;
        }
        return false;
    }

    public void m_88315_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        Objects.requireNonNull(this.f_96541_);
        PoseStack pose = pGuiGraphics.m_280168_();
        this.layout.update();
        Vector2i pos = this.layout.getAnchoredPos();
        float openValue = this.openProgress.getValue(this.f_96541_.getPartialTick());
        pose.m_85836_();
        pose.m_252880_((float)pos.x, (float)pos.y, 0.0f);
        pose.m_85841_(openValue, openValue, openValue);
        pose.m_252880_((float)(-pos.x), (float)(-pos.y), 0.0f);
        if (this.inContainer) {
            Rect2i bounds = this.layout.bounds();
            pGuiGraphics.m_280027_(new ResourceLocation("textures/gui/demo_background.png"), bounds.m_110085_() - 2, bounds.m_110086_() - 2, bounds.m_110090_() + 4, bounds.m_110091_() + 4, 4, 4, 248, 166, 0, 0);
        }
        super.m_88315_(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        pose.m_85849_();
    }

    public void m_262861_(List<FormattedCharSequence> list, ClientTooltipPositioner tooltipPositioner, boolean force) {
        float openValue = this.openProgress.getValue(Objects.requireNonNull(this.f_96541_).getPartialTick());
        if (openValue > 0.95f) {
            super.m_262861_(list, tooltipPositioner, force);
        }
    }

    public void m_7379_() {
        this.openProgress.chase(0.0, 0.8, LerpedFloat.Chaser.EXP);
        lingeringScreen = this;
        super.m_7379_();
    }

    public boolean isClosing() {
        return this.openProgress.getChaseTarget() == 0.0f;
    }

    public boolean m_7043_() {
        return false;
    }

    public static void renderLingering(GuiGraphics pGuiGraphics) {
        if (lingeringScreen == null) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91080_ != null || mc.m_91265_() != null || ConvertScreen.lingeringScreen.openProgress.settled()) {
            lingeringScreen = null;
            return;
        }
        lingeringScreen.m_88315_(pGuiGraphics, Integer.MAX_VALUE, Integer.MAX_VALUE, mc.m_91297_());
    }

    public static void tickLingering() {
        if (lingeringScreen != null) {
            lingeringScreen.m_86600_();
        }
    }
}

