/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.util;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;
import snownee.kiwi.mixin.forge.BlockColorsAccess;
import snownee.kiwi.mixin.forge.ItemColorsAccess;
import snownee.kiwi.util.CachedSupplier;

public class ColorProviderUtil {
    public static BlockColor delegate(Block block) {
        return new BlockDelegate(() -> {
            BlockColorsAccess blockColors = (BlockColorsAccess)Minecraft.m_91087_().m_91298_();
            return blockColors.getBlockColors().get(ForgeRegistries.BLOCKS.getDelegateOrThrow((Object)block));
        });
    }

    public static ItemColor delegate(Item item) {
        return new ItemDelegate(() -> {
            ItemColorsAccess itemColors = (ItemColorsAccess)Minecraft.m_91087_().getItemColors();
            return itemColors.getItemColors().get(ForgeRegistries.ITEMS.getDelegateOrThrow((Object)item));
        });
    }

    public static ItemColor delegateItemFallback(Block block) {
        return new ItemDelegate(() -> {
            BlockColorsAccess blockColors = (BlockColorsAccess)Minecraft.m_91087_().m_91298_();
            BlockColor blockColor = blockColors.getBlockColors().get(ForgeRegistries.BLOCKS.getDelegateOrThrow((Object)block));
            if (blockColor == null) {
                return null;
            }
            return (stack, i) -> blockColor.m_92566_(block.m_49966_(), null, null, i);
        });
    }

    private static class BlockDelegate
    extends CachedSupplier<BlockColor>
    implements BlockColor {
        public BlockDelegate(Supplier<BlockColor> getter) {
            super(getter, Dummy.INSTANCE);
        }

        public int m_92566_(BlockState blockState, @Nullable BlockAndTintGetter blockAndTintGetter, @Nullable BlockPos blockPos, int i) {
            return ((BlockColor)this.get()).m_92566_(blockState, blockAndTintGetter, blockPos, i);
        }
    }

    private static class ItemDelegate
    extends CachedSupplier<ItemColor>
    implements ItemColor {
        public ItemDelegate(Supplier<ItemColor> getter) {
            super(getter, Dummy.INSTANCE);
        }

        public int m_92671_(ItemStack itemStack, int i) {
            return ((ItemColor)this.get()).m_92671_(itemStack, i);
        }
    }

    public static class Dummy
    implements ItemColor,
    BlockColor {
        public static final Dummy INSTANCE = new Dummy();

        public int m_92566_(BlockState blockState, @Nullable BlockAndTintGetter blockAndTintGetter, @Nullable BlockPos blockPos, int i) {
            return -1;
        }

        public int m_92671_(ItemStack itemStack, int i) {
            return -1;
        }
    }
}

