/*
 * Decompiled with CFR 0.152.
 */
package cn.mcmod_mmf.mmlib.client.model.bedrock;

import cn.mcmod_mmf.mmlib.client.model.bedrock.BedrockCube;
import cn.mcmod_mmf.mmlib.client.model.bedrock.BedrockPart;
import cn.mcmod_mmf.mmlib.client.model.bedrock.BedrockVersion;
import cn.mcmod_mmf.mmlib.client.model.pojo.BedrockModelPOJO;
import cn.mcmod_mmf.mmlib.client.model.pojo.BonesItem;
import cn.mcmod_mmf.mmlib.client.model.pojo.CubesItem;
import cn.mcmod_mmf.mmlib.client.model.pojo.Description;
import cn.mcmod_mmf.mmlib.client.model.pojo.FaceUVsItem;
import cn.mcmod_mmf.mmlib.utils.ClientUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.HashMap;
import java.util.List;
import net.minecraft.world.phys.AABB;

public interface BedrockModel {
    public BedrockModelPOJO getBedrockModelPOJO();

    public void setBedrockModelPOJO(BedrockModelPOJO var1);

    public HashMap<String, BedrockPart> getModelMap();

    public HashMap<String, BonesItem> getIndexBones();

    public List<BedrockPart> getShouldRender();

    public AABB getRenderBoundingBox();

    public void setRenderBoundingBox(AABB var1);

    public boolean isEmissive();

    public void setEmissive(boolean var1);

    default public boolean needRefresh(BedrockModelPOJO pojo) {
        return this.getBedrockModelPOJO() != pojo;
    }

    default public void renderBedrockModel(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        for (BedrockPart model : this.getShouldRender()) {
            model.render(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        }
    }

    default public void renderEmissiveParts(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        for (BedrockPart model : this.getShouldRender()) {
            model.renderEmissive(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        }
    }

    default public void loadModel(BedrockModelPOJO pojo) {
        this.getModelMap().clear();
        this.getIndexBones().clear();
        this.getShouldRender().clear();
        this.setEmissive(false);
        String formatVersion = pojo.getFormatVersion();
        if (formatVersion.equals(BedrockVersion.LEGACY.getVersion())) {
            this.loadLegacyModel(pojo);
        } else if (formatVersion.compareTo(BedrockVersion.NEW.getVersion()) >= 0) {
            this.loadNewModel(pojo);
        }
        this.setBedrockModelPOJO(pojo);
    }

    default public void loadNewModel(BedrockModelPOJO pojo) {
        if (!1.$assertionsDisabled && pojo.getGeometryModelNew() == null) {
            throw new AssertionError();
        }
        pojo.getGeometryModelNew().deco();
        Description description = pojo.getGeometryModelNew().getDescription();
        int texWidth = description.getTextureWidth();
        int texHeight = description.getTextureHeight();
        List<Float> offset = description.getVisibleBoundsOffset();
        float offsetX = offset.get(0).floatValue();
        float offsetY = offset.get(1).floatValue();
        float offsetZ = offset.get(2).floatValue();
        float width = description.getVisibleBoundsWidth() / 2.0f;
        float height = description.getVisibleBoundsHeight() / 2.0f;
        this.setRenderBoundingBox(new AABB((double)(offsetX - width), (double)(offsetY - height), (double)(offsetZ - width), (double)(offsetX + width), (double)(offsetY + height), (double)(offsetZ + width)));
        for (BonesItem bones : pojo.getGeometryModelNew().getBones()) {
            this.getIndexBones().put(bones.getName(), bones);
            this.getModelMap().put(bones.getName(), new BedrockPart());
        }
        for (BonesItem bones : pojo.getGeometryModelNew().getBones()) {
            String name = bones.getName();
            List<Float> rotation = bones.getRotation();
            String parent = bones.getParent();
            BedrockPart model = this.getModelMap().get(name);
            if (name.startsWith("emissive")) {
                model.setEmissive();
                this.setEmissive(true);
            }
            model.mirror = bones.isMirror();
            model.setPos(this.convertPivot(bones, 0), this.convertPivot(bones, 1), this.convertPivot(bones, 2));
            if (rotation != null) {
                this.setRotationAngle(model, ClientUtil.convertRotation(rotation.get(0).floatValue()), ClientUtil.convertRotation(rotation.get(1).floatValue()), ClientUtil.convertRotation(rotation.get(2).floatValue()));
            }
            if (parent != null) {
                BedrockPart parentPart = this.getModelMap().get(parent);
                parentPart.addChild(bones.getName(), model);
            } else {
                this.getShouldRender().add(model);
            }
            if (bones.getCubes() == null) continue;
            for (CubesItem cube : bones.getCubes()) {
                List<Float> uv = cube.getUv();
                FaceUVsItem faceUv = cube.getFaceUv();
                List<Float> size = cube.getSize();
                List<Float> cubeRotation = cube.getRotation();
                boolean mirror = cube.isMirror();
                float inflate = cube.getInflate();
                if (cubeRotation == null) {
                    if (faceUv == null) {
                        model.getCubes().add((Object)new BedrockCube(uv.get(0).floatValue(), uv.get(1).floatValue(), this.convertOrigin(bones, cube, 0), this.convertOrigin(bones, cube, 1), this.convertOrigin(bones, cube, 2), size.get(0).floatValue(), size.get(1).floatValue(), size.get(2).floatValue(), inflate, mirror, texWidth, texHeight));
                        continue;
                    }
                    model.getCubes().add((Object)new BedrockCube(this.convertOrigin(bones, cube, 0), this.convertOrigin(bones, cube, 1), this.convertOrigin(bones, cube, 2), size.get(0).floatValue(), size.get(1).floatValue(), size.get(2).floatValue(), inflate, (float)texWidth, (float)texHeight, faceUv));
                    continue;
                }
                BedrockPart cubeRenderer = new BedrockPart();
                cubeRenderer.setPos(this.convertPivot(bones, cube, 0), this.convertPivot(bones, cube, 1), this.convertPivot(bones, cube, 2));
                this.setRotationAngle(cubeRenderer, ClientUtil.convertRotation(cubeRotation.get(0).floatValue()), ClientUtil.convertRotation(cubeRotation.get(1).floatValue()), ClientUtil.convertRotation(cubeRotation.get(2).floatValue()));
                if (faceUv == null) {
                    cubeRenderer.getCubes().add((Object)new BedrockCube(uv.get(0).floatValue(), uv.get(1).floatValue(), this.convertOrigin(cube, 0), this.convertOrigin(cube, 1), this.convertOrigin(cube, 2), size.get(0).floatValue(), size.get(1).floatValue(), size.get(2).floatValue(), inflate, mirror, texWidth, texHeight));
                } else {
                    cubeRenderer.getCubes().add((Object)new BedrockCube(this.convertOrigin(cube, 0), this.convertOrigin(cube, 1), this.convertOrigin(cube, 2), size.get(0).floatValue(), size.get(1).floatValue(), size.get(2).floatValue(), inflate, (float)texWidth, (float)texHeight, faceUv));
                }
                model.addChild(bones.getName(), cubeRenderer);
            }
        }
    }

    default public void loadLegacyModel(BedrockModelPOJO pojo) {
        if (!1.$assertionsDisabled && pojo.getGeometryModelLegacy() == null) {
            throw new AssertionError();
        }
        pojo.getGeometryModelLegacy().deco();
        int texWidth = pojo.getGeometryModelLegacy().getTextureWidth();
        int texHeight = pojo.getGeometryModelLegacy().getTextureHeight();
        List<Float> offset = pojo.getGeometryModelLegacy().getVisibleBoundsOffset();
        float offsetX = offset.get(0).floatValue();
        float offsetY = offset.get(1).floatValue();
        float offsetZ = offset.get(2).floatValue();
        float width = pojo.getGeometryModelLegacy().getVisibleBoundsWidth() / 2.0f;
        float height = pojo.getGeometryModelLegacy().getVisibleBoundsHeight() / 2.0f;
        this.setRenderBoundingBox(new AABB((double)(offsetX - width), (double)(offsetY - height), (double)(offsetZ - width), (double)(offsetX + width), (double)(offsetY + height), (double)(offsetZ + width)));
        for (BonesItem bones : pojo.getGeometryModelLegacy().getBones()) {
            this.getIndexBones().put(bones.getName(), bones);
            this.getModelMap().put(bones.getName(), new BedrockPart());
        }
        for (BonesItem bones : pojo.getGeometryModelLegacy().getBones()) {
            String name = bones.getName();
            List<Float> rotation = bones.getRotation();
            String parent = bones.getParent();
            BedrockPart model = this.getModelMap().get(name);
            if (name.startsWith("emissive")) {
                model.setEmissive();
                this.setEmissive(true);
            }
            model.mirror = bones.isMirror();
            model.setPos(this.convertPivot(bones, 0), this.convertPivot(bones, 1), this.convertPivot(bones, 2));
            if (rotation != null) {
                this.setRotationAngle(model, ClientUtil.convertRotation(rotation.get(0).floatValue()), ClientUtil.convertRotation(rotation.get(1).floatValue()), ClientUtil.convertRotation(rotation.get(2).floatValue()));
            }
            if (parent != null) {
                this.getModelMap().get(parent).addChild(bones.getName(), model);
            } else {
                this.getShouldRender().add(model);
            }
            if (bones.getCubes() == null) continue;
            for (CubesItem cube : bones.getCubes()) {
                List<Float> uv = cube.getUv();
                List<Float> size = cube.getSize();
                boolean mirror = cube.isMirror();
                float inflate = cube.getInflate();
                model.getCubes().add((Object)new BedrockCube(uv.get(0).floatValue(), uv.get(1).floatValue(), this.convertOrigin(bones, cube, 0), this.convertOrigin(bones, cube, 1), this.convertOrigin(bones, cube, 2), size.get(0).floatValue(), size.get(1).floatValue(), size.get(2).floatValue(), inflate, mirror, texWidth, texHeight));
            }
        }
    }

    default public void setRotationAngle(BedrockPart modelRenderer, float x, float y, float z) {
        modelRenderer.xRot = x;
        modelRenderer.yRot = y;
        modelRenderer.zRot = z;
    }

    default public float convertPivot(BonesItem bones, int index) {
        if (bones.getParent() != null) {
            if (index == 1) {
                return this.getIndexBones().get(bones.getParent()).getPivot().get(index).floatValue() - bones.getPivot().get(index).floatValue();
            }
            return bones.getPivot().get(index).floatValue() - this.getIndexBones().get(bones.getParent()).getPivot().get(index).floatValue();
        }
        if (index == 1) {
            return 24.0f - bones.getPivot().get(index).floatValue();
        }
        return bones.getPivot().get(index).floatValue();
    }

    default public float convertPivot(BonesItem parent, CubesItem cube, int index) {
        if (!1.$assertionsDisabled && cube.getPivot() == null) {
            throw new AssertionError();
        }
        if (index == 1) {
            return parent.getPivot().get(index).floatValue() - cube.getPivot().get(index).floatValue();
        }
        return cube.getPivot().get(index).floatValue() - parent.getPivot().get(index).floatValue();
    }

    default public float convertOrigin(BonesItem bone, CubesItem cube, int index) {
        if (index == 1) {
            return bone.getPivot().get(index).floatValue() - cube.getOrigin().get(index).floatValue() - cube.getSize().get(index).floatValue();
        }
        return cube.getOrigin().get(index).floatValue() - bone.getPivot().get(index).floatValue();
    }

    default public float convertOrigin(CubesItem cube, int index) {
        if (!1.$assertionsDisabled && cube.getPivot() == null) {
            throw new AssertionError();
        }
        if (index == 1) {
            return cube.getPivot().get(index).floatValue() - cube.getOrigin().get(index).floatValue() - cube.getSize().get(index).floatValue();
        }
        return cube.getOrigin().get(index).floatValue() - cube.getPivot().get(index).floatValue();
    }

    default public BedrockPart getChild(String partName) {
        return this.getModelMap().getOrDefault(partName, new BedrockPart());
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

