/*
 * Decompiled with CFR 0.152.
 */
package net.kenddie.fantasyweapons.handlers;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import net.kenddie.fantasyweapons.FantasyWeapons;
import net.kenddie.fantasyweapons.item.FWItemManager;
import net.kenddie.fantasyweapons.model.EpicBakedModel;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class FWEventHandler {
    private static final Map<ModelResourceLocation, ModelResourceLocation> COMPLIANCES = new HashMap<ModelResourceLocation, ModelResourceLocation>();

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onRegisterAdditional(ModelEvent.RegisterAdditional event) {
        for (Item item : FWItemManager.FW_ITEM_MANAGER.getRegisteredItems()) {
            String itemName = item.m_5524_().substring("item.fantasy_weapons.".length());
            String largeJsonPath = String.format("/assets/fantasy_weapons/models/item/%s_large.json", itemName);
            try {
                InputStream inputStream = FantasyWeapons.class.getResourceAsStream(largeJsonPath);
                try {
                    if (inputStream == null) continue;
                    String smallResourceName = String.format("%s", itemName);
                    String largeResourceName = String.format("%s_large", itemName);
                    ResourceLocation smallResourceLocation = new ResourceLocation("fantasy_weapons", smallResourceName);
                    ResourceLocation largeResourceLocation = new ResourceLocation("fantasy_weapons", largeResourceName);
                    ModelResourceLocation smallModelResourceLocation = new ModelResourceLocation(smallResourceLocation, "inventory");
                    ModelResourceLocation largeModelResourceLocation = new ModelResourceLocation(largeResourceLocation, "inventory");
                    COMPLIANCES.put(smallModelResourceLocation, largeModelResourceLocation);
                    event.register((ResourceLocation)largeModelResourceLocation);
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onModifyBakingResult(ModelEvent.ModifyBakingResult event) {
        Map models = event.getModels();
        for (Map.Entry<ModelResourceLocation, ModelResourceLocation> compliance : COMPLIANCES.entrySet()) {
            ModelResourceLocation largeModelResourceLocation;
            BakedModel largeBakedModel;
            ModelResourceLocation smallModelResourceLocation = compliance.getKey();
            BakedModel smallBakedModel = (BakedModel)models.get(smallModelResourceLocation);
            if (smallBakedModel == null || (largeBakedModel = (BakedModel)models.get(largeModelResourceLocation = compliance.getValue())) == null) continue;
            EpicBakedModel epicBakedModel = new EpicBakedModel(smallBakedModel, largeBakedModel);
            models.put(smallModelResourceLocation, epicBakedModel);
        }
    }
}

