/*
 * Decompiled with CFR 0.152.
 */
package net.kenddie.fantasyweapons.item;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.kenddie.fantasyweapons.config.FWConfig;
import net.kenddie.fantasyweapons.item.FWDeclaredItem;
import net.kenddie.fantasyweapons.item.weapon.lib.FWWeaponBasicSwordItem;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class FWItemManager {
    public static final FWItemManager FW_ITEM_MANAGER = new FWItemManager();
    private final Set<ResourceLocation> declaredBasic = new HashSet<ResourceLocation>();
    private final Set<ResourceLocation> declaredSwords = new HashSet<ResourceLocation>();
    private final Map<ResourceLocation, Item> registered = new HashMap<ResourceLocation, Item>();

    private FWItemManager() {
    }

    public FWDeclaredItem declare(String path) {
        ResourceLocation id = new ResourceLocation("fantasy_weapons", path);
        this.declaredBasic.add(id);
        return new FWDeclaredItem(id);
    }

    public FWDeclaredItem declareSword(String path) {
        ResourceLocation id = new ResourceLocation("fantasy_weapons", path);
        this.declaredSwords.add(id);
        return new FWDeclaredItem(id);
    }

    public Item getRegistered(ResourceLocation id) {
        return this.registered.get(id);
    }

    public List<Item> getRegisteredItems() {
        return new ArrayList<Item>(this.registered.values());
    }

    public Set<ResourceLocation> getDeclaredSwords() {
        return this.declaredSwords;
    }

    public void register(IEventBus bus) {
        DeferredRegister forgeRegistry = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"fantasy_weapons");
        this.registerBasic((DeferredRegister<Item>)forgeRegistry);
        this.registerSwords((DeferredRegister<Item>)forgeRegistry);
        forgeRegistry.register(bus);
    }

    private void registerBasic(DeferredRegister<Item> forgeRegistry) {
        for (ResourceLocation id : this.declaredBasic) {
            forgeRegistry.register(id.m_135815_(), () -> {
                Item item = new Item(new Item.Properties());
                this.registered.put(id, item);
                return item;
            });
        }
    }

    private void registerSwords(DeferredRegister<Item> forgeRegistry) {
        for (ResourceLocation id : this.declaredSwords) {
            forgeRegistry.register(id.m_135815_(), () -> {
                FWConfig.SwordConfig config = FWConfig.FW_CONFIG.getSwordConfigOrDefault(id.m_135815_());
                FWWeaponBasicSwordItem item = new FWWeaponBasicSwordItem((Tier)Tiers.NETHERITE, config.damage, config.speed, new Item.Properties());
                this.registered.put(id, (Item)item);
                return item;
            });
        }
    }
}

