/*
 * Decompiled with CFR 0.152.
 */
package net.kenddie.snakeyaml.engine.v2.constructor.json;

import java.util.Optional;
import net.kenddie.snakeyaml.engine.v2.constructor.ConstructScalar;
import net.kenddie.snakeyaml.engine.v2.exceptions.ConstructorException;
import net.kenddie.snakeyaml.engine.v2.nodes.Node;
import net.kenddie.snakeyaml.engine.v2.nodes.NodeType;
import net.kenddie.snakeyaml.engine.v2.nodes.Tag;
import net.kenddie.snakeyaml.engine.v2.resolver.ScalarResolver;

public class ConstructOptionalClass
extends ConstructScalar {
    private final ScalarResolver scalarResolver;

    public ConstructOptionalClass(ScalarResolver scalarResolver) {
        this.scalarResolver = scalarResolver;
    }

    @Override
    public Object construct(Node node) {
        if (node.getNodeType() != NodeType.SCALAR) {
            throw new ConstructorException("while constructing Optional", Optional.empty(), "found non scalar node", node.getStartMark());
        }
        String value = this.constructScalar(node);
        Tag implicitTag = this.scalarResolver.resolve(value, true);
        if (implicitTag.equals(Tag.NULL)) {
            return Optional.empty();
        }
        return Optional.of(value);
    }
}

