/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.arsdelight.events;

import com.hollingsworth.arsnouveau.api.event.ManaRegenCalcEvent;
import com.hollingsworth.arsnouveau.api.event.MaxManaCalcEvent;
import com.hollingsworth.arsnouveau.api.event.SpellDamageEvent;
import com.hollingsworth.arsnouveau.api.mana.IManaCap;
import com.hollingsworth.arsnouveau.setup.registry.CapabilityRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ModPotions;
import dev.xkmc.arsdelight.init.data.ADModConfig;
import dev.xkmc.arsdelight.init.registrate.ADEffects;
import java.util.Optional;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="arsdelight", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ArsDelightServerEvents {
    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onPlayerHeal(LivingHealEvent event) {
        MobEffectInstance shielding;
        LivingEntity e = event.getEntity();
        MobEffectInstance flourish = e.m_21124_((MobEffect)ADEffects.FLOURISH.get());
        if (flourish != null) {
            Optional cap = CapabilityRegistry.getMana((LivingEntity)e).resolve();
            int factor = 1 << flourish.m_19564_();
            if (cap.isPresent()) {
                double max = ((IManaCap)cap.get()).getMaxMana();
                double maxhp = e.m_21233_();
                double gain = (double)event.getAmount() / maxhp * max * (double)factor;
                ((IManaCap)cap.get()).addMana(gain);
            }
        }
        if ((shielding = e.m_21124_((MobEffect)ADEffects.SHIELDING.get())) != null) {
            double factor = 1 << shielding.m_19564_();
            double max = (Double)ADModConfig.COMMON.maxShieldingAbsorption.get() * factor;
            double old = e.m_6103_();
            double newAb = Math.min(max, old + (double)event.getAmount() * factor);
            e.m_7911_((float)newAb);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onDamage(LivingDamageEvent event) {
        MobEffectInstance ins;
        if (event.getSource().m_269533_(DamageTypeTags.f_268415_) && (ins = event.getEntity().m_21124_((MobEffect)ADEffects.BLAST_RES.get())) != null) {
            float res = Math.max(0.0f, 1.0f - (float)(ins.m_19564_() + 1) * 0.2f);
            event.setAmount(event.getAmount() * res);
        }
    }

    @SubscribeEvent
    public static void spellDamagePre(SpellDamageEvent.Pre event) {
        MobEffectInstance ins = event.caster.m_21124_((MobEffect)ADEffects.WILDEN.get());
        if (ins != null) {
            double factor = (Double)ADModConfig.COMMON.wildenSpellDamageBonus.get();
            event.damage *= 1.0f + (float)(ins.m_19564_() + 1) * (float)factor;
        }
    }

    @SubscribeEvent
    public static void spellDamage(SpellDamageEvent.Post event) {
        Entity entity;
        MobEffectInstance ins = event.caster.m_21124_((MobEffect)ADEffects.FREEZE.get());
        if (ins != null && (entity = event.target) instanceof LivingEntity) {
            LivingEntity le = (LivingEntity)entity;
            le.m_7292_(new MobEffectInstance((MobEffect)ModPotions.FREEZING_EFFECT.get(), ins.m_19557_(), ins.m_19564_()));
        }
    }

    @SubscribeEvent
    public static void maxManaCalc(MaxManaCalcEvent event) {
        MobEffectInstance ins = event.getEntity().m_21124_((MobEffect)ADEffects.WILDEN.get());
        if (ins != null) {
            double config = (Double)ADModConfig.COMMON.wildenMaxManaBonus.get();
            double factor = 1.0 + (double)(ins.m_19564_() + 1) * config;
            event.setMax((int)((double)event.getMax() * factor));
        }
    }

    @SubscribeEvent
    public static void ManaRegenCalc(ManaRegenCalcEvent event) {
        MobEffectInstance ins = event.getEntity().m_21124_((MobEffect)ADEffects.WILDEN.get());
        if (ins != null) {
            double config = (Double)ADModConfig.COMMON.wildenManaRegenBonus.get();
            double factor = 1.0 + (double)(ins.m_19564_() + 1) * config;
            event.setRegen(event.getRegen() * factor);
        }
    }
}

