/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.arsdelight.init.food;

import com.hollingsworth.arsnouveau.setup.registry.ModPotions;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.util.entry.ItemEntry;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import dev.xkmc.arsdelight.compat.diet.DietTagGen;
import dev.xkmc.arsdelight.content.item.ADFoodBlockItem;
import dev.xkmc.arsdelight.content.item.ADFoodItem;
import dev.xkmc.arsdelight.init.ArsDelight;
import dev.xkmc.arsdelight.init.data.TagGen;
import dev.xkmc.arsdelight.init.food.BlockFoodType;
import dev.xkmc.arsdelight.init.food.EffectEntry;
import dev.xkmc.arsdelight.init.food.FoodType;
import dev.xkmc.arsdelight.init.registrate.ADEffects;
import dev.xkmc.arsdelight.init.registrate.ADItems;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import vectorwing.farmersdelight.common.registry.ModEffects;

public enum ADFood implements ItemLike
{
    WILDEN_MEAT(FoodType.MEAT, 6, 0.4f, List.of(new EffectEntry(() -> ADEffects.WILDEN.get(), 600, 0, 0.25f)), TagGen.RAW_WILDEN_MEAT, DietTagGen.PROTEINS.tag),
    GRILLED_WILDEN_MEAT(FoodType.MEAT, 10, 0.7f, List.of(new EffectEntry(() -> ADEffects.WILDEN.get(), 600, 0, 0.5f)), TagGen.COOKED_WILDEN_MEAT, DietTagGen.PROTEINS.tag),
    WILDEN_MEAT_SLICE(FoodType.FAST_MEAT, 3, 0.4f, List.of(new EffectEntry(() -> ADEffects.WILDEN.get(), 300, 0, 0.25f)), TagGen.RAW_WILDEN_MEAT, DietTagGen.PROTEINS.tag),
    GRILLED_WILDEN_MEAT_SLICE(FoodType.FAST_MEAT, 5, 0.7f, List.of(new EffectEntry(() -> ADEffects.WILDEN.get(), 300, 0, 0.5f)), TagGen.COOKED_WILDEN_MEAT, DietTagGen.PROTEINS.tag),
    CHIMERA_MEAT(FoodType.MEAT, 12, 0.4f, List.of(new EffectEntry(() -> ADEffects.WILDEN.get(), 600, 1, 0.5f)), TagGen.RAW_CHIMERA, DietTagGen.PROTEINS.tag),
    GRILLED_CHIMERA_MEAT(FoodType.MEAT, 18, 0.7f, List.of(new EffectEntry(() -> ADEffects.WILDEN.get(), 600, 1)), TagGen.COOKED_CHIMERA, DietTagGen.PROTEINS.tag),
    CHIMERA_MEAT_SLICE(FoodType.FAST_MEAT, 6, 0.4f, List.of(new EffectEntry(() -> ADEffects.WILDEN.get(), 300, 1, 0.5f)), TagGen.RAW_CHIMERA, DietTagGen.PROTEINS.tag),
    GRILLED_CHIMERA_MEAT_SLICE(FoodType.FAST_MEAT, 9, 0.7f, List.of(new EffectEntry(() -> ADEffects.WILDEN.get(), 300, 1)), TagGen.COOKED_CHIMERA, DietTagGen.PROTEINS.tag),
    WILDEN_SKEWER(FoodType.MEAT_STICK, 4, 0.4f, List.of(new EffectEntry(() -> ADEffects.WILDEN.get(), 300, 0, 0.5f)), DietTagGen.PROTEINS.tag, DietTagGen.VEGETABLES.tag),
    GRILLED_WILDEN_SKEWER(FoodType.MEAT_STICK, 8, 0.7f, List.of(new EffectEntry(() -> ADEffects.WILDEN.get(), 1200, 1, 1.0f), new EffectEntry((Supplier<MobEffect>)ModEffects.NOURISHMENT, 1200)), DietTagGen.PROTEINS.tag, DietTagGen.VEGETABLES.tag),
    CHIMERA_SKEWER(FoodType.MEAT_STICK, 7, 0.4f, List.of(new EffectEntry(() -> ADEffects.WILDEN.get(), 600, 1, 0.5f)), DietTagGen.PROTEINS.tag, DietTagGen.VEGETABLES.tag),
    GRILLED_CHIMERA_SKEWER(FoodType.MEAT_STICK, 12, 0.7f, List.of(new EffectEntry(() -> ADEffects.WILDEN.get(), 1200, 2), new EffectEntry((Supplier<MobEffect>)ModEffects.NOURISHMENT, 1200)), DietTagGen.PROTEINS.tag, DietTagGen.VEGETABLES.tag),
    SOURCE_BERRY_COOKIE(FoodType.FAST, 2, 0.8f, List.of(new EffectEntry((Supplier<MobEffect>)ModPotions.MANA_REGEN_EFFECT, 200, 0)), DietTagGen.SUGARS.tag),
    SOURCE_BERRY_PIE_SLICE(FoodType.FAST, 3, 0.8f, List.of(new EffectEntry((Supplier<MobEffect>)ModPotions.MANA_REGEN_EFFECT, 300, 1)), DietTagGen.SUGARS.tag),
    SOURCE_BERRY_CUPCAKE(FoodType.FAST, 6, 0.8f, List.of(new EffectEntry((Supplier<MobEffect>)ModPotions.MANA_REGEN_EFFECT, 1200, 2)), DietTagGen.SUGARS.tag),
    ARCH_SAUCE(FoodType.BOWL, 4, 0.4f, List.of(new EffectEntry((Supplier<MobEffect>)ModPotions.MANA_REGEN_EFFECT, 1200, 1)), DietTagGen.FRUITS.tag),
    WILDEN_SAUCE(FoodType.MEAT_PLATE, 6, 0.8f, List.of(new EffectEntry(() -> ADEffects.WILDEN.get(), 600)), DietTagGen.PROTEINS.tag),
    ARCH_SOUP(FoodType.BOWL, 4, 0.4f, List.of(new EffectEntry((Supplier<MobEffect>)ModPotions.MANA_REGEN_EFFECT, 1200), new EffectEntry((Supplier<MobEffect>)ModEffects.COMFORT, 1200)), DietTagGen.VEGETABLES.tag),
    WILDEN_STEW(FoodType.MEAT_PLATE, 12, 0.8f, List.of(new EffectEntry(() -> ADEffects.WILDEN.get(), 3600, 0), new EffectEntry((Supplier<MobEffect>)ModEffects.COMFORT, 3600), new EffectEntry((Supplier<MobEffect>)ModEffects.NOURISHMENT, 3600)), DietTagGen.PROTEINS.tag),
    BOWL_OF_WILDEN_SALAD(FoodType.MEAT_PLATE, 12, 0.8f, List.of(new EffectEntry(() -> ADEffects.WILDEN.get(), 2400, 1), new EffectEntry((Supplier<MobEffect>)ModEffects.NOURISHMENT, 2400)), DietTagGen.PROTEINS.tag),
    HORN_ROLL(FoodType.HORNED_MEAT, 12, 0.8f, List.of(new EffectEntry(() -> ADEffects.WILDEN.get(), 2400, 2), new EffectEntry((Supplier<MobEffect>)ModEffects.NOURISHMENT, 2400)), DietTagGen.PROTEINS.tag),
    BOWL_OF_HONEY_GLAZED_CHIMERA(FoodType.MEAT_PLATE, 18, 0.8f, List.of(new EffectEntry(() -> ADEffects.WILDEN.get(), 3600, 2), new EffectEntry((Supplier<MobEffect>)ModEffects.NOURISHMENT, 3600), new EffectEntry((Supplier<MobEffect>)ModEffects.COMFORT, 3600)), new TagKey[0]),
    MENDOSTEEN_TEA(FoodType.DRINK, 0, 0.0f, List.of(new EffectEntry((Supplier<MobEffect>)ModPotions.RECOVERY_EFFECT, 1800), new EffectEntry(() -> ADEffects.FLOURISH.get(), 1200)), DietTagGen.FRUITS.tag),
    BASTION_TEA(FoodType.DRINK, 0, 0.0f, List.of(new EffectEntry((Supplier<MobEffect>)ModPotions.DEFENCE_EFFECT, 1800), new EffectEntry(() -> ADEffects.SHIELDING.get(), 1200)), DietTagGen.FRUITS.tag),
    BOMBEGRANTE_TEA(FoodType.DRINK, 0, 0.0f, List.of(new EffectEntry(() -> ADEffects.BLAST_RES.get(), 2400, 1)), DietTagGen.FRUITS.tag),
    FROSTAYA_TEA(FoodType.DRINK, 0, 0.0f, List.of(new EffectEntry(() -> ADEffects.FREEZE.get(), 4800)), DietTagGen.FRUITS.tag),
    SOURCE_BERRY_TEA(FoodType.DRINK, 0, 0.0f, List.of(new EffectEntry((Supplier<MobEffect>)ModPotions.MANA_REGEN_EFFECT, 2400, 1)), DietTagGen.FRUITS.tag),
    UNSTABLE_COCKTAIL(FoodType.DRINK, 0, 0.0f, List.of(new EffectEntry((Supplier<MobEffect>)ModPotions.BLAST_EFFECT, 200, 4)), DietTagGen.FRUITS.tag),
    MENDOSTEEN_HORNBEER(FoodType.HORNED_DRINK, 0, 0.0f, List.of(new EffectEntry((Supplier<MobEffect>)ModPotions.RECOVERY_EFFECT, 1200, 1), new EffectEntry(() -> ADEffects.FLOURISH.get(), 1200, 1)), DietTagGen.FRUITS.tag),
    BASTION_HORNBEER(FoodType.HORNED_DRINK, 0, 0.0f, List.of(new EffectEntry((Supplier<MobEffect>)ModPotions.DEFENCE_EFFECT, 1200, 1), new EffectEntry(() -> ADEffects.SHIELDING.get(), 1200, 1)), DietTagGen.FRUITS.tag),
    BOMBEGRANTE_HORNBEER(FoodType.HORNED_DRINK, 0, 0.0f, List.of(new EffectEntry(() -> ADEffects.BLAST_RES.get(), 1200, 3)), DietTagGen.FRUITS.tag),
    FROSTAYA_HORNBEER(FoodType.HORNED_DRINK, 0, 0.0f, List.of(new EffectEntry(() -> ADEffects.FREEZE.get(), 2400, 1)), DietTagGen.FRUITS.tag),
    SOURCE_BERRY_HORNBEER(FoodType.HORNED_DRINK, 0, 0.0f, List.of(new EffectEntry((Supplier<MobEffect>)ModPotions.MANA_REGEN_EFFECT, 1200, 3)), DietTagGen.FRUITS.tag),
    ACTIVATED_MENDOSTEEN_JAM(FoodType.JELLY, 0, 0.0f, List.of(new EffectEntry((Supplier<MobEffect>)ModPotions.RECOVERY_EFFECT, 1200), new EffectEntry(() -> ADEffects.FLOURISH.get(), 600)), DietTagGen.FRUITS.tag, DietTagGen.SUGARS.tag),
    ACTIVATED_BASTION_JAM(FoodType.JELLY, 0, 0.0f, List.of(new EffectEntry((Supplier<MobEffect>)ModPotions.DEFENCE_EFFECT, 1200), new EffectEntry(() -> ADEffects.SHIELDING.get(), 600)), DietTagGen.FRUITS.tag, DietTagGen.SUGARS.tag),
    NEUTRALIZED_BOMBEGRANTE_JAM(FoodType.JELLY, 0, 0.0f, List.of(new EffectEntry(() -> ADEffects.BLAST_RES.get(), 1200, 1)), DietTagGen.FRUITS.tag, DietTagGen.SUGARS.tag),
    NEUTRALIZED_FROSTAYA_JAM(FoodType.JELLY, 0, 0.0f, List.of(new EffectEntry(() -> ADEffects.FREEZE.get(), 2400)), DietTagGen.FRUITS.tag, DietTagGen.SUGARS.tag),
    SOURCE_BERRY_JAM(FoodType.JELLY, 0, 0.0f, List.of(new EffectEntry((Supplier<MobEffect>)ModPotions.MANA_REGEN_EFFECT, 100, 4)), DietTagGen.FRUITS.tag, DietTagGen.SUGARS.tag),
    MENDOSTEEN_CHICKEN(FoodType.MEAT_PLATE, 10, 0.8f, List.of(new EffectEntry((Supplier<MobEffect>)ModPotions.RECOVERY_EFFECT, 2400), new EffectEntry(() -> ADEffects.FLOURISH.get(), 2400), new EffectEntry((Supplier<MobEffect>)ModEffects.COMFORT, 3600)), DietTagGen.FRUITS.tag, DietTagGen.PROTEINS.tag),
    BASTION_PORK(FoodType.MEAT_PLATE, 14, 0.8f, List.of(new EffectEntry((Supplier<MobEffect>)ModPotions.DEFENCE_EFFECT, 2400), new EffectEntry(() -> ADEffects.SHIELDING.get(), 2400), new EffectEntry((Supplier<MobEffect>)ModEffects.COMFORT, 3600)), DietTagGen.FRUITS.tag, DietTagGen.PROTEINS.tag),
    BOMBEGRANTE_STEAK(FoodType.MEAT_PLATE, 16, 0.8f, List.of(new EffectEntry(() -> ADEffects.BLAST_RES.get(), 3600, 1), new EffectEntry((Supplier<MobEffect>)ModEffects.NOURISHMENT, 3600)), DietTagGen.FRUITS.tag, DietTagGen.PROTEINS.tag),
    FROSTAYA_MUTTON(FoodType.MEAT_PLATE, 16, 0.8f, List.of(new EffectEntry(() -> ADEffects.FREEZE.get(), 3600), new EffectEntry((Supplier<MobEffect>)ModEffects.NOURISHMENT, 3600)), DietTagGen.FRUITS.tag, DietTagGen.PROTEINS.tag);

    private final String name = this.name().toLowerCase(Locale.ROOT);
    public final FoodType type;
    public final ItemEntry<ADFoodItem> item;
    private final List<EffectEntry> effs;
    private final TagKey<Item>[] tags;

    @SafeVarargs
    private ADFood(FoodType type, int nut, float sat, List<EffectEntry> effs, TagKey<Item> ... tags) {
        this.type = type;
        String tex = (switch (type) {
            case FoodType.MEAT, FoodType.FAST_MEAT, FoodType.MEAT_STICK -> "item/meat/";
            case FoodType.JELLY, FoodType.DRINK, FoodType.HORNED_DRINK -> "item/drink/";
            default -> "item/food/";
        }) + this.name;
        this.item = ArsDelight.REGISTRATE.item(this.name, p -> this.build((Item.Properties)p, nut, sat, effs)).model((ctx, pvd) -> pvd.generated((NonNullSupplier)ctx, new ResourceLocation[]{pvd.modLoc(tex)})).lang(ADItems.toEnglishName(this.name)).tag(tags).register();
        this.effs = effs;
        this.tags = tags;
    }

    private ADFoodItem build(Item.Properties prop, int nut, float sat, List<EffectEntry> effs) {
        FoodProperties.Builder builder = new FoodProperties.Builder();
        builder.m_38760_(nut).m_38758_(sat);
        for (EffectEntry e : effs) {
            builder.effect(e::getEffect, e.chance());
        }
        return this.type.build(prop, builder);
    }

    public <T extends Block, P> ItemBuilder<ADFoodBlockItem, BlockBuilder<T, P>> copyToBlockItem(BlockBuilder<T, P> block, BlockFoodType type, int nut, float sat) {
        FoodProperties.Builder builder = new FoodProperties.Builder();
        builder.m_38760_(nut).m_38758_(sat);
        for (EffectEntry e : this.effs) {
            builder.effect(e::getEffect, e.chance());
        }
        return block.item((t, p) -> type.build((Block)t, (Item.Properties)p, builder)).tag(this.tags);
    }

    public ItemStack asStack() {
        return this.item.asStack();
    }

    public ADFoodItem get() {
        return (ADFoodItem)((Object)this.item.get());
    }

    public Item m_5456_() {
        return (Item)this.item.get();
    }

    public ResourceLocation id() {
        return this.item.getId();
    }

    public static void register() {
    }
}

