/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera.corelib.inventory;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class ScreenBase<T extends AbstractContainerMenu>
extends AbstractContainerScreen<T> {
    public static final int FONT_COLOR = 0x404040;
    protected ResourceLocation texture;
    protected List<HoverArea> hoverAreas;

    public ScreenBase(ResourceLocation texture, T container, Inventory playerInventory, Component title) {
        super(container, playerInventory, title);
        this.texture = texture;
        this.hoverAreas = new ArrayList<HoverArea>();
    }

    public void m_88315_(GuiGraphics guiGraphics, int x, int y, float partialTicks) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, x, y, partialTicks);
        this.m_280072_(guiGraphics, x, y);
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.m_280218_(this.texture, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
    }

    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
    }

    public void drawHoverAreas(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        for (HoverArea hoverArea : this.hoverAreas) {
            if (hoverArea.tooltip == null || !hoverArea.isHovered(this.f_97735_, this.f_97736_, mouseX, mouseY)) continue;
            guiGraphics.m_280245_(this.f_96547_, hoverArea.tooltip.get(), mouseX - this.f_97735_, mouseY - this.f_97736_);
        }
    }

    public int getBlitSize(int amount, int max, int size) {
        return size - (int)((float)amount / (float)max * (float)size);
    }

    public void drawCentered(GuiGraphics guiGraphics, Component text, int y, int color) {
        this.drawCentered(guiGraphics, text, this.f_97726_ / 2, y, color);
    }

    public void drawCentered(GuiGraphics guiGraphics, Component text, int x, int y, int color) {
        ScreenBase.drawCentered(this.f_96547_, guiGraphics, text, x, y, color);
    }

    public static void drawCentered(Font font, GuiGraphics guiGraphics, Component text, int x, int y, int color) {
        int width = font.m_92852_((FormattedText)text);
        guiGraphics.m_280614_(font, text, x - width / 2, y, color, false);
    }

    public static class HoverArea {
        private final int posX;
        private final int posY;
        private final int width;
        private final int height;
        @Nullable
        private final Supplier<List<FormattedCharSequence>> tooltip;

        public HoverArea(int posX, int posY, int width, int height) {
            this(posX, posY, width, height, null);
        }

        public HoverArea(int posX, int posY, int width, int height, Supplier<List<FormattedCharSequence>> tooltip) {
            this.posX = posX;
            this.posY = posY;
            this.width = width;
            this.height = height;
            this.tooltip = tooltip;
        }

        public int getPosX() {
            return this.posX;
        }

        public int getPosY() {
            return this.posY;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        @Nullable
        public Supplier<List<FormattedCharSequence>> getTooltip() {
            return this.tooltip;
        }

        public boolean isHovered(int guiLeft, int guiTop, int mouseX, int mouseY) {
            return mouseX >= guiLeft + this.posX && mouseX < guiLeft + this.posX + this.width && mouseY >= guiTop + this.posY && mouseY < guiTop + this.posY + this.height;
        }
    }
}

