/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.claims.player;

import java.util.Map;
import java.util.UUID;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import xaero.pac.common.claims.player.IPlayerDimensionClaims;
import xaero.pac.common.claims.player.PlayerChunkClaim;
import xaero.pac.common.claims.player.PlayerClaimPosList;

public class PlayerDimensionClaims
implements IPlayerDimensionClaims<PlayerClaimPosList> {
    private final UUID playerId;
    private final ResourceLocation dimension;
    private final Map<PlayerChunkClaim, PlayerClaimPosList> claimLists;
    private int count;
    private int forceloadableCount;

    public PlayerDimensionClaims(UUID playerId, ResourceLocation dimension, Map<PlayerChunkClaim, PlayerClaimPosList> claimLists) {
        this.playerId = playerId;
        this.dimension = dimension;
        this.claimLists = claimLists;
        this.count = this.calculateCount();
        this.forceloadableCount = this.calculateForceloadableCount();
    }

    private PlayerClaimPosList getOrCreateList(PlayerChunkClaim claim) {
        PlayerClaimPosList result = this.claimLists.get(claim);
        if (result == null) {
            result = PlayerClaimPosList.Builder.begin().setClaim(claim).build();
            this.claimLists.put(claim, result);
        }
        return result;
    }

    private void removeList(PlayerClaimPosList list) {
        this.claimLists.remove(list.getClaimState());
    }

    public int getCount(PlayerChunkClaim claim) {
        PlayerClaimPosList list = this.claimLists.get(claim);
        if (list == null) {
            return 0;
        }
        return list.getCount();
    }

    public int getCount() {
        return this.count;
    }

    public int getForceloadableCount() {
        return this.forceloadableCount;
    }

    private int calculateCount() {
        int total = 0;
        for (Map.Entry<PlayerChunkClaim, PlayerClaimPosList> listEntry : this.claimLists.entrySet()) {
            PlayerClaimPosList list = listEntry.getValue();
            total += list.getCount();
        }
        return total;
    }

    private int calculateForceloadableCount() {
        int total = 0;
        for (Map.Entry<PlayerChunkClaim, PlayerClaimPosList> listEntry : this.claimLists.entrySet()) {
            PlayerClaimPosList list = listEntry.getValue();
            if (!listEntry.getKey().isForceloadable()) continue;
            total += list.getCount();
        }
        return total;
    }

    public boolean removeClaim(int x, int z, PlayerChunkClaim claim) {
        PlayerClaimPosList list = this.getOrCreateList(claim);
        boolean result = list.remove(x, z);
        --this.count;
        if (claim.isForceloadable()) {
            --this.forceloadableCount;
        }
        if (list.getCount() <= 0) {
            this.removeList(list);
        }
        return result;
    }

    public void addClaim(int x, int z, PlayerChunkClaim claim) {
        PlayerClaimPosList dest = this.getOrCreateList(claim);
        dest.add(x, z);
        ++this.count;
        if (claim.isForceloadable()) {
            ++this.forceloadableCount;
        }
    }

    public ResourceLocation getDimension() {
        return this.dimension;
    }

    @Override
    @Nonnull
    public Stream<PlayerClaimPosList> getTypedStream() {
        return this.claimLists.values().stream();
    }
}

