/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.packet.claims;

import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import xaero.pac.common.claims.ClaimsManager;
import xaero.pac.common.claims.player.request.ClaimActionRequest;
import xaero.pac.common.server.player.data.ServerPlayerData;
import xaero.pac.common.server.player.data.api.ServerPlayerDataAPI;

public class ServerboundClaimActionRequestPacket {
    private final ClaimActionRequest request;

    public ServerboundClaimActionRequestPacket(ClaimActionRequest request) {
        this.request = request;
    }

    public static class ServerHandler
    implements BiConsumer<ServerboundClaimActionRequestPacket, ServerPlayer> {
        @Override
        public void accept(ServerboundClaimActionRequestPacket t, ServerPlayer serverPlayer) {
            ServerPlayerData playerData = (ServerPlayerData)ServerPlayerDataAPI.from(serverPlayer);
            playerData.getClaimActionRequestHandler().onReceive(serverPlayer, t.request);
        }
    }

    public static class Codec
    implements BiConsumer<ServerboundClaimActionRequestPacket, FriendlyByteBuf>,
    Function<FriendlyByteBuf, ServerboundClaimActionRequestPacket> {
        @Override
        public ServerboundClaimActionRequestPacket apply(FriendlyByteBuf input) {
            try {
                ClaimsManager.Action action;
                if (input.readableBytes() > 1024) {
                    return null;
                }
                CompoundTag tag = input.m_130261_();
                if (tag == null) {
                    return null;
                }
                byte actionByte = tag.m_128445_("a");
                try {
                    action = ClaimsManager.Action.values()[actionByte];
                }
                catch (ArrayIndexOutOfBoundsException aioobe) {
                    return null;
                }
                int left = tag.m_128451_("l");
                int top = tag.m_128451_("t");
                int right = tag.m_128451_("r");
                int bottom = tag.m_128451_("b");
                if (left > right || top > bottom) {
                    return null;
                }
                boolean byServer = tag.m_128471_("s");
                return new ServerboundClaimActionRequestPacket(new ClaimActionRequest(action, left, top, right, bottom, byServer));
            }
            catch (Throwable t) {
                return null;
            }
        }

        @Override
        public void accept(ServerboundClaimActionRequestPacket t, FriendlyByteBuf u) {
            CompoundTag tag = new CompoundTag();
            tag.m_128344_("a", (byte)t.request.getAction().ordinal());
            tag.m_128405_("l", t.request.getLeft());
            tag.m_128405_("t", t.request.getTop());
            tag.m_128405_("r", t.request.getRight());
            tag.m_128405_("b", t.request.getBottom());
            tag.m_128379_("s", t.request.isByServer());
            u.m_130079_(tag);
        }
    }
}

