/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.packet.parties;

import java.util.UUID;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import xaero.pac.OpenPartiesAndClaims;
import xaero.pac.client.parties.party.ClientParty;
import xaero.pac.common.packet.parties.PartyPlayerInfoCodec;
import xaero.pac.common.parties.party.member.IPartyMember;
import xaero.pac.common.parties.party.member.PartyMember;
import xaero.pac.common.server.lazypacket.LazyPacket;

public class ClientboundPartyPacket
extends LazyPacket<ClientboundPartyPacket> {
    public static final Codec CODEC = new Codec(new PartyPlayerInfoCodec());
    private final UUID partyId;
    private final IPartyMember owner;
    private final int memberCount;
    private final int inviteCount;
    private final int allyCount;
    private final int memberLimit;
    private final int inviteLimit;
    private final int allyLimit;

    public ClientboundPartyPacket(UUID partyId, IPartyMember owner, int memberCount, int inviteCount, int allyCount, int memberLimit, int inviteLimit, int allyLimit) {
        this.partyId = partyId;
        this.owner = owner;
        this.memberCount = memberCount;
        this.inviteCount = inviteCount;
        this.allyCount = allyCount;
        this.memberLimit = memberLimit;
        this.inviteLimit = inviteLimit;
        this.allyLimit = allyLimit;
    }

    @Override
    protected Function<FriendlyByteBuf, ClientboundPartyPacket> getDecoder() {
        return CODEC;
    }

    @Override
    protected void writeOnPrepare(FriendlyByteBuf u) {
        CompoundTag partyTag = new CompoundTag();
        if (this.partyId == null) {
            u.m_130079_(partyTag);
            return;
        }
        partyTag.m_128362_("i", this.partyId);
        CompoundTag ownerTag = ClientboundPartyPacket.CODEC.playerInfoCodec.toMemberTag((PartyMember)this.owner);
        partyTag.m_128365_("o", (Tag)ownerTag);
        partyTag.m_128405_("mc", this.memberCount);
        partyTag.m_128405_("ic", this.inviteCount);
        partyTag.m_128405_("ac", this.allyCount);
        partyTag.m_128405_("ml", this.memberLimit);
        partyTag.m_128405_("il", this.inviteLimit);
        partyTag.m_128405_("al", this.allyLimit);
        u.m_130079_(partyTag);
    }

    protected static class Codec
    extends LazyPacket.Encoder<ClientboundPartyPacket>
    implements Function<FriendlyByteBuf, ClientboundPartyPacket> {
        private final PartyPlayerInfoCodec playerInfoCodec;

        public Codec(PartyPlayerInfoCodec playerInfoCodec) {
            this.playerInfoCodec = playerInfoCodec;
        }

        @Override
        public ClientboundPartyPacket apply(FriendlyByteBuf input) {
            try {
                if (input.readableBytes() > 102400) {
                    return null;
                }
                CompoundTag partyTag = input.m_130261_();
                if (partyTag == null) {
                    return null;
                }
                if (partyTag.m_128456_()) {
                    return new ClientboundPartyPacket(null, null, 0, 0, 0, 0, 0, 0);
                }
                UUID partyId = partyTag.m_128342_("i");
                CompoundTag ownerTag = partyTag.m_128469_("o");
                if (ownerTag.m_128456_()) {
                    OpenPartiesAndClaims.LOGGER.info("Received party packet with no owner info.");
                    return null;
                }
                PartyMember owner = this.playerInfoCodec.fromMemberTag(ownerTag, true);
                if (owner == null) {
                    OpenPartiesAndClaims.LOGGER.info("Received party packet with invalid owner info data.");
                    return null;
                }
                int memberCount = partyTag.m_128451_("mc");
                int inviteCount = partyTag.m_128451_("ic");
                int allyCount = partyTag.m_128451_("ac");
                int memberLimit = partyTag.m_128451_("ml");
                int inviteLimit = partyTag.m_128451_("il");
                int allyLimit = partyTag.m_128451_("al");
                return new ClientboundPartyPacket(partyId, owner, memberCount, inviteCount, allyCount, memberLimit, inviteLimit, allyLimit);
            }
            catch (Throwable t) {
                OpenPartiesAndClaims.LOGGER.error("invalid packet ", t);
                return null;
            }
        }
    }

    public static class ClientHandler
    extends LazyPacket.Handler<ClientboundPartyPacket> {
        @Override
        public void handle(ClientboundPartyPacket t) {
            ClientParty party = t.partyId == null ? null : ClientParty.Builder.begin().setId(t.partyId).setOwner((PartyMember)t.owner).build();
            OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getClientPartyStorage().setPartyCast(party);
            OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getClientPartyStorage().setLoadingMemberCount(t.memberCount);
            OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getClientPartyStorage().setLoadingInviteCount(t.inviteCount);
            OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getClientPartyStorage().setLoadingAllyCount(t.allyCount);
            OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getClientPartyStorage().setMemberLimit(t.memberLimit);
            OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getClientPartyStorage().setInviteLimit(t.inviteLimit);
            OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getClientPartyStorage().setAllyLimit(t.allyLimit);
        }
    }
}

