/*
 * Decompiled with CFR 0.152.
 */
package me.chrr.scribble.book;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import me.chrr.scribble.book.RichText;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;

public record BookFile(String author, Collection<RichText> pages) {
    public static BookFile read(Path path) throws IOException {
        CompoundTag root = NbtIo.m_128953_((File)path.toFile());
        if (root == null) {
            throw new IOException("could not read book nbt file");
        }
        String author = root.m_128461_("author");
        List<RichText> pages = root.m_128437_("pages", 8).stream().map(Tag::m_7916_).map(RichText::fromFormattedString).toList();
        return new BookFile(author, pages);
    }

    public void write(Path path) throws IOException {
        ListTag pagesNbt = new ListTag();
        for (RichText page : this.pages) {
            pagesNbt.add((Object)StringTag.m_129297_((String)page.getAsFormattedString()));
        }
        CompoundTag root = new CompoundTag();
        root.m_128359_("author", this.author);
        root.m_128365_("pages", (Tag)pagesNbt);
        NbtIo.m_128955_((CompoundTag)root, (File)path.toFile());
    }
}

