/*
 * Decompiled with CFR 0.152.
 */
package me.chrr.scribble.book;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import me.chrr.scribble.Scribble;
import me.chrr.scribble.book.RichText;
import net.minecraft.ChatFormatting;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.client.gui.font.TextFieldHelper;
import net.minecraft.util.Tuple;
import org.jetbrains.annotations.Nullable;

public class RichSelectionManager
extends TextFieldHelper {
    private final Supplier<RichText> textGetter;
    private final Consumer<RichText> textSetter;
    private final Predicate<RichText> textFilter;
    private final StateCallback stateCallback;
    private final Supplier<ChatFormatting> colorGetter;
    private final Supplier<Set<ChatFormatting>> modifiersGetter;

    public RichSelectionManager(Supplier<RichText> textGetter, Consumer<RichText> textSetter, StateCallback stateCallback, Supplier<String> clipboardGetter, Consumer<String> clipboardSetter, Predicate<RichText> textFilter, Supplier<ChatFormatting> colorGetter, Supplier<Set<ChatFormatting>> modifiersGetter) {
        super(() -> ((RichText)textGetter.get()).getPlainText(), text -> Scribble.LOGGER.warn("stringSetter called with \"{}\"", text), clipboardGetter, clipboardSetter, s -> true);
        this.textGetter = textGetter;
        this.textSetter = textSetter;
        this.textFilter = textFilter;
        this.stateCallback = stateCallback;
        this.colorGetter = colorGetter;
        this.modifiersGetter = modifiersGetter;
    }

    public boolean m_95143_(char c) {
        Predicate<Character> isValidChar = SharedConstants::m_136188_;
        if (isValidChar.test(Character.valueOf(c))) {
            this.m_95158_(String.valueOf(c));
        }
        return true;
    }

    public void m_95158_(String string) {
        RichText insertion;
        boolean isFormattedString;
        RichText text = this.textGetter.get();
        int start = Math.min(this.f_95134_, this.f_95135_);
        int end = Math.max(this.f_95134_, this.f_95135_);
        boolean bl = isFormattedString = !ChatFormatting.m_126649_((String)string).equals(string.replaceAll(ChatFormatting.RESET.toString(), ""));
        if (isFormattedString) {
            insertion = RichText.fromFormattedString(string);
        } else {
            string = string.replaceAll(ChatFormatting.RESET.toString(), "");
            insertion = new RichText(string, this.colorGetter.get(), this.modifiersGetter.get());
        }
        text = start == end ? text.insert(start, insertion) : text.replace(start, end, insertion);
        if (this.textFilter.test(text)) {
            int newCursorPosition;
            this.textSetter.accept(text);
            String plaintStringToInsert = RichText.fromFormattedString(string).getPlainText();
            this.f_95135_ = this.f_95134_ = (newCursorPosition = Math.min(text.getPlainText().length(), start + plaintStringToInsert.length()));
            this.notifyCursorFormattingChanged();
        }
    }

    public void m_95189_(int offset) {
        RichText text = this.textGetter.get();
        if (this.f_95135_ != this.f_95134_) {
            int start = Math.min(this.f_95134_, this.f_95135_);
            int end = Math.max(this.f_95134_, this.f_95135_);
            text = text.replace(start, end, RichText.empty());
            this.f_95134_ = this.f_95135_ = start;
        } else {
            int cursor = Util.m_137479_((String)text.getPlainText(), (int)this.f_95134_, (int)offset);
            int start = Math.min(cursor, this.f_95134_);
            int end = Math.max(cursor, this.f_95134_);
            text = text.replace(start, end, RichText.empty());
            this.f_95135_ = this.f_95134_ = start;
        }
        this.textSetter.accept(text);
        this.notifyCursorFormattingChanged();
    }

    public void m_95178_() {
        this.f_95132_.accept(this.getSelectedFormattedText());
    }

    public void m_95142_() {
        this.f_95132_.accept(this.getSelectedFormattedText());
        this.m_95189_(0);
    }

    public String getSelectedFormattedText() {
        int i = Math.min(this.f_95134_, this.f_95135_);
        int j = Math.max(this.f_95134_, this.f_95135_);
        return this.textGetter.get().subText(i, j).getAsFormattedString();
    }

    public void m_95165_() {
        this.m_95158_((String)this.f_95131_.get());
    }

    public void applyColorForSelection(ChatFormatting color) {
        this.applyFormatting(color, Set.of(), Set.of());
    }

    public void toggleModifierForSelection(ChatFormatting modifier, boolean toggled) {
        if (toggled) {
            this.applyFormatting(null, Set.of(modifier), Set.of());
        } else {
            this.applyFormatting(null, Set.of(), Set.of(modifier));
        }
    }

    private void applyFormatting(@Nullable ChatFormatting newColor, Set<ChatFormatting> addModifiers, Set<ChatFormatting> removeModifiers) {
        if (this.m_95198_()) {
            int start = Math.min(this.f_95134_, this.f_95135_);
            int end = Math.max(this.f_95134_, this.f_95135_);
            RichText text = this.textGetter.get().applyFormatting(start, end, newColor, addModifiers, removeModifiers);
            this.textSetter.accept(text);
        }
    }

    public void notifyCursorFormattingChanged() {
        if (this.stateCallback == null) {
            return;
        }
        Tuple<@Nullable ChatFormatting, Set<ChatFormatting>> format = this.getCursorFormatting();
        ChatFormatting color = (ChatFormatting)format.m_14418_();
        HashSet<ChatFormatting> modifiers = new HashSet<ChatFormatting>((Collection)format.m_14419_());
        this.stateCallback.onCursorFormattingChanged(color, modifiers);
    }

    public Tuple<@Nullable ChatFormatting, Set<ChatFormatting>> getCursorFormatting() {
        if (this.textGetter == null) {
            return new Tuple(null, Set.of());
        }
        int start = Math.min(this.f_95134_, this.f_95135_);
        int end = Math.max(this.f_95134_, this.f_95135_);
        return this.textGetter.get().getCommonFormat(start, end);
    }

    public void m_95147_(int start, int end) {
        super.m_95147_(start, end);
        this.notifyCursorFormattingChanged();
    }

    public void m_95188_() {
        super.m_95188_();
        this.notifyCursorFormattingChanged();
    }

    protected void m_95163_(boolean shiftDown) {
        super.m_95163_(shiftDown);
        this.notifyCursorFormattingChanged();
    }

    public static interface StateCallback {
        public void onCursorFormattingChanged(@Nullable ChatFormatting var1, Set<ChatFormatting> var2);
    }
}

