/*
 * Decompiled with CFR 0.152.
 */
package me.chrr.scribble.book;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.util.Tuple;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RichText
implements FormattedText {
    private final List<Segment> segments;

    public RichText(List<Segment> segments) {
        this.segments = segments;
    }

    public RichText(String text, ChatFormatting color, Set<ChatFormatting> modifiers) {
        this(List.of(new Segment(text, color, modifiers)));
    }

    public List<Segment> getSegments() {
        return this.segments;
    }

    public static RichText empty() {
        return new RichText(List.of());
    }

    public static RichText fromFormattedString(String input) {
        ArrayList<Segment> segments = new ArrayList<Segment>();
        StringBuilder text = new StringBuilder();
        ChatFormatting color = ChatFormatting.BLACK;
        HashSet<ChatFormatting> modifiers = new HashSet<ChatFormatting>();
        int i = 0;
        while (i < input.length()) {
            int codePoint = input.codePointAt(i);
            i += Character.charCount(codePoint);
            if (codePoint == 167) {
                if (i >= input.length()) break;
                char code = input.charAt(i);
                ++i;
                ChatFormatting formatting = ChatFormatting.m_126645_((char)code);
                if (formatting == null) continue;
                if (!text.isEmpty()) {
                    segments.add(new Segment(text.toString(), color, new HashSet<ChatFormatting>(modifiers)));
                    text = new StringBuilder();
                }
                if (formatting.m_126661_()) {
                    modifiers.add(formatting);
                    continue;
                }
                color = formatting;
                modifiers.clear();
                continue;
            }
            text.appendCodePoint(codePoint);
        }
        if (!text.isEmpty()) {
            segments.add(new Segment(text.toString(), color, modifiers));
        }
        return new RichText(segments);
    }

    public static RichText fromStringVisitableLossy(FormattedText stringVisitable) {
        ArrayList<Segment> segments = new ArrayList<Segment>();
        AtomicReference<ChatFormatting> color = new AtomicReference<ChatFormatting>(ChatFormatting.BLACK);
        stringVisitable.m_7451_((style, string) -> {
            if (style.m_131135_() != null) {
                color.set(RichText.formattingFromTextColor(style.m_131135_()));
            }
            HashSet<ChatFormatting> modifiers = new HashSet<ChatFormatting>();
            if (style.m_131154_()) {
                modifiers.add(ChatFormatting.BOLD);
            }
            if (style.m_131161_()) {
                modifiers.add(ChatFormatting.ITALIC);
            }
            if (style.m_131171_()) {
                modifiers.add(ChatFormatting.UNDERLINE);
            }
            if (style.m_131176_()) {
                modifiers.add(ChatFormatting.OBFUSCATED);
            }
            if (style.m_131168_()) {
                modifiers.add(ChatFormatting.STRIKETHROUGH);
            }
            segments.add(new Segment(string, (ChatFormatting)color.get(), modifiers));
            return Optional.empty();
        }, Style.f_131099_.m_131157_(ChatFormatting.BLACK));
        return new RichText(segments);
    }

    private static ChatFormatting formattingFromTextColor(TextColor color) {
        ChatFormatting byName = ChatFormatting.m_126657_((String)color.m_131274_());
        if (byName != null) {
            return byName;
        }
        ChatFormatting closest = ChatFormatting.BLACK;
        int distance = Integer.MAX_VALUE;
        for (ChatFormatting formatting : ChatFormatting.values()) {
            int db;
            int dg;
            int dr;
            int dist;
            Integer colorValue = formatting.m_126665_();
            if (colorValue == null || (dist = (dr = Math.abs((colorValue >> 16 & 0xFF) - (color.m_131265_() >> 16 & 0xFF))) + (dg = Math.abs((colorValue >> 8 & 0xFF) - (color.m_131265_() >> 8 & 0xFF))) + (db = Math.abs((colorValue & 0xFF) - (color.m_131265_() & 0xFF)))) >= distance) continue;
            closest = formatting;
            distance = dist;
        }
        return closest;
    }

    @NotNull
    private RichText mergeSimilarSegments() {
        if (this.segments.isEmpty()) {
            return this;
        }
        ArrayList<Segment> mergedSegments = new ArrayList<Segment>();
        Segment previousSegment = null;
        for (Segment segment : this.segments) {
            boolean areModifiersMatching;
            if (previousSegment == null) {
                previousSegment = segment;
                continue;
            }
            boolean isColorMatching = previousSegment.color == segment.color;
            boolean bl = areModifiersMatching = segment.modifiers.containsAll(previousSegment.modifiers()) && previousSegment.modifiers().containsAll(segment.modifiers);
            if (isColorMatching && areModifiersMatching) {
                previousSegment = new Segment(previousSegment.text + segment.text, previousSegment.color, previousSegment.modifiers);
                continue;
            }
            mergedSegments.add(previousSegment);
            previousSegment = segment;
        }
        mergedSegments.add(previousSegment);
        return new RichText(mergedSegments);
    }

    public String getPlainText() {
        return this.segments.stream().map(segment -> segment.text).collect(Collectors.joining());
    }

    public boolean isEmpty() {
        return this.getPlainText().isEmpty();
    }

    public int getLength() {
        return this.segments.stream().map(segment -> segment.text.length()).reduce(0, Integer::sum);
    }

    public RichText subText(int start, int end) {
        int current = 0;
        ArrayList<Segment> subSegments = new ArrayList<Segment>();
        for (Segment segment : this.segments) {
            int length = segment.text.length();
            if (current + length <= start) {
                current += length;
                continue;
            }
            if (current >= end) break;
            int localStart = Math.max(0, start - current);
            int localEnd = Math.min(length, end - current);
            subSegments.add(new Segment(segment.text.substring(localStart, localEnd), segment.color, segment.modifiers));
            current += length;
        }
        return new RichText(subSegments);
    }

    public RichText replace(int start, int end, RichText replacement) {
        int current = 0;
        ArrayList<Segment> newSegments = new ArrayList<Segment>();
        boolean replacementAppended = false;
        for (Segment segment : this.segments) {
            int length = segment.text.length();
            if (current + length <= start) {
                newSegments.add(segment);
                current += length;
                continue;
            }
            if (current >= end) {
                newSegments.add(segment);
                continue;
            }
            int localStart = Math.max(0, start - current);
            int localEnd = Math.min(length, end - current);
            if (localStart > 0) {
                newSegments.add(new Segment(segment.text.substring(0, localStart), segment.color, segment.modifiers));
            }
            if (!replacement.isEmpty() && !replacementAppended) {
                newSegments.addAll(replacement.segments);
                replacementAppended = true;
            }
            if (localEnd < length) {
                newSegments.add(new Segment(segment.text.substring(localEnd), segment.color, segment.modifiers));
            }
            current += length;
        }
        return new RichText(newSegments).mergeSimilarSegments();
    }

    public RichText insert(int offset, RichText text) {
        if (text.isEmpty()) {
            return this;
        }
        if (this.segments.isEmpty()) {
            return text;
        }
        ArrayList<Segment> combinedSegments = new ArrayList<Segment>(this.segments);
        int currentOffset = 0;
        for (int i = 0; i < this.segments.size(); ++i) {
            boolean shouldSplitSegment;
            Segment segment = this.segments.get(i);
            int segmentLength = segment.text.length();
            if (offset > currentOffset + segmentLength) {
                currentOffset += segmentLength;
                continue;
            }
            int inSegmentOffset = offset - currentOffset;
            combinedSegments.remove(i);
            combinedSegments.addAll(i, text.segments);
            boolean bl = shouldSplitSegment = offset < currentOffset + segmentLength;
            if (shouldSplitSegment) {
                Segment segmentEndPart = new Segment(segment.text.substring(inSegmentOffset), segment.color, segment.modifiers);
                combinedSegments.add(i + text.segments.size(), segmentEndPart);
            }
            if (offset - currentOffset <= 0) break;
            Segment segmentStartPart = new Segment(segment.text.substring(0, inSegmentOffset), segment.color, segment.modifiers);
            combinedSegments.add(i, segmentStartPart);
            break;
        }
        return new RichText(combinedSegments).mergeSimilarSegments();
    }

    public RichText applyFormatting(int start, int end, @Nullable ChatFormatting newColor, Set<ChatFormatting> addModifiers, Set<ChatFormatting> removeModifiers) {
        if (start == end) {
            return this;
        }
        int current = 0;
        ArrayList<Segment> newSegments = new ArrayList<Segment>();
        for (Segment segment : this.segments) {
            int length = segment.text.length();
            if (current + length <= start) {
                newSegments.add(segment);
                current += length;
                continue;
            }
            if (current >= end) {
                newSegments.add(segment);
                continue;
            }
            int localStart = Math.max(0, start - current);
            int localEnd = Math.min(length, end - current);
            if (localStart > 0) {
                newSegments.add(new Segment(segment.text.substring(0, localStart), segment.color, segment.modifiers));
            }
            String modifiedText = segment.text.substring(localStart, localEnd);
            ChatFormatting color = Optional.ofNullable(newColor).orElse(segment.color);
            HashSet<ChatFormatting> modifiers = new HashSet<ChatFormatting>(segment.modifiers);
            modifiers.addAll(addModifiers);
            modifiers.removeAll(removeModifiers);
            newSegments.add(new Segment(modifiedText, color, modifiers));
            if (localEnd < length) {
                newSegments.add(new Segment(segment.text.substring(localEnd), segment.color, segment.modifiers));
            }
            current += length;
        }
        return new RichText(newSegments);
    }

    public String getAsFormattedString() {
        StringBuilder out = new StringBuilder();
        ChatFormatting currentColor = ChatFormatting.BLACK;
        Set<Object> currentModifiers = new HashSet();
        for (Segment segment : this.segments) {
            if (segment.text.isEmpty()) continue;
            boolean colorChanged = !segment.color.equals((Object)currentColor);
            HashSet modifiersToRemove = new HashSet(currentModifiers);
            modifiersToRemove.removeAll(segment.modifiers);
            boolean shouldReapply = colorChanged || !modifiersToRemove.isEmpty();
            HashSet<ChatFormatting> modifiersToAdd = new HashSet<ChatFormatting>(segment.modifiers);
            if (!shouldReapply) {
                modifiersToAdd.removeAll(currentModifiers);
            }
            if (colorChanged || shouldReapply) {
                out.append(segment.color);
            }
            for (ChatFormatting format : modifiersToAdd) {
                out.append(format);
            }
            out.append(segment.text);
            currentColor = segment.color;
            currentModifiers = segment.modifiers;
        }
        return out.toString();
    }

    public Tuple<@Nullable ChatFormatting, Set<ChatFormatting>> getCommonFormat(int start, int end) {
        boolean first = true;
        Set modifiers = Set.of();
        ChatFormatting color = ChatFormatting.BLACK;
        int current = 0;
        for (Segment segment : this.segments) {
            int length = segment.text.length();
            if (start == end && start <= current + length) {
                return new Tuple((Object)segment.color, segment.modifiers);
            }
            if (current + length <= start) {
                current += length;
                continue;
            }
            if (current >= end) break;
            if (first) {
                modifiers = new HashSet<ChatFormatting>(segment.modifiers);
                color = segment.color;
                first = false;
            } else {
                modifiers.retainAll(segment.modifiers);
                if (color != segment.color) {
                    color = null;
                }
            }
            current += length;
        }
        return new Tuple((Object)color, modifiers);
    }

    public <T> Optional<T> m_5651_(FormattedText.ContentConsumer<T> visitor) {
        for (Segment segment : this.segments) {
            Optional out = visitor.m_130809_(segment.text);
            if (!out.isPresent()) continue;
            return out;
        }
        return Optional.empty();
    }

    public <T> Optional<T> m_7451_(FormattedText.StyledContentConsumer<T> styledVisitor, Style baseStyle) {
        for (Segment segment : this.segments) {
            Style style = baseStyle.m_131152_(segment.modifiers.toArray(new ChatFormatting[0])).m_131140_(segment.color);
            Optional out = styledVisitor.m_7164_(style, segment.text);
            if (!out.isPresent()) continue;
            return out;
        }
        return Optional.empty();
    }

    public String getString() {
        return this.getPlainText();
    }

    public String toString() {
        return "RichText{segments=" + String.valueOf(this.segments) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RichText richText = (RichText)o;
        return Objects.equals(this.segments, richText.segments);
    }

    public int hashCode() {
        return Objects.hashCode(this.segments);
    }

    public record Segment(String text, ChatFormatting color, Set<ChatFormatting> modifiers) {
    }
}

