/*
 * Decompiled with CFR 0.152.
 */
package me.chrr.scribble.history;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import me.chrr.scribble.history.command.Command;
import org.jetbrains.annotations.NotNull;

public class CommandManager {
    private static final int EMPTY_STACK_INDEX = -1;
    private final int maxHistorySize;
    private final LinkedList<Command> commandStack;
    private int lastExecutedCommandIndex = -1;
    private final List<Runnable> historyCallbacks = new ArrayList<Runnable>();

    public CommandManager(int maxHistorySize) {
        this.maxHistorySize = maxHistorySize;
        this.commandStack = new LinkedList();
    }

    public void clear() {
        this.lastExecutedCommandIndex = -1;
        this.commandStack.clear();
        this.historyCallbacks.forEach(Runnable::run);
    }

    public void execute(@NotNull Command command) {
        boolean affectedState;
        this.dropAllAboveCurrentIndex();
        if (this.commandStack.size() >= this.maxHistorySize && this.maxHistorySize > 0) {
            this.commandStack.pollFirst();
            --this.lastExecutedCommandIndex;
        }
        if ((affectedState = command.execute()) && this.maxHistorySize > 0) {
            this.commandStack.add(command);
            ++this.lastExecutedCommandIndex;
        }
        this.historyCallbacks.forEach(Runnable::run);
    }

    private void dropAllAboveCurrentIndex() {
        while (this.lastExecutedCommandIndex < this.commandStack.size() - 1) {
            this.commandStack.removeLast();
        }
        this.historyCallbacks.forEach(Runnable::run);
    }

    public boolean tryUndo() {
        if (this.hasCommandsToUndo()) {
            boolean wasRolledBack = this.commandStack.get(this.lastExecutedCommandIndex).rollback();
            --this.lastExecutedCommandIndex;
            if (!wasRolledBack) {
                return this.tryUndo();
            }
            this.historyCallbacks.forEach(Runnable::run);
            return true;
        }
        return false;
    }

    public boolean hasCommandsToUndo() {
        if (this.commandStack.isEmpty()) {
            return false;
        }
        return this.lastExecutedCommandIndex >= 0;
    }

    public boolean tryRedo() {
        if (this.hasCommandsToRedo()) {
            ++this.lastExecutedCommandIndex;
            this.commandStack.get(this.lastExecutedCommandIndex).execute();
            this.historyCallbacks.forEach(Runnable::run);
            return true;
        }
        return false;
    }

    public boolean hasCommandsToRedo() {
        int lastAvailableIndexInStack = this.commandStack.size() - 1;
        return this.lastExecutedCommandIndex < lastAvailableIndexInStack;
    }

    public void onHistoryUpdate(Runnable callback) {
        this.historyCallbacks.add(callback);
    }
}

