/*
 * Decompiled with CFR 0.152.
 */
package me.chrr.scribble.history.command;

import me.chrr.scribble.history.Restorable;
import me.chrr.scribble.history.command.Command;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MementoCommand<T>
implements Command {
    @NotNull
    private final Restorable<T> restorable;
    @Nullable
    private T originalMemento;

    protected MementoCommand(@NotNull Restorable<T> restorable) {
        this.restorable = restorable;
    }

    @Nullable
    public T getOriginalMemento() {
        return this.originalMemento;
    }

    @Override
    public boolean execute() {
        if (this.originalMemento == null) {
            this.originalMemento = this.restorable.scribble$createMemento();
        } else {
            this.restorable.scribble$restore(this.originalMemento);
        }
        this.doAction();
        return !this.restorable.scribble$createMemento().equals(this.originalMemento);
    }

    public abstract void doAction();

    @Override
    public boolean rollback() {
        if (this.originalMemento != null) {
            T currentState = this.restorable.scribble$createMemento();
            this.restorable.scribble$restore(this.originalMemento);
            return !this.originalMemento.equals(currentState);
        }
        return false;
    }
}

