/*
 * Decompiled with CFR 0.152.
 */
package me.chrr.scribble.mixin;

import java.nio.file.Path;
import java.util.List;
import java.util.stream.IntStream;
import me.chrr.scribble.Scribble;
import me.chrr.scribble.book.BookFile;
import me.chrr.scribble.book.FileChooser;
import me.chrr.scribble.book.RichText;
import me.chrr.scribble.config.Config;
import me.chrr.scribble.gui.IconButtonWidget;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.BookViewScreen;
import net.minecraft.network.chat.Component;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BookViewScreen.class})
public abstract class BookScreenMixin
extends Screen {
    @Shadow
    private BookViewScreen.BookAccess f_98253_;

    private BookScreenMixin() {
        super(null);
    }

    @Inject(method={"m_7856_()V"}, at={@At(value="TAIL")})
    public void initButtons(CallbackInfo info) {
        if (Scribble.CONFIG_MANAGER.getConfig().showActionButtons == Config.ShowActionButtons.ALWAYS) {
            int x = this.f_96543_ / 2 - 78 - 7 - 12;
            int y = Scribble.getBookScreenYOffset(this.f_96544_) + 12 + 4;
            Runnable saveBook = () -> FileChooser.chooseBook(true, path -> {
                try {
                    List<RichText> richPages = IntStream.range(0, this.f_98253_.m_5732_()).mapToObj(arg_0 -> ((BookViewScreen.BookAccess)this.f_98253_).m_7303_(arg_0)).map(RichText::fromStringVisitableLossy).toList();
                    BookFile bookFile = new BookFile("<written book>", List.copyOf(richPages));
                    bookFile.write((Path)path);
                }
                catch (Exception e) {
                    Scribble.LOGGER.error("could not save book to file", (Throwable)e);
                }
            });
            this.m_142416_((GuiEventListener)new IconButtonWidget((Component)Component.m_237115_((String)"text.scribble.action.save_book_to_file"), saveBook, x, y, 48, 90, 12, 12));
        }
    }

    @Redirect(method={"m_7829_()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/inventory/BookViewScreen;m_142416_(Lnet/minecraft/client/gui/components/events/GuiEventListener;)Lnet/minecraft/client/gui/components/events/GuiEventListener;"))
    public <T extends GuiEventListener & Renderable> T shiftCloseButtonY(BookViewScreen instance, T element) {
        if (element instanceof LayoutElement) {
            LayoutElement widget = (LayoutElement)element;
            widget.m_253211_(widget.m_252907_() + Scribble.getBookScreenYOffset(this.f_96544_));
        }
        return (T)this.m_142416_(element);
    }

    @Redirect(method={"m_98301_()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/inventory/BookViewScreen;m_142416_(Lnet/minecraft/client/gui/components/events/GuiEventListener;)Lnet/minecraft/client/gui/components/events/GuiEventListener;"))
    public <T extends GuiEventListener & Renderable> T shiftPageButtonY(BookViewScreen instance, T element) {
        if (element instanceof LayoutElement) {
            LayoutElement widget = (LayoutElement)element;
            widget.m_253211_(widget.m_252907_() + Scribble.getBookScreenYOffset(this.f_96544_));
        }
        return (T)this.m_142416_(element);
    }

    @ModifyVariable(method={"m_98268_(DD)Lnet/minecraft/network/chat/Style;"}, at=@At(value="HEAD"), ordinal=1, argsOnly=true)
    public double shiftTextStyleY(double y) {
        return y - (double)Scribble.getBookScreenYOffset(this.f_96544_);
    }

    @Inject(method={"m_88315_(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/inventory/BookViewScreen;m_280273_(Lnet/minecraft/client/gui/GuiGraphics;)V", shift=At.Shift.AFTER)})
    public void translateRender(GuiGraphics context, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        context.m_280168_().m_85836_();
        context.m_280168_().m_252880_(0.0f, (float)Scribble.getBookScreenYOffset(this.f_96544_), 0.0f);
    }

    @ModifyArg(method={"m_88315_(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;m_280304_(Lnet/minecraft/client/gui/Font;Lnet/minecraft/network/chat/Style;II)V"), index=3)
    public int shiftHoverTooltipY(int y) {
        return y - Scribble.getBookScreenYOffset(this.f_96544_);
    }

    @Inject(method={"m_88315_(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/Screen;m_88315_(Lnet/minecraft/client/gui/GuiGraphics;IIF)V")})
    public void popRender(GuiGraphics context, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        context.m_280168_().m_85849_();
    }
}

