/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.cosmeticcorpsecompat.mixin;

import de.maxhenkel.corpse.entities.CorpseEntity;
import de.maxhenkel.corpse.gui.CorpseAdditionalContainer;
import de.maxhenkel.corpse.gui.CorpseInventoryContainer;
import java.util.UUID;
import lain.mods.cos.api.CosArmorAPI;
import lain.mods.cos.api.inventory.CAStacksBase;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={CorpseInventoryContainer.class, CorpseAdditionalContainer.class})
public abstract class CosmeticArmorCorpseMixin {
    private Player cachedPlayer;

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void onInit(int id, Inventory playerInventory, CorpseEntity corpse, boolean editable, boolean history, CallbackInfo ci) {
        if (playerInventory != null) {
            this.cachedPlayer = playerInventory.f_35978_;
        }
    }

    @Inject(method={"transferItems"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void transferItemsToCosmeticArmor(CallbackInfo ci) {
        block11: {
            boolean isAdditional;
            CAStacksBase cosArmorInventory;
            CosmeticArmorCorpseMixin container;
            block10: {
                int i;
                container = this;
                if (!this.cachedPlayer.m_6084_()) {
                    return;
                }
                UUID playerUUID = this.cachedPlayer.m_20148_();
                cosArmorInventory = CosArmorAPI.getCAStacks((UUID)playerUUID);
                boolean isCorpseInv = container instanceof CorpseInventoryContainer;
                isAdditional = container instanceof CorpseAdditionalContainer;
                if (!isCorpseInv) break block10;
                CorpseInventoryContainer corpseContainer = (CorpseInventoryContainer)container;
                for (i = 0; i < corpseContainer.f_38839_.size() && i < corpseContainer.getInventorySize(); ++i) {
                    Slot slot = corpseContainer.m_38853_(i);
                    ItemStack stack = slot.m_7993_();
                    if (!this.isCosmeticArmorItem(stack)) continue;
                    int cosmeticSlot = this.getCosmeticSlotIndex(stack);
                    boolean isSkinArmor = this.isSkinArmorItem(stack);
                    CompoundTag tag = stack.m_41783_();
                    if (tag != null) {
                        tag.m_128473_("CosmeticArmorItem");
                        tag.m_128473_("CosmeticSlotIndex");
                        tag.m_128473_("CosmeticSkinArmor");
                        if (tag.m_128456_()) {
                            stack.m_41751_(null);
                        }
                    }
                    cosArmorInventory.setStackInSlot(cosmeticSlot, stack);
                    cosArmorInventory.setSkinArmor(cosmeticSlot, isSkinArmor);
                    slot.m_5852_(ItemStack.f_41583_);
                }
                for (i = 0; i < corpseContainer.getCorpse().getDeath().getAdditionalItems().size(); ++i) {
                    ItemStack stack = (ItemStack)corpseContainer.getCorpse().getDeath().getAdditionalItems().get(i);
                    if (!this.isCosmeticArmorItem(stack)) continue;
                    int cosmeticSlot = this.getCosmeticSlotIndex(stack);
                    boolean isSkinArmor = this.isSkinArmorItem(stack);
                    CompoundTag tag = stack.m_41783_();
                    if (tag != null) {
                        tag.m_128473_("CosmeticArmorItem");
                        tag.m_128473_("CosmeticSlotIndex");
                        tag.m_128473_("CosmeticSkinArmor");
                        if (tag.m_128456_()) {
                            stack.m_41751_(null);
                        }
                    }
                    cosArmorInventory.setStackInSlot(cosmeticSlot, stack);
                    cosArmorInventory.setSkinArmor(cosmeticSlot, isSkinArmor);
                    corpseContainer.getCorpse().getDeath().getAdditionalItems().set(i, (Object)ItemStack.f_41583_);
                }
                break block11;
            }
            if (!isAdditional) break block11;
            CorpseAdditionalContainer additionalContainer = (CorpseAdditionalContainer)container;
            for (int i = 0; i < additionalContainer.getInventorySize(); ++i) {
                ItemStack stack;
                Slot slot = additionalContainer.m_38853_(i);
                if (slot == null || !this.isCosmeticArmorItem(stack = slot.m_7993_())) continue;
                int cosmeticSlot = this.getCosmeticSlotIndex(stack);
                boolean isSkinArmor = this.isSkinArmorItem(stack);
                CompoundTag tag = stack.m_41783_();
                if (tag != null) {
                    tag.m_128473_("CosmeticArmorItem");
                    tag.m_128473_("CosmeticSlotIndex");
                    tag.m_128473_("CosmeticSkinArmor");
                    if (tag.m_128456_()) {
                        stack.m_41751_(null);
                    }
                }
                cosArmorInventory.setStackInSlot(cosmeticSlot, stack);
                cosArmorInventory.setSkinArmor(cosmeticSlot, isSkinArmor);
                slot.m_5852_(ItemStack.f_41583_);
            }
        }
    }

    @Unique
    private boolean isCosmeticArmorItem(ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        CompoundTag tag = stack.m_41783_();
        return tag != null && tag.m_128471_("CosmeticArmorItem");
    }

    @Unique
    private int getCosmeticSlotIndex(ItemStack stack) {
        if (stack.m_41619_()) {
            return 0;
        }
        CompoundTag tag = stack.m_41783_();
        return tag != null ? tag.m_128451_("CosmeticSlotIndex") : 0;
    }

    @Unique
    private boolean isSkinArmorItem(ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        CompoundTag tag = stack.m_41783_();
        return tag != null && tag.m_128471_("CosmeticSkinArmor");
    }
}

