/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.evenmoreinstruments.item.crafting;

import com.cstav.evenmoreinstruments.item.ModItems;
import com.cstav.evenmoreinstruments.item.crafting.ModRecipeSerializers;
import com.cstav.evenmoreinstruments.item.emirecord.WritableRecordItem;
import java.util.Optional;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class RecordCloningRecipe
extends CustomRecipe {
    public RecordCloningRecipe(ResourceLocation pId, CraftingBookCategory pCategory) {
        super(pId, pCategory);
    }

    public boolean matches(CraftingContainer pInv, Level pLevel) {
        return this.getIngredientsFromContainer(pInv).isPresent();
    }

    private static boolean isWritableRecord(ItemStack stack) {
        return stack.m_150930_((Item)ModItems.RECORD_WRITABLE.get()) && !((WritableRecordItem)stack.m_41720_()).isBurned(stack);
    }

    private static boolean isBurnedRecord(ItemStack stack) {
        return stack.m_150930_((Item)ModItems.RECORD_WRITABLE.get()) && ((WritableRecordItem)stack.m_41720_()).isBurned(stack);
    }

    public ItemStack assemble(CraftingContainer pContainer, RegistryAccess pRegistryAccess) {
        Optional<ItemStack[]> ingredients = this.getIngredientsFromContainer(pContainer);
        if (ingredients.isEmpty()) {
            return ItemStack.f_41583_;
        }
        return ingredients.get()[1].m_255036_(1);
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer pInv) {
        NonNullList result = NonNullList.m_122780_((int)pInv.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < result.size(); ++i) {
            ItemStack stack = pInv.m_8020_(i);
            if (!RecordCloningRecipe.isBurnedRecord(stack)) continue;
            result.set(i, (Object)stack.m_255036_(1));
            return result;
        }
        return result;
    }

    private Optional<ItemStack[]> getIngredientsFromContainer(CraftingContainer pInv) {
        ItemStack burnedRecord = ItemStack.f_41583_;
        ItemStack writableRecord = ItemStack.f_41583_;
        for (int i = 0; i < pInv.m_6643_(); ++i) {
            ItemStack stack = pInv.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (RecordCloningRecipe.isBurnedRecord(stack)) {
                if (!burnedRecord.m_41619_()) {
                    return Optional.empty();
                }
                burnedRecord = stack;
                if (writableRecord.m_41619_()) continue;
                return Optional.of(new ItemStack[]{writableRecord, burnedRecord});
            }
            if (!RecordCloningRecipe.isWritableRecord(stack) || !writableRecord.m_41619_()) {
                return Optional.empty();
            }
            writableRecord = stack;
            if (burnedRecord.m_41619_()) continue;
            return Optional.of(new ItemStack[]{writableRecord, burnedRecord});
        }
        return Optional.empty();
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeSerializers.RECORD_CLONING.get();
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return pWidth >= 3 && pHeight >= 3;
    }
}

