/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.evenmoreinstruments.server.command;

import com.cstav.evenmoreinstruments.EMIMain;
import com.cstav.evenmoreinstruments.item.ModItems;
import com.cstav.evenmoreinstruments.item.emirecord.RecordRepository;
import com.cstav.evenmoreinstruments.item.emirecord.WritableRecordItem;
import com.cstav.evenmoreinstruments.util.CommonUtil;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.io.IOException;
import java.util.Optional;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class EMIRecordCommand {
    private static final SuggestionProvider<CommandSourceStack> SUGGEST_RECORDS = (stack, builder) -> SharedSuggestionProvider.m_82957_(RecordRepository.listRecords(false), (SuggestionsBuilder)builder);
    private static final DynamicCommandExceptionType ERROR_NO_ITEM = new DynamicCommandExceptionType(player -> Component.m_237110_((String)"commands.evenmoreinstruments.emirecord.failed.no_record", (Object[])new Object[]{player}));
    private static final DynamicCommandExceptionType ERROR_RECORD_ALREADY_BURNED = new DynamicCommandExceptionType(player -> Component.m_237110_((String)"commands.evenmoreinstruments.emirecord.failed.record_already_burned", (Object[])new Object[]{player}));
    private static final DynamicCommandExceptionType ERROR_RECORD_BURNED = new DynamicCommandExceptionType(player -> Component.m_237110_((String)"commands.evenmoreinstruments.emirecord.failed.record_burned", (Object[])new Object[]{player}));
    private static final DynamicCommandExceptionType ERROR_RECORD_EMPTY = new DynamicCommandExceptionType(player -> Component.m_237110_((String)"commands.evenmoreinstruments.emirecord.failed.record_empty", (Object[])new Object[]{player}));
    private static final DynamicCommandExceptionType ERROR_RECORD_INVALID = new DynamicCommandExceptionType(id -> Component.m_237110_((String)"commands.evenmoreinstruments.emirecord.failed.record_invalid", (Object[])new Object[]{id}));
    private static final DynamicCommandExceptionType ERROR_TOO_MANY = new DynamicCommandExceptionType(player -> Component.m_237110_((String)"commands.evenmoreinstruments.emirecord.failed.too_many", (Object[])new Object[]{player}));
    private static final DynamicCommandExceptionType ERROR_INVALID_NAMESPACE = new DynamicCommandExceptionType(id -> Component.m_237110_((String)"commands.evenmoreinstruments.emirecord.failed.invalid_namespace", (Object[])new Object[]{"evenmoreinstruments", id}));
    private static final DynamicCommandExceptionType ERROR_ILLEGAL_NAME = new DynamicCommandExceptionType(name -> Component.m_237110_((String)"commands.evenmoreinstruments.emirecord.failed.illegal_name", (Object[])new Object[]{name}));

    public static void register(CommandDispatcher<CommandSourceStack> pDispatcher) {
        pDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"emirecord").then(Commands.m_82127_((String)"burn").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"record", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(SUGGEST_RECORDS).executes(stack -> EMIRecordCommand.loadRecordToHand((CommandContext<CommandSourceStack>)stack, (Player)((CommandSourceStack)stack.getSource()).m_81375_()))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91466_()).requires(stack -> stack.m_6761_(2))).executes(stack -> EMIRecordCommand.loadRecordToHand((CommandContext<CommandSourceStack>)stack, (Player)EntityArgument.m_91474_((CommandContext)stack, (String)"target"))))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"save").requires(stack -> stack.m_6761_(2))).then(Commands.m_82129_((String)"record", (ArgumentType)ResourceLocationArgument.m_106984_()).executes(EMIRecordCommand::saveRecord)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"remove").requires(stack -> stack.m_6761_(2))).then(Commands.m_82129_((String)"record", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(SUGGEST_RECORDS).executes(EMIRecordCommand::removeRecord))));
    }

    private static int saveRecord(CommandContext<CommandSourceStack> stack) throws CommandSyntaxException {
        ServerPlayer target = ((CommandSourceStack)stack.getSource()).m_81375_();
        ResourceLocation saveLoc = ResourceLocationArgument.m_107011_(stack, (String)"record");
        if (saveLoc.m_135827_().equals("evenmoreinstruments")) {
            throw ERROR_INVALID_NAMESPACE.create((Object)saveLoc);
        }
        if (saveLoc.m_135815_().contains(".")) {
            throw ERROR_ILLEGAL_NAME.create((Object)saveLoc);
        }
        Optional<ItemStack> record = CommonUtil.getItemInBothHands((Player)target, (Item)ModItems.RECORD_WRITABLE.get());
        if (record.isEmpty()) {
            throw ERROR_NO_ITEM.create((Object)target.m_5446_());
        }
        if (!((WritableRecordItem)record.get().m_41720_()).isBurned(record.get())) {
            throw ERROR_RECORD_EMPTY.create((Object)target.m_5446_());
        }
        CompoundTag channelTag = record.get().m_41737_("Channel");
        if (channelTag == null) {
            CompoundTag recordTag = record.get().m_41783_();
            if (recordTag == null) {
                throw ERROR_RECORD_EMPTY.create((Object)target.m_5446_());
            }
            if (recordTag.m_128441_("BurnedMedia")) {
                throw ERROR_RECORD_BURNED.create((Object)target.m_5446_());
            }
            throw ERROR_RECORD_EMPTY.create((Object)target.m_5446_());
        }
        try {
            RecordRepository.saveRecord(saveLoc, channelTag);
        }
        catch (IOException e) {
            EMIMain.LOGGER.error("Error encountered while saving record data", (Throwable)e);
            throw new RuntimeException(e);
        }
        ((CommandSourceStack)stack.getSource()).m_288197_(() -> Component.m_237115_((String)"commands.evenmoreinstruments.emirecord.success.record_saved"), true);
        return 1;
    }

    private static int loadRecordToHand(CommandContext<CommandSourceStack> stack, Player target) throws CommandSyntaxException {
        Optional<ItemStack> record = CommonUtil.getItemInBothHands(target, (Item)ModItems.RECORD_WRITABLE.get());
        if (record.isEmpty()) {
            throw ERROR_NO_ITEM.create((Object)target.m_5446_());
        }
        if (record.get().m_41613_() > 1) {
            throw ERROR_TOO_MANY.create((Object)target.m_5446_());
        }
        if (((WritableRecordItem)record.get().m_41720_()).isBurned(record.get())) {
            throw ERROR_RECORD_ALREADY_BURNED.create((Object)target.m_5446_());
        }
        ResourceLocation recordName = (ResourceLocation)stack.getArgument("record", ResourceLocation.class);
        Optional<CompoundTag> recordChannel = RecordRepository.getRecord(recordName);
        if (recordChannel.isEmpty()) {
            throw ERROR_RECORD_INVALID.create((Object)recordName);
        }
        record.get().m_41784_().m_128359_("BurnedMedia", recordName.toString());
        ((CommandSourceStack)stack.getSource()).m_288197_(() -> Component.m_237115_((String)"commands.evenmoreinstruments.emirecord.success.record_burned"), true);
        return 1;
    }

    private static int removeRecord(CommandContext<CommandSourceStack> stack) throws CommandSyntaxException {
        ResourceLocation name = ResourceLocationArgument.m_107011_(stack, (String)"record");
        if (name.m_135827_().equals("evenmoreinstruments")) {
            throw ERROR_INVALID_NAMESPACE.create((Object)name);
        }
        try {
            RecordRepository.removeRecord(name);
        }
        catch (Exception e) {
            throw ERROR_RECORD_INVALID.create((Object)name);
        }
        ((CommandSourceStack)stack.getSource()).m_288197_(() -> Component.m_237115_((String)"commands.evenmoreinstruments.emirecord.success.record_removed"), true);
        return 1;
    }
}

