/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.evenmoreinstruments.sound;

import com.cstav.genshinstrument.sound.NoteSound;
import com.cstav.genshinstrument.sound.registrar.NoteSoundRegistrar;
import java.util.HashMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class ModSounds {
    public static final DeferredRegister<SoundEvent> SOUNDS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SOUND_EVENTS, (String)"evenmoreinstruments");
    public static final NoteSound[] KEYBOARD;
    public static final NoteSound[] VIOLIN_FULL_NOTE;
    public static final NoteSound[] VIOLIN_HALF_NOTE;
    public static final NoteSound[] TROMBONE;
    public static final NoteSound[] SAXOPHONE;
    public static final NoteSound[] GUITAR;
    public static final NoteSound[] SHAMISEN;
    public static final NoteSound[] KOTO;
    public static final NoteSound[] PIPA_REGULAR;
    public static final NoteSound[] PIPA_TERMOLO;
    private static final HashMap<NoteBlockInstrument, NoteSound> NOTEBLOCK_SOUNDS;

    public static void register(IEventBus bus) {
        SOUNDS.register(bus);
    }

    public static NoteSound[] getNoteblockSounds(NoteBlockInstrument instrumentType) {
        return new NoteSound[]{NOTEBLOCK_SOUNDS.get(instrumentType)};
    }

    private static void registerNoteBlockSounds() {
        NoteSoundRegistrar registrar = ModSounds.nsr(ModSounds.loc("note_block_instrument"));
        for (NoteBlockInstrument noteSound : NoteBlockInstrument.values()) {
            registrar.chain(((SoundEvent)noteSound.m_263188_().get()).m_11660_()).alreadyRegistered().add();
            NOTEBLOCK_SOUNDS.put(noteSound, (NoteSound)registrar.peek());
        }
        registrar.registerAll();
    }

    private static ResourceLocation loc(String id) {
        return new ResourceLocation("evenmoreinstruments", id);
    }

    private static NoteSoundRegistrar nsr(ResourceLocation instrumentId) {
        return new NoteSoundRegistrar(SOUNDS, instrumentId);
    }

    static {
        NOTEBLOCK_SOUNDS = new HashMap();
        ModSounds.registerNoteBlockSounds();
        KEYBOARD = ModSounds.nsr(ModSounds.loc("keyboard")).stereo().registerGrid();
        VIOLIN_FULL_NOTE = ModSounds.nsr(ModSounds.loc("violin_full")).registerGrid();
        VIOLIN_HALF_NOTE = ModSounds.nsr(ModSounds.loc("violin_half")).registerGrid();
        TROMBONE = ModSounds.nsr(ModSounds.loc("trombone")).registerGrid();
        SAXOPHONE = ModSounds.nsr(ModSounds.loc("saxophone")).registerGrid();
        GUITAR = ModSounds.nsr(ModSounds.loc("guitar")).registerGrid();
        SHAMISEN = ModSounds.nsr(ModSounds.loc("shamisen")).stereo().registerGrid();
        KOTO = ModSounds.nsr(ModSounds.loc("koto")).registerGrid();
        PIPA_REGULAR = ModSounds.nsr(ModSounds.loc("pipa_regular")).registerGrid();
        PIPA_TERMOLO = ModSounds.nsr(ModSounds.loc("pipa_tremolo")).registerGrid();
    }
}

