/*
 * Decompiled with CFR 0.152.
 */
package com.pepper.faunify.entity;

import com.pepper.faunify.registry.FaunifySounds;
import java.util.Comparator;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class SilkMothEntity
extends TamableAnimal
implements GeoEntity {
    private final AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private BlockPos targetPosition;

    public SilkMothEntity(EntityType<? extends TamableAnimal> entityType, Level world) {
        super(entityType, world);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        return spawnData;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 1.5).m_22268_(Attributes.f_22279_, 0.25);
    }

    protected void m_8097_() {
        super.m_8097_();
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
    }

    public void m_8119_() {
        super.m_8119_();
        this.m_20256_(this.m_20184_().m_82542_(1.0, 0.6, 1.0));
    }

    protected void m_8024_() {
        super.m_8024_();
        Level level = this.m_9236_();
        if (level.m_46462_()) {
            BlockPos lightSourcePos = this.findHighestPriorityLightSource();
            if (lightSourcePos != null) {
                Vec3 lightCenter = Vec3.m_82512_((Vec3i)lightSourcePos);
                double distanceSq = this.m_20182_().m_82557_(lightCenter);
                if (distanceSq > 4.0) {
                    this.moveTowardsTarget(lightCenter);
                    this.randomMovementAroundTarget(lightSourcePos);
                }
            } else {
                this.randomMovement();
            }
        } else {
            this.randomMovement();
        }
    }

    private BlockPos findHighestPriorityLightSource() {
        Level level = this.m_9236_();
        BlockPos mothPos = this.m_20183_();
        return BlockPos.m_121990_((BlockPos)mothPos.m_7918_(-15, -15, -15), (BlockPos)mothPos.m_7918_(15, 15, 15)).map(BlockPos::m_7949_).filter(pos -> level.m_45517_(LightLayer.BLOCK, pos) >= 10).min(Comparator.comparingInt(pos -> -level.m_45517_(LightLayer.BLOCK, pos)).thenComparingDouble(pos -> pos.m_123331_((Vec3i)mothPos))).orElse(null);
    }

    private void moveTowardsTarget(Vec3 targetPos) {
        double dx = targetPos.f_82479_ - this.m_20185_();
        double dy = targetPos.f_82480_ - this.m_20186_();
        double dz = targetPos.f_82481_ - this.m_20189_();
        double scaleX = 0.1;
        double scaleY = dy > 0.0 ? 0.15 : 0.1;
        double scaleZ = 0.1;
        Vec3 currentMotion = this.m_20184_();
        Vec3 adjustment = new Vec3((Math.signum(dx) * 0.5 - currentMotion.f_82479_) * scaleX, (Math.signum(dy) * 0.7 - currentMotion.f_82480_) * scaleY, (Math.signum(dz) * 0.5 - currentMotion.f_82481_) * scaleZ);
        Vec3 newMotion = currentMotion.m_82549_(adjustment);
        this.m_20256_(newMotion);
        float targetYaw = (float)(Mth.m_14136_((double)newMotion.f_82481_, (double)newMotion.f_82479_) * 57.29577951308232) - 90.0f;
        float yawDifference = Mth.m_14177_((float)(targetYaw - this.m_146908_()));
        this.f_20902_ = 0.5f;
        this.m_146922_(this.m_146908_() + yawDifference);
    }

    private void randomMovementAroundTarget(BlockPos targetBlock) {
        this.targetPosition = targetBlock.m_7918_(this.f_19796_.m_188503_(3) - 1, this.f_19796_.m_188503_(3) - 1, this.f_19796_.m_188503_(3) - 1);
        Vec3 targetPos = Vec3.m_82512_((Vec3i)this.targetPosition);
        this.moveTowardsTarget(targetPos);
    }

    private void randomMovement() {
        if (this.targetPosition == null || this.f_19796_.m_188503_(30) == 0 || this.targetPosition.m_203195_((Position)this.m_20182_(), 2.0)) {
            this.targetPosition = BlockPos.m_274561_((double)(this.m_20185_() + (double)this.f_19796_.m_188503_(7) - (double)this.f_19796_.m_188503_(7)), (double)(this.m_20186_() + (double)this.f_19796_.m_188503_(6) - 2.0), (double)(this.m_20189_() + (double)this.f_19796_.m_188503_(7) - (double)this.f_19796_.m_188503_(7)));
        }
        double dx = (double)this.targetPosition.m_123341_() + 0.5 - this.m_20185_();
        double dy = (double)this.targetPosition.m_123342_() + 0.1 - this.m_20186_();
        double dz = (double)this.targetPosition.m_123343_() + 0.5 - this.m_20189_();
        Vec3 currentMotion = this.m_20184_();
        Vec3 adjustment = currentMotion.m_82520_((Math.signum(dx) * 0.5 - currentMotion.f_82479_) * 0.1, (Math.signum(dy) * 0.7 - currentMotion.f_82480_) * 0.1, (Math.signum(dz) * 0.5 - currentMotion.f_82481_) * 0.1);
        this.m_20256_(adjustment);
        float targetYaw = (float)(Mth.m_14136_((double)adjustment.f_82481_, (double)adjustment.f_82479_) * 57.2957763671875) - 90.0f;
        float yawDifference = Mth.m_14177_((float)(targetYaw - this.m_146908_()));
        this.f_20902_ = 0.5f;
        this.m_146922_(this.m_146908_() + yawDifference);
    }

    protected void m_7840_(double fallDistance, boolean onGround, BlockState state, BlockPos pos) {
    }

    public boolean m_6094_() {
        return false;
    }

    public static boolean canSpawn(EntityType<SilkMothEntity> entityType, LevelAccessor level, MobSpawnType spawnType, BlockPos position, RandomSource random) {
        return Animal.m_218104_(entityType, (LevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)position, (RandomSource)random);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 5, this::predicate)});
    }

    private PlayState predicate(AnimationState<SilkMothEntity> event) {
        if (event.isMoving()) {
            event.getController().setAnimation(RawAnimation.begin().then("fly", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        event.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    protected SoundEvent m_7515_() {
        return null;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)FaunifySounds.SILKMOTH_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)FaunifySounds.SILKMOTH_HURT.get();
    }

    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob otherParent) {
        return null;
    }
}

