/*
 * Decompiled with CFR 0.152.
 */
package cech12.usefulhats.item;

import cech12.usefulhats.client.UsefulHatLayers;
import cech12.usefulhats.compat.CuriosMod;
import cech12.usefulhats.item.AbstractHatItemCurioCapability;
import cech12.usefulhats.item.HatArmorMaterial;
import cech12.usefulhats.item.IUsefulHatModelOwner;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.type.capability.ICurio;

public abstract class AbstractHatItem
extends ArmorItem
implements DyeableLeatherItem {
    private static final boolean IS_CHRISTMAS = Calendar.getInstance().get(2) + 1 == 12;
    private final HatArmorMaterial material;
    private final int initColor;
    protected final ForgeConfigSpec.BooleanValue enabledDamageConfig;
    private final ArrayList<Enchantment> allowedEnchantments = new ArrayList();
    private final ArrayList<Enchantment> forbiddenEnchantments = new ArrayList();

    public AbstractHatItem(HatArmorMaterial material, int initColor, ForgeConfigSpec.BooleanValue enabledDamageConfig) {
        super((ArmorMaterial)material, ArmorItem.Type.HELMET, new Item.Properties());
        this.material = material;
        this.initColor = initColor;
        this.enabledDamageConfig = enabledDamageConfig;
        this.addForbiddenEnchantment(Enchantments.f_44966_);
        this.addForbiddenEnchantment(Enchantments.f_44969_);
        this.addForbiddenEnchantment(Enchantments.f_44968_);
        this.addForbiddenEnchantment(Enchantments.f_44965_);
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        eventBus.addListener(this::setup);
    }

    protected static int rawColorFromRGB(int red, int green, int blue) {
        int rgb = Math.max(Math.min(255, red), 0);
        rgb = (rgb << 8) + Math.max(Math.min(255, green), 0);
        rgb = (rgb << 8) + Math.max(Math.min(255, blue), 0);
        return rgb;
    }

    public int getMaxDamage(ItemStack stack) {
        return this.material.m_266425_(ArmorItem.Type.HELMET);
    }

    protected boolean isEffectCausedByOtherSource(LivingEntity entity, MobEffect effect, int maxDuration, int amplifier) {
        MobEffectInstance effectInstance = entity.m_21124_(effect);
        return effectInstance != null && (effectInstance.m_19571_() || effectInstance.m_19557_() >= maxDuration || effectInstance.m_19564_() != amplifier);
    }

    protected void addEffect(LivingEntity entity, MobEffect effect, int duration, int amplifier) {
        this.addEffect(entity, effect, duration, amplifier, false);
    }

    protected void addEffect(LivingEntity entity, MobEffect effect, int duration, int amplifier, boolean showParticles) {
        entity.m_7292_(new MobEffectInstance(effect, duration, amplifier, false, showParticles, true));
    }

    protected void removeEffect(LivingEntity entity, MobEffect effect, int maxDuration, int amplifier) {
        MobEffectInstance effectInstance = entity.m_21124_(effect);
        if (effectInstance != null && !effectInstance.m_19571_() && effectInstance.m_19557_() <= maxDuration && effectInstance.m_19564_() == amplifier) {
            entity.m_21195_(effect);
        }
    }

    protected void addAllowedEnchantment(Enchantment enchantment) {
        this.forbiddenEnchantments.remove(enchantment);
        this.allowedEnchantments.add(enchantment);
    }

    protected void addForbiddenEnchantment(Enchantment enchantment) {
        this.allowedEnchantments.remove(enchantment);
        this.forbiddenEnchantments.add(enchantment);
    }

    public int m_41121_(ItemStack stack) {
        CompoundTag compoundnbt = stack.m_41737_("display");
        return compoundnbt != null && compoundnbt.m_128425_("color", 99) ? compoundnbt.m_128451_("color") : this.initColor;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        for (Enchantment enchantment : EnchantmentHelper.m_44831_((ItemStack)book).keySet()) {
            if (this.canApplyAtEnchantingTable(stack, enchantment)) continue;
            return false;
        }
        return true;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (this.allowedEnchantments.contains(enchantment)) {
            return true;
        }
        if (this.forbiddenEnchantments.contains(enchantment)) {
            return false;
        }
        if (!(((Boolean)this.enabledDamageConfig.get()).booleanValue() || enchantment != Enchantments.f_44986_ && enchantment != Enchantments.f_44962_)) {
            return false;
        }
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }

    protected void damageHatItemByOne(ItemStack stack, Player entity) {
        if (!((Boolean)this.enabledDamageConfig.get()).booleanValue()) {
            return;
        }
        if (!entity.m_9236_().f_46443_ && !entity.m_150110_().f_35937_ && this.m_41465_() && stack.m_220157_(1, entity.m_217043_(), entity instanceof ServerPlayer ? (ServerPlayer)entity : null)) {
            entity.m_21166_(EquipmentSlot.HEAD);
            stack.m_41774_(1);
            entity.m_36246_(Stats.f_12983_.m_12902_((Object)this));
            stack.m_41721_(0);
        }
    }

    @Deprecated
    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        return 0;
    }

    @Nonnull
    public Multimap<Attribute, AttributeModifier> m_7167_(@Nonnull EquipmentSlot equipmentSlot) {
        return HashMultimap.create();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level worldIn, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)("item.modifiers." + EquipmentSlot.HEAD.m_20751_())).m_130940_(ChatFormatting.GRAY));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(@Nonnull Consumer<IClientItemExtensions> consumer) {
        if (this instanceof IUsefulHatModelOwner) {
            consumer.accept(Rendering.INSTANCE);
        }
    }

    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        ResourceLocation resourceLocation;
        if (this instanceof IUsefulHatModelOwner && (resourceLocation = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_())) != null) {
            String texture = resourceLocation.m_135815_();
            String domain = resourceLocation.m_135827_();
            return String.format("%s:textures/models/usefulhats/%s%s%s.png", domain, texture, IS_CHRISTMAS && ((IUsefulHatModelOwner)stack.m_41720_()).hasChristmasVariant() ? "_xmas" : "", type == null ? "" : String.format("_%s", type));
        }
        return super.getArmorTexture(stack, entity, slot, type);
    }

    private void setup(FMLCommonSetupEvent evt) {
        MinecraftForge.EVENT_BUS.addGenericListener(ItemStack.class, this::attachCapabilities);
    }

    private void attachCapabilities(AttachCapabilitiesEvent<ItemStack> evt) {
        ItemStack stack = (ItemStack)evt.getObject();
        if (stack.m_41720_() != this) {
            return;
        }
        if (CuriosMod.isLoaded()) {
            final AbstractHatItemCurioCapability cap = new AbstractHatItemCurioCapability(stack);
            evt.addCapability(CuriosCapability.ID_ITEM, new ICapabilityProvider(){
                final LazyOptional<ICurio> curio = LazyOptional.of(() -> cap);

                @Nonnull
                public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap2, @Nullable Direction side) {
                    return CuriosCapability.ITEM.orEmpty(cap2, this.curio);
                }
            });
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static final class Rendering
    implements IClientItemExtensions {
        private static final Rendering INSTANCE = new Rendering();

        private Rendering() {
        }

        @Nonnull
        public HumanoidModel<?> getHumanoidArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
            return UsefulHatLayers.usefulHatModel;
        }
    }
}

