/*
 * Decompiled with CFR 0.152.
 */
package cech12.usefulhats.item;

import cech12.usefulhats.UsefulHatsUtils;
import cech12.usefulhats.config.ServerConfig;
import cech12.usefulhats.item.AbstractHatItem;
import cech12.usefulhats.item.HatArmorMaterial;
import cech12.usefulhats.item.IEquipmentChangeListener;
import cech12.usefulhats.item.IGameOverlayRenderer;
import cech12.usefulhats.item.IUsefulHatModelOwner;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fluids.FluidType;

public class AquanautHelmetItem
extends AbstractHatItem
implements IEquipmentChangeListener,
IUsefulHatModelOwner,
IGameOverlayRenderer {
    private static final ResourceLocation AQUANAUT_GUI_TEX_PATH = new ResourceLocation("usefulhats", "textures/misc/aquanautblur.png");

    public AquanautHelmetItem() {
        super(HatArmorMaterial.AQUANAUT, AquanautHelmetItem.rawColorFromRGB(71, 191, 74), ServerConfig.AQUANAUT_HELMET_DAMAGE_ENABLED);
    }

    private int getEffectTimeConfig(int enchantmentLevel) {
        if (enchantmentLevel <= 0) {
            return (Integer)ServerConfig.AQUANAUT_HELMET_EFFECT_TIME_WITH_RESPIRATION_0.get();
        }
        return switch (enchantmentLevel) {
            case 1 -> (Integer)ServerConfig.AQUANAUT_HELMET_EFFECT_TIME_WITH_RESPIRATION_1.get();
            case 2 -> (Integer)ServerConfig.AQUANAUT_HELMET_EFFECT_TIME_WITH_RESPIRATION_2.get();
            default -> (Integer)ServerConfig.AQUANAUT_HELMET_EFFECT_TIME_WITH_RESPIRATION_3.get();
        };
    }

    private int getConduitPowerDuration(ItemStack stack) {
        return this.getEffectTimeConfig(EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.f_44970_, (ItemStack)stack)) * 20;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level worldIn, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        int effectTime = this.getEffectTimeConfig(EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.f_44970_, (ItemStack)stack));
        tooltip.add((Component)Component.m_237110_((String)"item.usefulhats.aquanaut_helmet.desc.conduit_power", (Object[])new Object[]{effectTime}).m_130940_(ChatFormatting.BLUE));
    }

    public void onArmorTick(ItemStack stack, Level level, Player player) {
        if (!level.f_46443_) {
            if (!UsefulHatsUtils.getEquippedHatItemStacks((LivingEntity)player).contains(stack)) {
                return;
            }
            int maxDuration = this.getConduitPowerDuration(stack);
            if (this.isEffectCausedByOtherSource((LivingEntity)player, MobEffects.f_19592_, maxDuration, 0)) {
                return;
            }
            if (!player.isEyeInFluidType((FluidType)ForgeMod.WATER_TYPE.get())) {
                this.addEffect((LivingEntity)player, MobEffects.f_19592_, maxDuration, 0);
            } else if (player.m_21124_(MobEffects.f_19592_) != null && level.f_46441_.m_188503_(20) == 0) {
                this.damageHatItemByOne(stack, player);
            }
        }
    }

    @Override
    public void onUnequippedHatItem(LivingEntity entity, ItemStack oldStack) {
        this.removeEffect(entity, MobEffects.f_19592_, this.getConduitPowerDuration(oldStack), 0);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onRenderGameOverlay(int width, int height, float partialTicks) {
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)AQUANAUT_GUI_TEX_PATH);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferbuilder.m_5483_(0.0, (double)height, -90.0).m_7421_(0.0f, 1.0f).m_5752_();
        bufferbuilder.m_5483_((double)width, (double)height, -90.0).m_7421_(1.0f, 1.0f).m_5752_();
        bufferbuilder.m_5483_((double)width, 0.0, -90.0).m_7421_(1.0f, 0.0f).m_5752_();
        bufferbuilder.m_5483_(0.0, 0.0, -90.0).m_7421_(0.0f, 0.0f).m_5752_();
        tesselator.m_85914_();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

