/*
 * Decompiled with CFR 0.152.
 */
package cech12.usefulhats.item;

import cech12.usefulhats.UsefulHatsUtils;
import cech12.usefulhats.config.ServerConfig;
import cech12.usefulhats.item.AbstractHatItem;
import cech12.usefulhats.item.HatArmorMaterial;
import cech12.usefulhats.item.IRightClickListener;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

public class EnderHelmetItem
extends AbstractHatItem
implements IRightClickListener {
    public static final String TELEPORT_POSITION_ID = "TeleportPosition";

    public EnderHelmetItem() {
        super(HatArmorMaterial.ENDER, EnderHelmetItem.rawColorFromRGB(43, 203, 175), ServerConfig.ENDER_HELMET_DAMAGE_ENABLED);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level worldIn, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flagIn) {
        tooltip.add((Component)Component.m_237115_((String)"item.usefulhats.ender_helmet.desc.define_teleport").m_130940_(ChatFormatting.BLUE));
        if (EnderHelmetItem.hasPosition(stack)) {
            super.m_7373_(stack, worldIn, tooltip, flagIn);
            BlockPos pos = EnderHelmetItem.getPosition(stack);
            tooltip.add((Component)Component.m_237115_((String)"item.usefulhats.ender_helmet.desc.teleport").m_130940_(ChatFormatting.BLUE));
            tooltip.add((Component)Component.m_237110_((String)"item.usefulhats.ender_helmet.desc.teleport_position", (Object[])new Object[]{pos.m_123341_(), pos.m_123342_(), pos.m_123343_()}).m_130940_(ChatFormatting.BLUE));
            tooltip.add((Component)Component.m_237113_((String)this.getDimensionString(stack)).m_130940_(ChatFormatting.BLUE));
        }
    }

    private static void setPosition(@Nonnull ItemStack stack, @Nonnull Level level, @Nonnull Player player) {
        CompoundTag nbt = stack.m_41784_().m_6426_();
        CompoundTag positionNBT = new CompoundTag();
        BlockPos pos = player.m_20183_();
        positionNBT.m_128405_("X", pos.m_123341_());
        positionNBT.m_128405_("Y", pos.m_123342_());
        positionNBT.m_128405_("Z", pos.m_123343_());
        positionNBT.m_128359_("dimKey", level.m_46472_().m_211136_().toString());
        positionNBT.m_128359_("dimName", level.m_46472_().m_135782_().toString());
        nbt.m_128365_(TELEPORT_POSITION_ID, (Tag)positionNBT);
        stack.m_41751_(nbt);
    }

    private static boolean hasPosition(@Nonnull ItemStack stack) {
        return stack.m_41784_().m_128441_(TELEPORT_POSITION_ID);
    }

    private static BlockPos getPosition(@Nonnull ItemStack stack) {
        if (EnderHelmetItem.hasPosition(stack)) {
            CompoundTag nbt = stack.m_41784_();
            CompoundTag positionNBT = nbt.m_128469_(TELEPORT_POSITION_ID);
            return new BlockPos(positionNBT.m_128451_("X"), positionNBT.m_128451_("Y"), positionNBT.m_128451_("Z"));
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    private String getDimensionString(@Nonnull ItemStack stack) {
        if (EnderHelmetItem.hasPosition(stack)) {
            return stack.m_41784_().m_128469_(TELEPORT_POSITION_ID).m_128461_("dimName");
        }
        return "?";
    }

    private static boolean equalsWorldAndNBT(Level world, CompoundTag positionNBT) {
        return (!positionNBT.m_128441_("dimKey") || world.m_46472_().m_211136_().toString().equals(positionNBT.m_128461_("dimKey"))) && world.m_46472_().m_135782_().toString().equals(positionNBT.m_128461_("dimName"));
    }

    private ServerLevel getLevel(@Nonnull MinecraftServer server, @Nonnull ItemStack stack) {
        if (EnderHelmetItem.hasPosition(stack)) {
            CompoundTag positionNBT = stack.m_41784_().m_128469_(TELEPORT_POSITION_ID);
            for (ServerLevel world : server.m_129785_()) {
                if (!EnderHelmetItem.equalsWorldAndNBT((Level)world, positionNBT)) continue;
                return world;
            }
        }
        return null;
    }

    private static boolean isRightDimension(@Nonnull Level world, @Nonnull ItemStack stack) {
        CompoundTag nbt = stack.m_41784_();
        if (EnderHelmetItem.hasPosition(stack)) {
            CompoundTag positionNBT = nbt.m_128469_(TELEPORT_POSITION_ID);
            return EnderHelmetItem.equalsWorldAndNBT(world, positionNBT);
        }
        return false;
    }

    private static boolean canTeleportToPosition(@Nonnull Level world, @Nonnull BlockPos pos) {
        return !world.m_8055_(pos).m_60815_() && !world.m_8055_(pos.m_7494_()).m_60815_();
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(@Nonnull Level worldIn, @Nonnull Player playerIn, @Nonnull InteractionHand handIn) {
        ItemStack stack = playerIn.m_21120_(handIn);
        if (playerIn.m_6144_() && !stack.m_41619_()) {
            if (!worldIn.f_46443_) {
                EnderHelmetItem.setPosition(stack, worldIn, playerIn);
                ((ServerPlayer)playerIn).f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket((Component)Component.m_237115_((String)"item.usefulhats.ender_helmet.message.position_saved")));
            }
            return InteractionResultHolder.m_19092_((Object)stack, (boolean)worldIn.m_5776_());
        }
        return super.m_7203_(worldIn, playerIn, handIn);
    }

    @Override
    public void onRightClickItemEvent(PlayerInteractEvent.RightClickItem event, ItemStack headSlotItemStack) {
        Player player = event.getEntity();
        if (!UsefulHatsUtils.getEquippedHatItemStacks((LivingEntity)player).contains(headSlotItemStack)) {
            return;
        }
        Level world = event.getLevel();
        ItemStack usedStack = event.getItemStack();
        if (usedStack.m_41720_() == Items.f_42584_ && EnderHelmetItem.hasPosition(headSlotItemStack)) {
            player.m_6674_(event.getHand());
            if (!world.f_46443_) {
                if (((Boolean)ServerConfig.ENDER_HELMET_INTERDIMENSIONAL_ENABLED.get()).booleanValue() || EnderHelmetItem.isRightDimension(world, headSlotItemStack)) {
                    ServerLevel destinationWorld = this.getLevel(player.m_20194_(), headSlotItemStack);
                    BlockPos destinationPos = EnderHelmetItem.getPosition(headSlotItemStack);
                    if (destinationPos != null && destinationWorld != null && EnderHelmetItem.canTeleportToPosition((Level)destinationWorld, destinationPos)) {
                        player.m_36335_().m_41524_(usedStack.m_41720_(), 20);
                        player.f_19789_ = 0.0f;
                        player.m_6330_(SoundEvents.f_11852_, SoundSource.PLAYERS, 1.0f, 1.0f);
                        if (player.m_9236_() != destinationWorld) {
                            ((ServerPlayer)player).m_8999_(destinationWorld, (double)destinationPos.m_123341_() + 0.5, (double)destinationPos.m_123342_(), (double)destinationPos.m_123343_() + 0.5, player.f_19859_, player.f_19860_);
                        } else {
                            player.m_6021_((double)destinationPos.m_123341_() + 0.5, (double)destinationPos.m_123342_(), (double)destinationPos.m_123343_() + 0.5);
                        }
                        player.m_6330_(SoundEvents.f_11852_, SoundSource.PLAYERS, 1.0f, 1.0f);
                        player.m_36246_(Stats.f_12982_.m_12902_((Object)usedStack.m_41720_()));
                        if (!player.m_150110_().f_35937_) {
                            usedStack.m_41774_(1);
                        }
                        this.damageHatItemByOne(headSlotItemStack, player);
                    } else {
                        ((ServerPlayer)player).f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket((Component)Component.m_237115_((String)"item.usefulhats.ender_helmet.message.position_obstructed")));
                    }
                } else {
                    ((ServerPlayer)player).f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket((Component)Component.m_237115_((String)"item.usefulhats.ender_helmet.message.wrong_dimension")));
                }
            }
            event.setCanceled(true);
        }
    }
}

