/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.playercompanions.block;

import de.markusbordihn.playercompanions.block.ModBlocks;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class LightBlock
extends Block {
    public static final BooleanProperty EXTENDED = BlockStateProperties.f_61432_;
    public static final IntegerProperty AGE = BlockStateProperties.f_61410_;
    public static final int TICK_TTL = 30;
    public static final int UPDATE_TICK_TTL = 20;
    public static final int VERIFY_TICK_TTL = 100;
    protected static final VoxelShape SHAPE_AABB = Block.m_49796_((double)7.5, (double)7.5, (double)7.5, (double)8.5, (double)8.5, (double)8.5);

    public LightBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0))).m_61124_((Property)EXTENDED, (Comparable)Boolean.valueOf(false)));
    }

    public static int getLightLevel(BlockState blockState) {
        int age = (Integer)blockState.m_61143_((Property)AGE);
        return Math.min(Math.max(15 - age, 0), 15);
    }

    public static void place(Level level, BlockPos blockPos) {
        if (level.f_46443_) {
            return;
        }
        BlockState blockState = level.m_8055_(blockPos);
        if (!blockState.m_60795_() && !(blockState.m_60734_() instanceof LightBlock)) {
            blockPos = blockPos.m_7494_();
            blockState = level.m_8055_(blockPos);
        }
        if (!blockState.m_60795_() && !(blockState.m_60734_() instanceof LightBlock)) {
            if (LightBlock.canPlace(level, blockPos.m_7494_())) {
                blockPos = blockPos.m_7494_();
            } else if (LightBlock.canPlace(level, blockPos.m_122012_())) {
                blockPos = blockPos.m_122012_();
            } else if (LightBlock.canPlace(level, blockPos.m_122029_())) {
                blockPos = blockPos.m_122029_();
            } else if (LightBlock.canPlace(level, blockPos.m_122019_())) {
                blockPos = blockPos.m_122019_();
            } else if (LightBlock.canPlace(level, blockPos.m_122024_())) {
                blockPos = blockPos.m_122024_();
            }
        }
        if ((blockState = level.m_8055_(blockPos)).m_60795_()) {
            level.m_7731_(blockPos, ((Block)ModBlocks.LIGHT_BLOCK.get()).m_49966_(), 3);
            Block block = level.m_8055_(blockPos).m_60734_();
            if (block instanceof LightBlock) {
                LightBlock lightBlock = (LightBlock)block;
                lightBlock.scheduleTick(level, blockPos);
            }
        } else {
            Block block = blockState.m_60734_();
            if (block instanceof LightBlock) {
                LightBlock lightBlock = (LightBlock)block;
                lightBlock.rescheduleTick(level, blockState, blockPos);
            }
        }
    }

    private static boolean canPlace(Level level, BlockPos blockPos) {
        BlockState blockState = level.m_8055_(blockPos);
        return blockState.m_60795_() || blockState.m_60734_() instanceof LightBlock;
    }

    public void rescheduleTick(Level level, BlockState blockState, BlockPos blockPos) {
        if (level.m_183326_().m_183582_(blockPos, (Object)this) && Boolean.FALSE.equals(blockState.m_61143_((Property)EXTENDED))) {
            level.m_7731_(blockPos, (BlockState)((BlockState)blockState.m_61124_((Property)EXTENDED, (Comparable)Boolean.valueOf(true))).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0)), 3);
        }
    }

    public void scheduleTick(Level level, BlockPos blockPos) {
        if (!level.m_183326_().m_183582_(blockPos, (Object)this)) {
            level.m_186460_(blockPos, (Block)this, 30);
        }
    }

    public void scheduleUpdateTick(Level level, BlockPos blockPos) {
        if (!level.m_183326_().m_183582_(blockPos, (Object)this)) {
            level.m_186460_(blockPos, (Block)this, 20);
        }
    }

    public void scheduleVerifyTick(Level level, BlockPos blockPos) {
        if (!level.m_183326_().m_183582_(blockPos, (Object)this)) {
            level.m_186460_(blockPos, (Block)this, 100);
        }
    }

    @Deprecated
    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return SHAPE_AABB;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> blockState) {
        blockState.m_61104_(new Property[]{AGE, EXTENDED});
    }

    public void m_6402_(Level level, BlockPos blockPos, BlockState blockState, @Nullable LivingEntity placer, ItemStack itemStack) {
        this.scheduleTick(level, blockPos);
    }

    @Deprecated
    public void m_213897_(BlockState blockState, ServerLevel level, BlockPos blockPos, RandomSource random) {
        if (level.f_46443_) {
            return;
        }
        Block block = blockState.m_60734_();
        if (!(block instanceof LightBlock)) {
            return;
        }
        if (Boolean.TRUE.equals(blockState.m_61143_((Property)EXTENDED))) {
            level.m_7731_(blockPos, (BlockState)blockState.m_61124_((Property)EXTENDED, (Comparable)Boolean.valueOf(false)), 3);
            this.scheduleTick((Level)level, blockPos);
        } else {
            int age = (Integer)blockState.m_61143_((Property)AGE);
            if (age >= 15) {
                level.m_7471_(blockPos, true);
            } else {
                level.m_7731_(blockPos, (BlockState)blockState.m_61124_((Property)AGE, (Comparable)Integer.valueOf(age + 1)), 3);
                this.scheduleUpdateTick((Level)level, blockPos);
            }
        }
    }

    @Deprecated
    public void m_213898_(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource random) {
        int age = (Integer)blockState.m_61143_((Property)AGE);
        if (age <= 15 && !serverLevel.m_183326_().m_183582_(blockPos, (Object)this)) {
            this.scheduleVerifyTick((Level)serverLevel, blockPos);
        }
    }
}

