/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.playercompanions.client.model;

import de.markusbordihn.playercompanions.client.model.PlayerCompanionModel;
import java.util.List;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DobutsuModel<T extends TamableAnimal>
extends AgeableListModel<T>
implements PlayerCompanionModel {
    private final ModelPart head;
    private final ModelPart leftHand;
    private final ModelPart leftLeg;
    private final ModelPart rightHand;
    private final ModelPart rightLeg;

    public DobutsuModel(ModelPart modelPart) {
        this.head = modelPart.m_171324_("head");
        this.leftLeg = modelPart.m_171324_("left_leg");
        this.leftHand = modelPart.m_171324_("left_hand");
        this.rightHand = modelPart.m_171324_("right_hand");
        this.rightLeg = modelPart.m_171324_("right_leg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.m_171576_();
        partDefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.85f)).m_171514_(32, 0).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(1.1f)), PartPose.m_171419_((float)0.0f, (float)15.0f, (float)0.0f));
        partDefinition.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(16, 48).m_171488_(-2.0f, 4.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(0, 48).m_171488_(-2.0f, 4.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.25f)), PartPose.m_171419_((float)1.9f, (float)8.0f, (float)0.0f));
        partDefinition.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-2.0f, 4.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(0, 32).m_171488_(-2.0f, 4.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.25f)), PartPose.m_171419_((float)-1.9f, (float)8.0f, (float)0.0f));
        partDefinition.m_171599_("right_hand", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)-4.5f, (float)16.0f, (float)0.0f, (float)-120.0f, (float)180.0f, (float)0.0f));
        partDefinition.m_171599_("left_hand", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)4.5f, (float)16.0f, (float)0.0f, (float)-120.0f, (float)180.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshDefinition, (int)64, (int)64);
    }

    protected Iterable<ModelPart> m_5607_() {
        return List.of(this.head);
    }

    protected Iterable<ModelPart> m_5608_() {
        return List.of(this.rightLeg, this.leftLeg);
    }

    @Override
    public ModelPart rightHand() {
        return this.rightHand;
    }

    @Override
    public ModelPart leftHand() {
        return this.leftHand;
    }

    public void prepareMobModel(T entity, float limbSwing, float limbSwingAmount, float ageInTicks) {
        if (entity.m_21825_()) {
            if (this.f_102610_) {
                this.head.m_104227_(0.0f, 16.1f, 0.0f);
            } else {
                this.head.m_104227_(0.0f, 19.1f, 0.0f);
            }
            this.leftLeg.m_104227_(1.9f, 21.8f, 6.0f);
            this.leftLeg.f_104203_ = -1.58f;
            this.leftLeg.f_104204_ = -0.1f;
            this.rightLeg.m_104227_(-1.9f, 21.8f, 6.0f);
            this.rightLeg.f_104203_ = -1.58f;
            this.rightLeg.f_104204_ = 0.1f;
        } else {
            if (this.f_102610_) {
                this.head.m_104227_(0.0f, 14.0f, 0.0f);
                this.rightLeg.m_104227_(-1.9f, 8.0f, 4.0f);
                this.leftLeg.m_104227_(1.9f, 8.0f, 4.0f);
            } else {
                this.head.m_104227_(0.0f, 15.0f, 0.0f);
                this.rightLeg.m_104227_(-1.9f, 8.0f, 0.0f);
                this.leftLeg.m_104227_(1.9f, 8.0f, 0.0f);
            }
            this.leftLeg.f_104204_ = 0.0f;
            this.leftLeg.f_104203_ = 0.0f;
            this.rightLeg.f_104203_ = 0.0f;
            this.rightLeg.f_104204_ = 0.0f;
        }
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (entity.m_21224_()) {
            return;
        }
        if (!entity.m_21825_()) {
            float limbSwingAmountFraction = 1.4f * limbSwingAmount * 0.3f;
            this.head.f_104203_ = headPitch * 0.013962635f;
            this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
            this.rightLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * limbSwingAmountFraction;
            this.leftLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * limbSwingAmountFraction;
        }
    }
}

