/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.playercompanions.client.model;

import java.util.List;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class FireflyModel<T extends TamableAnimal>
extends AgeableListModel<T> {
    protected static final Logger log = LogManager.getLogger((String)"Bo's Player Companions");
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart rightWing;
    private final ModelPart leftWing;
    private final ModelPart frontLeg;
    private final ModelPart backLeg;

    public FireflyModel(ModelPart modelPart) {
        super(false, 24.0f, 0.0f);
        this.head = modelPart.m_171324_("head");
        this.body = modelPart.m_171324_("body");
        this.rightWing = modelPart.m_171324_("right_wing");
        this.leftWing = modelPart.m_171324_("left_wing");
        this.frontLeg = modelPart.m_171324_("front_leg");
        this.backLeg = modelPart.m_171324_("back_leg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.m_171576_();
        PartDefinition head = partDefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 14).m_171488_(-2.0f, -2.0019f, -3.9135f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.1f)), PartPose.m_171419_((float)0.0f, (float)20.0019f, (float)-3.0865f));
        head.m_171599_("antenna_right", CubeListBuilder.m_171558_().m_171514_(0, 2).m_171480_().m_171488_(0.0f, -1.5f, -1.0f, 0.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)1.975f, (float)-2.9991f, (float)-2.4182f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        head.m_171599_("antenna_left", CubeListBuilder.m_171558_().m_171514_(0, 2).m_171488_(0.0f, -1.5f, -1.0f, 0.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-1.975f, (float)-2.9991f, (float)-2.4182f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        partDefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-2.5f, -1.0f, -3.0f, 4.0f, 4.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.5f, (float)19.0f, (float)0.0f));
        partDefinition.m_171599_("right_wing", CubeListBuilder.m_171558_().m_171514_(12, 0).m_171488_(-8.5f, 2.998f, 0.5f, 9.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-1.0f, (float)15.0f, (float)-3.0f));
        partDefinition.m_171599_("left_wing", CubeListBuilder.m_171558_().m_171514_(12, 0).m_171480_().m_171488_(-1.5f, 2.998f, 0.5f, 9.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)2.0f, (float)15.0f, (float)-3.0f));
        partDefinition.m_171599_("front_leg", CubeListBuilder.m_171558_().m_171514_(0, 2).m_171488_(-4.0f, 0.0f, 0.0f, 4.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.0f, (float)22.0f, (float)-2.0f));
        partDefinition.m_171599_("back_leg", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, 0.0f, 1.0f, 4.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.0f, (float)22.0f, (float)2.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshDefinition, (int)64, (int)64);
    }

    protected Iterable<ModelPart> m_5607_() {
        return List.of(this.head);
    }

    protected Iterable<ModelPart> m_5608_() {
        return List.of(this.body, this.frontLeg, this.backLeg, this.leftWing, this.rightWing);
    }

    public void prepareMobModel(T entity, float limbSwing, float limbSwingAmount, float ageInTicks) {
        if (entity.m_21825_() || entity.m_20096_() && entity.m_20184_().m_82556_() < 1.0E-7) {
            this.body.f_104203_ = 0.0f;
            this.head.m_104227_(0.0f, 20.0019f, -3.0865f);
            this.frontLeg.m_104227_(2.0f, 22.0f, -2.0f);
            this.backLeg.m_104227_(2.0f, 22.0f, 2.0f);
        } else {
            this.body.f_104203_ = -0.8f;
            this.head.m_104227_(0.0f, 16.0019f, -2.0865f);
            this.frontLeg.m_104227_(2.0f, 19.5f, -3.5f);
            this.backLeg.m_104227_(2.0f, 23.0f, -1.0f);
        }
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (entity.m_21224_()) {
            return;
        }
        if (entity.m_20096_() && entity.m_20184_().m_82556_() < 1.0E-7 || entity.m_21825_()) {
            this.rightWing.m_104227_(-1.0f, 15.001f, -3.0f);
            this.rightWing.f_104203_ = 0.0f;
            this.rightWing.f_104204_ = 0.8f;
            this.rightWing.f_104205_ = 0.0f;
            this.leftWing.m_104227_(2.0f, 15.0f, -3.0f);
            this.leftWing.f_104203_ = 0.0f;
            this.leftWing.f_104204_ = -this.rightWing.f_104204_;
            this.leftWing.f_104205_ = 0.0f;
        } else {
            float f = ageInTicks * 120.32113f * ((float)Math.PI / 180);
            this.rightWing.m_104227_(-1.0f, 14.0f, 1.0f);
            this.rightWing.f_104203_ = -0.8f;
            this.rightWing.f_104204_ = 0.3f;
            this.rightWing.f_104205_ = Mth.m_14089_((float)f) * (float)Math.PI * 0.15f;
            this.leftWing.m_104227_(2.0f, 14.0f, 1.0f);
            this.leftWing.f_104203_ = this.rightWing.f_104203_;
            this.leftWing.f_104204_ = -this.rightWing.f_104204_;
            this.leftWing.f_104205_ = -this.rightWing.f_104205_;
        }
        this.head.f_104203_ = headPitch * 0.013962635f;
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
    }
}

