/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.playercompanions.client.model;

import java.util.List;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class LizardModel<T extends TamableAnimal>
extends AgeableListModel<T> {
    public final ModelPart head;
    private final ModelPart body;
    private final ModelPart leftFrontLeg;
    private final ModelPart leftHindLeg;
    private final ModelPart rightFrontLeg;
    private final ModelPart rightHindLeg;
    private final ModelPart tail;
    private final ModelPart tongue;

    public LizardModel(ModelPart modelPart) {
        this.body = modelPart.m_171324_("body");
        this.head = modelPart.m_171324_("head");
        this.leftFrontLeg = modelPart.m_171324_("left_front_leg");
        this.leftHindLeg = modelPart.m_171324_("left_hind_leg");
        this.rightFrontLeg = modelPart.m_171324_("right_front_leg");
        this.rightHindLeg = modelPart.m_171324_("right_hind_leg");
        this.tail = this.body.m_171324_("tail");
        this.tongue = this.head.m_171324_("tongue");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.m_171576_();
        PartDefinition body = partDefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-1.5f, 4.0f, -4.0f, 3.0f, 2.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)16.0f, (float)0.0f));
        body.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(10, 12).m_171488_(-1.0f, -0.25f, -0.75f, 2.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-0.5f, -0.25f, 3.25f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)4.75f, (float)3.0f));
        PartDefinition head = partDefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 9).m_171488_(-1.5f, 2.0f, -5.0f, 3.0f, 3.0f, 4.0f, new CubeDeformation(0.01f)), PartPose.m_171419_((float)0.0f, (float)16.0f, (float)-2.0f));
        head.m_171599_("tongue", CubeListBuilder.m_171558_().m_171514_(2, 0).m_171488_(-0.5f, -3.5f, -8.0f, 1.0f, 0.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)8.0f, (float)2.0f));
        PartDefinition trill = head.m_171599_("trill", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        trill.m_171599_("trill_r1", CubeListBuilder.m_171558_().m_171514_(0, 3).m_171488_(-1.5f, -1.0f, 0.0f, 3.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)2.5f, (float)4.0f, (float)-0.984f, (float)3.1416f, (float)0.0f, (float)0.3927f));
        trill.m_171599_("trill_r2", CubeListBuilder.m_171558_().m_171514_(0, 3).m_171488_(-1.5f, -1.0f, 0.0f, 3.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)2.6531f, (float)2.3696f, (float)-0.985f, (float)0.0f, (float)0.0f, (float)-0.3927f));
        trill.m_171599_("trill_r3", CubeListBuilder.m_171558_().m_171514_(0, 3).m_171488_(-1.5f, -1.0f, 0.0f, 3.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-2.6435f, (float)2.3465f, (float)-0.984f, (float)0.0f, (float)3.1416f, (float)0.3927f));
        trill.m_171599_("trill_r4", CubeListBuilder.m_171558_().m_171514_(0, 3).m_171488_(-1.5f, -1.0f, 0.0f, 3.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-2.5f, (float)4.0f, (float)-0.985f, (float)3.1416f, (float)3.1416f, (float)-0.3927f));
        partDefinition.m_171599_("right_hind_leg", CubeListBuilder.m_171558_().m_171514_(0, 9).m_171488_(1.5f, 4.0f, -4.0f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-3.0f, (float)18.0f, (float)6.0f));
        partDefinition.m_171599_("left_hind_leg", CubeListBuilder.m_171558_().m_171514_(0, 9).m_171488_(-0.5f, 4.0f, -4.0f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.0f, (float)18.0f, (float)6.0f));
        partDefinition.m_171599_("right_front_leg", CubeListBuilder.m_171558_().m_171514_(0, 9).m_171488_(1.5f, 4.0f, -3.0f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-3.0f, (float)18.0f, (float)-1.0f));
        partDefinition.m_171599_("left_front_leg", CubeListBuilder.m_171558_().m_171514_(0, 9).m_171488_(-0.5f, 4.0f, -3.0f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.0f, (float)18.0f, (float)-1.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshDefinition, (int)32, (int)32);
    }

    protected Iterable<ModelPart> m_5607_() {
        return List.of(this.head);
    }

    protected Iterable<ModelPart> m_5608_() {
        return List.of(this.body, this.leftFrontLeg, this.leftHindLeg, this.rightFrontLeg, this.rightHindLeg);
    }

    public void prepareMobModel(T entity, float limbSwing, float limbSwingAmount, float ageInTicks) {
        if (this.f_102610_) {
            this.head.m_104227_(0.0f, 12.5f, -2.0f);
        } else {
            this.head.m_104227_(0.0f, 16.0f, -2.0f);
        }
        if (entity.m_21825_()) {
            this.body.f_104203_ = -0.31415927f;
            this.body.m_104227_(0.0f, 17.1f, 1.5f);
            this.tail.f_104203_ = 0.0f;
            this.tongue.f_104207_ = true;
        } else {
            this.body.f_104203_ = 0.0f;
            this.body.m_104227_(0.0f, 16.0f, 0.0f);
            this.tail.f_104203_ = 0.0f;
            this.tongue.f_104207_ = false;
        }
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (entity.m_21224_()) {
            return;
        }
        if (!entity.m_21825_()) {
            this.head.f_104203_ = headPitch * 0.014959966f;
            this.head.f_104204_ = netHeadYaw * 0.014959966f;
            this.tail.f_104204_ = -netHeadYaw * 0.014279967f;
            this.rightHindLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 1.333f)) * 0.3f * limbSwingAmount;
            this.leftHindLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 1.333f + (float)Math.PI)) * 0.3f * limbSwingAmount;
            this.leftFrontLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 1.333f)) * 0.3f * limbSwingAmount;
            this.rightFrontLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 1.333f + (float)Math.PI)) * 0.3f * limbSwingAmount;
        }
    }
}

