/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.playercompanions.client.model;

import com.google.common.collect.Iterables;
import java.util.List;
import net.minecraft.client.model.QuadrupedModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PigModel<T extends TamableAnimal>
extends QuadrupedModel<T> {
    private final ModelPart bags;

    public PigModel(ModelPart modelPart) {
        super(modelPart, false, 4.0f, 4.0f, 2.0f, 2.0f, 24);
        this.bags = modelPart.m_171324_("bags");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.m_171576_();
        PartDefinition body = partDefinition.m_171599_("body", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)11.0f, (float)2.0f));
        body.m_171599_("body_main", CubeListBuilder.m_171558_().m_171514_(26, 8).m_171488_(-5.0f, -10.0f, -7.0f, 10.0f, 16.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition bags = partDefinition.m_171599_("bags", CubeListBuilder.m_171558_().m_171514_(6, 20).m_171488_(5.0f, -14.0f, -3.0f, 2.0f, 9.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(26, 32).m_171488_(-6.0f, -14.5f, -1.0f, 12.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(26, 32).m_171488_(-6.0f, -14.5f, -1.0f, 12.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        bags.m_171599_("right_bag", CubeListBuilder.m_171558_().m_171514_(6, 20).m_171488_(-1.0f, -4.5f, -4.0f, 2.0f, 9.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-6.0f, (float)-9.5f, (float)1.0f, (float)0.0f, (float)3.1416f, (float)0.0f));
        PartDefinition head = partDefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -4.0f, -8.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(16, 16).m_171488_(-2.0f, 0.0f, -9.0f, 4.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)12.0f, (float)-6.0f));
        head.m_171599_("eyebrown_right", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-1.025f, -0.5f, -0.5f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)2.975f, (float)-1.975f, (float)-8.0f, (float)0.0f, (float)0.0f, (float)-0.0873f));
        head.m_171599_("eyebrown_left", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-1.9f, 0.025f, -0.5f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-2.0f, (float)-2.5f, (float)-8.0f, (float)0.0f, (float)0.0f, (float)0.0873f));
        partDefinition.m_171599_("right_front_leg", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-1.998f, -1.0f, -2.0f, 3.0f, 7.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-3.0f, (float)18.0f, (float)-5.0f));
        partDefinition.m_171599_("left_front_leg", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171480_().m_171488_(-0.998f, -1.0f, -2.0f, 3.0f, 7.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)3.0f, (float)18.0f, (float)-5.0f));
        partDefinition.m_171599_("right_hind_leg", CubeListBuilder.m_171558_().m_171514_(0, 17).m_171488_(-2.0f, 0.0f, -2.0f, 3.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-3.0f, (float)18.0f, (float)6.0f));
        partDefinition.m_171599_("left_hind_leg", CubeListBuilder.m_171558_().m_171514_(0, 17).m_171480_().m_171488_(-1.0f, 0.0f, -2.0f, 3.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)3.0f, (float)18.0f, (float)6.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshDefinition, (int)64, (int)64);
    }

    protected Iterable<ModelPart> m_5608_() {
        return Iterables.concat((Iterable)super.m_5608_(), List.of(this.bags));
    }

    public void prepareMobModel(T entity, float limbSwing, float limbSwingAmount, float ageInTicks) {
        if (entity.m_21825_()) {
            this.f_103493_.m_104227_(0.0f, 14.5f, 4.0f);
            this.f_103493_.f_104203_ = -0.5235988f;
            this.bags.m_104227_(0.0f, 24.0f, -4.0f);
            this.bags.f_104203_ = this.f_103493_.f_104203_;
            if (this.f_102610_) {
                this.f_103492_.m_104227_(-1.0f, 13.0f, -3.75f);
            } else {
                this.f_103492_.m_104227_(0.0f, 9.0f, -3.0f);
            }
            this.f_103492_.f_104203_ = 0.0f;
            this.f_103492_.f_104204_ = 0.0f;
            this.f_170852_.m_104227_(-2.9f, 18.0f, 3.5f);
            this.f_170853_.m_104227_(2.9f, 18.0f, 3.5f);
            this.f_170854_.m_104227_(-3.0f, 18.0f, -5.0f);
            this.f_170855_.m_104227_(3.0f, 18.0f, -5.0f);
        } else {
            this.f_103493_.m_104227_(0.0f, 11.0f, 2.0f);
            this.f_103493_.f_104205_ = 0.0f;
            this.f_103493_.f_104203_ = 0.0f;
            this.bags.m_104227_(0.0f, 24.0f, 0.0f);
            this.bags.f_104203_ = 0.0f;
            this.f_170852_.f_104203_ = Mth.m_14089_((float)(limbSwing * 1.6662f)) * 0.2f * limbSwingAmount;
            this.f_170852_.m_104227_(-3.0f, 18.0f, 6.0f);
            this.f_170853_.f_104203_ = Mth.m_14089_((float)(limbSwing * 1.6662f + (float)Math.PI)) * 0.2f * limbSwingAmount;
            this.f_170853_.m_104227_(3.0f, 18.0f, 4.0f);
            this.f_170854_.f_104203_ = Mth.m_14089_((float)(limbSwing * 1.6662f + (float)Math.PI)) * 0.2f * limbSwingAmount;
            this.f_170854_.m_104227_(-3.0f, 18.0f, -5.0f);
            this.f_170855_.f_104203_ = Mth.m_14089_((float)(limbSwing * 1.6662f)) * 0.2f * limbSwingAmount;
            this.f_170855_.m_104227_(3.0f, 18.0f, -5.0f);
            this.f_103492_.m_104227_(0.0f, 12.0f, -6.0f);
        }
    }
}

